/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.camel;

import java.util.Map;
import org.activiti.camel.ActivitiEndpoint;
import org.activiti.camel.ExchangeUtils;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;

public class ActivitiProducer
extends DefaultProducer {
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    public static final String PROCESS_KEY_PROPERTY = "PROCESS_KEY_PROPERTY";
    public static final String PROCESS_ID_PROPERTY = "PROCESS_ID_PROPERTY";
    public static final String EXECUTION_ID_PROPERTY = "EXECUTION_ID_PROPERTY";
    private final long timeout;
    private final long timeResolution;
    private String processKey = null;
    private String activity = null;

    public ActivitiProducer(ActivitiEndpoint endpoint, long timeout, long timeResolution) {
        super((Endpoint)endpoint);
        String[] path = endpoint.getEndpointKey().split(":");
        this.processKey = path[1].replace("//", "");
        if (path.length > 2) {
            this.activity = path[2];
        }
        this.timeout = timeout;
        this.timeResolution = timeResolution;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.shouldStartProcess()) {
            ProcessInstance pi = this.startProcess(exchange);
            this.copyResultToCamel(exchange, pi);
        } else {
            this.signal(exchange);
        }
    }

    protected void copyResultToCamel(Exchange exchange, ProcessInstance pi) {
        exchange.setProperty(PROCESS_ID_PROPERTY, (Object)pi.getProcessInstanceId());
        Map<String, Object> returnVars = this.getActivitiEndpoint().getReturnVarMap();
        if (returnVars != null && returnVars.size() > 0) {
            Map processVariables = null;
            if (this.repositoryService.isActiviti5ProcessDefinition(pi.getProcessDefinitionId()).booleanValue()) {
                Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                processVariables = activiti5CompatibilityHandler.getVariables(pi);
            } else {
                processVariables = ((ExecutionEntity)pi).getVariables();
            }
            if (processVariables != null) {
                for (String variableName : returnVars.keySet()) {
                    if (!processVariables.containsKey(variableName)) continue;
                    exchange.setProperty(variableName, processVariables.get(variableName));
                }
            }
        }
    }

    protected boolean shouldStartProcess() {
        return this.activity == null;
    }

    protected void signal(Exchange exchange) {
        String processInstanceId = this.findProcessInstanceId(exchange);
        String executionId = (String)exchange.getProperty(EXECUTION_ID_PROPERTY, String.class);
        boolean firstTime = true;
        long initialTime = System.currentTimeMillis();
        Execution execution = null;
        while (firstTime || this.timeout > 0L && System.currentTimeMillis() - initialTime < this.timeout) {
            try {
                Thread.sleep(this.timeResolution);
            }
            catch (InterruptedException e) {
                throw new ActivitiException("error occured while waiting for activiti=" + this.activity + " for processInstanceId=" + processInstanceId);
            }
            firstTime = false;
            execution = executionId != null ? (Execution)this.runtimeService.createExecutionQuery().executionId(executionId).activityId(this.activity).singleResult() : (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey(this.processKey).processInstanceId(processInstanceId).activityId(this.activity).singleResult();
            if (execution == null) continue;
        }
        if (execution == null) {
            throw new ActivitiException("Couldn't find activity " + this.activity + " for processId " + processInstanceId + " in defined timeout.");
        }
        this.runtimeService.setVariables(execution.getId(), ExchangeUtils.prepareVariables(exchange, this.getActivitiEndpoint()));
        this.runtimeService.trigger(execution.getId());
    }

    protected String findProcessInstanceId(Exchange exchange) {
        String processInstanceId = (String)exchange.getProperty(PROCESS_ID_PROPERTY, String.class);
        if (processInstanceId != null) {
            return processInstanceId;
        }
        String processInstanceKey = (String)exchange.getProperty(PROCESS_KEY_PROPERTY, String.class);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(processInstanceKey).singleResult();
        if (processInstance == null) {
            throw new ActivitiException("Could not find activiti with key " + processInstanceKey);
        }
        return processInstance.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessInstance startProcess(Exchange exchange) {
        ActivitiEndpoint endpoint = this.getActivitiEndpoint();
        String key = (String)exchange.getProperty(PROCESS_KEY_PROPERTY, String.class);
        try {
            if (endpoint.isSetProcessInitiator()) {
                this.setProcessInitiator(ExchangeUtils.prepareInitiator(exchange, endpoint));
            }
            if (key == null) {
                ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(this.processKey, ExchangeUtils.prepareVariables(exchange, endpoint));
                return processInstance;
            }
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(this.processKey, key, ExchangeUtils.prepareVariables(exchange, endpoint));
            return processInstance;
        }
        finally {
            if (endpoint.isSetProcessInitiator()) {
                this.setProcessInitiator(null);
            }
        }
    }

    protected void setProcessInitiator(String processInitiator) {
        if (this.identityService == null) {
            throw new ActivitiException("IdentityService is missing and must be provided to set process initiator.");
        }
        this.identityService.setAuthenticatedUserId(processInitiator);
    }

    protected ActivitiEndpoint getActivitiEndpoint() {
        return (ActivitiEndpoint)this.getEndpoint();
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

