/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.chain.SimpleChain;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ChainResultObj;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicServiceCommonSupport;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.service.ITsaMaCoefficientsService;
import com.netsteadfast.greenstep.bsc.service.ITsaMeasureFreqService;
import com.netsteadfast.greenstep.bsc.service.ITsaService;
import com.netsteadfast.greenstep.bsc.util.PerformanceScoreChainUtils;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.BbTsa;
import com.netsteadfast.greenstep.po.hbm.BbTsaMaCoefficients;
import com.netsteadfast.greenstep.po.hbm.BbTsaMeasureFreq;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.TsaMaCoefficientsVO;
import com.netsteadfast.greenstep.vo.TsaMeasureFreqVO;
import com.netsteadfast.greenstep.vo.TsaVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.lang3.StringUtils;
import org.espy.arima.DefaultArimaForecaster;
import org.espy.arima.DefaultArimaProcess;

public class TimeSeriesAnalysisUtils {
    private static ITsaService<TsaVO, BbTsa, String> tsaService = (ITsaService)AppContext.getBean("bsc.service.TsaService");
    private static ITsaMaCoefficientsService<TsaMaCoefficientsVO, BbTsaMaCoefficients, String> tsaMaCoefficientsService = (ITsaMaCoefficientsService)AppContext.getBean("bsc.service.TsaMaCoefficientsService");
    private static ITsaMeasureFreqService<TsaMeasureFreqVO, BbTsaMeasureFreq, String> tsaMeasureFreqService = (ITsaMeasureFreqService)AppContext.getBean("bsc.service.TsaMeasureFreqService");
    private static IOrganizationService<OrganizationVO, BbOrganization, String> organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    private static IEmployeeService<EmployeeVO, BbEmployee, String> employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");

    public static TsaVO getParam(String tsaOid) throws ServiceException, Exception {
        if (StringUtils.isBlank(tsaOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        TsaVO tsa = new TsaVO();
        tsa.setOid(tsaOid);
        DefaultResult<TsaVO> result = tsaService.findObjectByOid(tsa);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        tsa = result.getValue();
        return tsa;
    }

    public static TsaMeasureFreqVO getMeasureFreq(TsaVO tsa) throws ServiceException, Exception {
        TsaMeasureFreqVO measureFreq = new TsaMeasureFreqVO();
        measureFreq.setTsaOid(tsa.getOid());
        DefaultResult<TsaMeasureFreqVO> result = tsaMeasureFreqService.findByUK(measureFreq);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        measureFreq = result.getValue();
        return measureFreq;
    }

    public static List<BbTsaMaCoefficients> getCoefficients(TsaVO tsa) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tsaOid", tsa.getOid());
        HashMap<String, String> orderByParam = new HashMap<String, String>();
        orderByParam.put("seq", "ASC");
        return tsaMaCoefficientsService.findListByParams(paramMap, null, orderByParam);
    }

    public static double[] getForecastNext(TsaVO tsa, double[] observations) throws ServiceException, Exception {
        if (observations == null || observations.length < 1) {
            throw new IllegalArgumentException("observations array cannot zero size");
        }
        List<BbTsaMaCoefficients> coefficients = TimeSeriesAnalysisUtils.getCoefficients(tsa);
        if (coefficients == null || coefficients.size() != 3) {
            throw new IllegalStateException("Ma coefficients data error");
        }
        DefaultArimaProcess arimaProcess = new DefaultArimaProcess();
        arimaProcess.setMaCoefficients(coefficients.get(0).getSeqValue(), coefficients.get(1).getSeqValue(), coefficients.get(2).getSeqValue());
        arimaProcess.setIntegrationOrder(tsa.getIntegrationOrder());
        DefaultArimaForecaster arimaForecaster = new DefaultArimaForecaster(arimaProcess, observations);
        double[] forecast = arimaForecaster.next(tsa.getForecastNext());
        return forecast;
    }

    public static VisionVO getResult(String tsaOid, String visionOid, String startDate, String endDate, String startYearDate, String endYearDate, String frequency, String dataFor, String measureDataOrganizationOid, String measureDataEmployeeOid) throws ServiceException, Exception {
        ChainResultObj chainResult = PerformanceScoreChainUtils.getResult(visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid);
        if (chainResult.getValue() == null || ((BscStructTreeObj)chainResult.getValue()).getVisions() == null || ((BscStructTreeObj)chainResult.getValue()).getVisions().size() == 0) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        TsaVO tsa = TimeSeriesAnalysisUtils.getParam(tsaOid);
        BscStructTreeObj resultObj = (BscStructTreeObj)chainResult.getValue();
        VisionVO vision = resultObj.getVisions().get(0);
        double[] observations = new double[vision.getDateRangeScores().size()];
        int i = 0;
        while (i < observations.length) {
            observations[i] = Double.parseDouble(Float.toString(vision.getDateRangeScores().get(i).getScore()));
            ++i;
        }
        double[] forecastNext = TimeSeriesAnalysisUtils.getForecastNext(tsa, observations);
        int i2 = 0;
        while (i2 < forecastNext.length) {
            vision.getForecastNext().add(forecastNext[i2]);
            ++i2;
        }
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            observations = new double[perspective.getDateRangeScores().size()];
            int i3 = 0;
            while (i3 < observations.length) {
                observations[i3] = Double.parseDouble(Float.toString(perspective.getDateRangeScores().get(i3).getScore()));
                ++i3;
            }
            forecastNext = TimeSeriesAnalysisUtils.getForecastNext(tsa, observations);
            i3 = 0;
            while (i3 < forecastNext.length) {
                perspective.getForecastNext().add(forecastNext[i3]);
                ++i3;
            }
            for (ObjectiveVO objective : perspective.getObjectives()) {
                observations = new double[objective.getDateRangeScores().size()];
                int i4 = 0;
                while (i4 < observations.length) {
                    observations[i4] = Double.parseDouble(Float.toString(objective.getDateRangeScores().get(i4).getScore()));
                    ++i4;
                }
                forecastNext = TimeSeriesAnalysisUtils.getForecastNext(tsa, observations);
                i4 = 0;
                while (i4 < forecastNext.length) {
                    objective.getForecastNext().add(forecastNext[i4]);
                    ++i4;
                }
                for (KpiVO kpi : objective.getKpis()) {
                    observations = new double[kpi.getDateRangeScores().size()];
                    int i5 = 0;
                    while (i5 < observations.length) {
                        observations[i5] = Double.parseDouble(Float.toString(kpi.getDateRangeScores().get(i5).getScore()));
                        ++i5;
                    }
                    forecastNext = TimeSeriesAnalysisUtils.getForecastNext(tsa, observations);
                    i5 = 0;
                    while (i5 < forecastNext.length) {
                        kpi.getForecastNext().add(forecastNext[i5]);
                        ++i5;
                    }
                }
            }
        }
        return vision;
    }

    public static String getResultForExcel(String tsaOid, String visionOid, String startDate, String endDate, String startYearDate, String endYearDate, String frequency, String dataFor, String measureDataOrganizationOid, String measureDataEmployeeOid, String visionDateRangeChartPngData, String perspectiveDateRangeChartPngData, String objectiveDateRangeChartPngData, String dateRangeChartPngData) throws ServiceException, Exception {
        VisionVO vision = TimeSeriesAnalysisUtils.getResult(tsaOid, visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid);
        TsaVO tsa = TimeSeriesAnalysisUtils.getParam(tsaOid);
        List<BbTsaMaCoefficients> coefficients = TimeSeriesAnalysisUtils.getCoefficients(tsa);
        ContextBase context = new ContextBase();
        context.put("tsaVisionResult", vision);
        context.put("tsa", tsa);
        context.put("coefficients", coefficients);
        context.put("visionName", vision.getTitle());
        if ("6".equals(frequency) || "5".equals(frequency) || "4".equals(frequency)) {
            context.put("date1", startYearDate);
            context.put("date2", endYearDate);
        } else {
            context.put("date1", startDate);
            context.put("date2", endDate);
        }
        context.put("frequencyName", BscMeasureDataFrequency.getFrequencyMap(false).get(frequency));
        context.put("dataFor", dataFor);
        context.put("organizationName", "");
        context.put("employeeName", "");
        if (!"all".equals(measureDataOrganizationOid) && !StringUtils.isBlank(measureDataOrganizationOid)) {
            context.put("organizationName", BscBaseLogicServiceCommonSupport.findOrganizationData(organizationService, measureDataOrganizationOid).getName());
        }
        if (!"all".equals(measureDataEmployeeOid) && !StringUtils.isBlank(measureDataEmployeeOid)) {
            context.put("employeeName", BscBaseLogicServiceCommonSupport.findEmployeeData(employeeService, measureDataEmployeeOid).getFullName());
        }
        context.put("visionDateRangeChartPngData", visionDateRangeChartPngData);
        context.put("perspectiveDateRangeChartPngData", perspectiveDateRangeChartPngData);
        context.put("objectiveDateRangeChartPngData", objectiveDateRangeChartPngData);
        context.put("dateRangeChartPngData", dateRangeChartPngData);
        SimpleChain chain = new SimpleChain();
        ChainResultObj resultObj = chain.getResultFromResource("timeSeriesAnalysisExcelCommandContentChain", context);
        if (!(resultObj.getValue() instanceof String)) {
            throw new IllegalStateException("timeSeriesAnalysisExcelCommandContentChain error!");
        }
        return (String)resultObj.getValue();
    }
}

