/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.util.LocaleLanguageUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class StrategyMapUtils {
    protected static Logger logger;
    private static final String _CONFIG = "META-INF/strategy-map.json";
    private static String _datas;
    private static Map<String, Object> _configDataMap;
    private static int ONE_HEIGHT;
    private static int MIN_WIDTH;
    private static int MIN_HEIGHT;
    private static int MAX_WIDTH;
    private static int MAX_HEIGHT;
    private static String SRC_IMG;
    private static IVisionService<VisionVO, BbVision, String> visionService;
    private static IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService;

    static {
        block23: {
            logger = Logger.getLogger(StrategyMapUtils.class);
            _datas = " { } ";
            ONE_HEIGHT = 150;
            MIN_WIDTH = 800;
            MIN_HEIGHT = 600;
            MAX_WIDTH = 4096;
            MAX_HEIGHT = 2160;
            SRC_IMG = "META-INF/resource/s-map-bg-grid.png";
            try {
                try {
                    InputStream is = LocaleLanguageUtils.class.getClassLoader().getResource(_CONFIG).openStream();
                    _datas = IOUtils.toString(is, "utf-8");
                    is.close();
                    is = null;
                    _configDataMap = StrategyMapUtils.loadDatas();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (_configDataMap == null) {
                        _configDataMap = new HashMap<String, Object>();
                    }
                    if (_configDataMap.get("minWidth") != null) {
                        MIN_WIDTH = (Integer)_configDataMap.get("minWidth");
                    }
                    if (_configDataMap.get("minHeight") != null) {
                        MIN_HEIGHT = (Integer)_configDataMap.get("minHeight");
                    }
                    if (_configDataMap.get("maxWidth") != null) {
                        MAX_WIDTH = (Integer)_configDataMap.get("maxWidth");
                    }
                    if (_configDataMap.get("maxHeight") != null) {
                        MAX_HEIGHT = (Integer)_configDataMap.get("maxHeight");
                    }
                    if (!StringUtils.isBlank((String)_configDataMap.get("background-img"))) {
                        SRC_IMG = (String)_configDataMap.get("background-img");
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (_configDataMap == null) {
                    _configDataMap = new HashMap<String, Object>();
                }
                if (_configDataMap.get("minWidth") != null) {
                    MIN_WIDTH = (Integer)_configDataMap.get("minWidth");
                }
                if (_configDataMap.get("minHeight") != null) {
                    MIN_HEIGHT = (Integer)_configDataMap.get("minHeight");
                }
                if (_configDataMap.get("maxWidth") != null) {
                    MAX_WIDTH = (Integer)_configDataMap.get("maxWidth");
                }
                if (_configDataMap.get("maxHeight") != null) {
                    MAX_HEIGHT = (Integer)_configDataMap.get("maxHeight");
                }
                if (!StringUtils.isBlank((String)_configDataMap.get("background-img"))) {
                    SRC_IMG = (String)_configDataMap.get("background-img");
                }
                throw throwable;
            }
            if (_configDataMap == null) {
                _configDataMap = new HashMap<String, Object>();
            }
            if (_configDataMap.get("minWidth") != null) {
                MIN_WIDTH = (Integer)_configDataMap.get("minWidth");
            }
            if (_configDataMap.get("minHeight") != null) {
                MIN_HEIGHT = (Integer)_configDataMap.get("minHeight");
            }
            if (_configDataMap.get("maxWidth") != null) {
                MAX_WIDTH = (Integer)_configDataMap.get("maxWidth");
            }
            if (_configDataMap.get("maxHeight") != null) {
                MAX_HEIGHT = (Integer)_configDataMap.get("maxHeight");
            }
            if (!StringUtils.isBlank((String)_configDataMap.get("background-img"))) {
                SRC_IMG = (String)_configDataMap.get("background-img");
            }
        }
        visionService = (IVisionService)AppContext.getBean("bsc.service.VisionService");
        perspectiveService = (IPerspectiveService)AppContext.getBean("bsc.service.PerspectiveService");
    }

    public static Map<String, Object> loadDatas() {
        Map datas = null;
        try {
            datas = new ObjectMapper().readValue(_datas, LinkedHashMap.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datas;
    }

    public static int getWidth(int width) {
        if (width < MIN_WIDTH) {
            return MIN_WIDTH;
        }
        if (width > MAX_WIDTH) {
            return MAX_WIDTH;
        }
        return width;
    }

    public static int getHeight(int height) {
        if (height < MIN_HEIGHT) {
            return MIN_HEIGHT;
        }
        if (height > MAX_HEIGHT) {
            return MAX_HEIGHT;
        }
        return height;
    }

    public static byte[] getBackgroundImage(String visionOid, int width, int height) throws Exception {
        if (StringUtils.isBlank(visionOid)) {
            throw new Exception("vision OID is blank!");
        }
        VisionVO vision = new VisionVO();
        vision.setOid(visionOid);
        DefaultResult<VisionVO> result = visionService.findObjectByOid(vision);
        vision = result.getValue();
        return StrategyMapUtils.getBackgroundImage(vision, width, height);
    }

    public static byte[] getBackgroundImage(VisionVO vision, int width, int height) throws Exception {
        byte[] data = null;
        List<PerspectiveVO> perspectivesList = perspectiveService.findForListByVisionOid(vision.getOid());
        BufferedImage bi = new BufferedImage(StrategyMapUtils.getWidth(width), StrategyMapUtils.getHeight(height), 1);
        Graphics2D g2 = bi.createGraphics();
        Font font = new Font("", 1, 16);
        g2.setFont(font);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int fontLeft = 3;
        int fontAddY = ONE_HEIGHT;
        int fontNowY = 80;
        int lineAddY = 60;
        BufferedImage bg = ImageIO.read(StrategyMapUtils.class.getClassLoader().getResource(SRC_IMG));
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                g2.drawImage((Image)bg, x, y, null);
                x += bg.getWidth();
            }
            y += bg.getHeight();
        }
        BasicStroke dashed = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
        int i = 0;
        while (perspectivesList != null && i < perspectivesList.size()) {
            PerspectiveVO perspective = perspectivesList.get(i);
            if (fontNowY > bi.getHeight()) {
                logger.warn("Perspective item over heigh, no paint it : " + perspective.getName());
            } else if (fontLeft > bi.getWidth()) {
                logger.warn("Perspective item over width, no paint it : " + perspective.getName());
            } else {
                g2.setPaint(new Color(64, 64, 64));
                g2.drawString(perspective.getName(), fontLeft, fontNowY);
                g2.setStroke(dashed);
                g2.drawLine(0, fontNowY + lineAddY, width, fontNowY + lineAddY);
                fontNowY += fontAddY;
            }
            ++i;
        }
        ByteArrayOutputStream baos = null;
        try {
            try {
                baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bi, "PNG", baos);
                data = baos.toByteArray();
                baos.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                baos = null;
            }
        }
        finally {
            baos = null;
        }
        return data;
    }

    public static String createUpload(String visionOid, int width, int height) throws ServiceException, Exception {
        if (StringUtils.isBlank(visionOid)) {
            throw new Exception("vision OID is blank!");
        }
        VisionVO vision = new VisionVO();
        vision.setOid(visionOid);
        DefaultResult<VisionVO> result = visionService.findObjectByOid(vision);
        vision = result.getValue();
        return StrategyMapUtils.createUpload(vision, width, height);
    }

    public static String createUpload(VisionVO vision, int width, int height) throws ServiceException, Exception {
        byte[] data = StrategyMapUtils.getBackgroundImage(vision, width, height);
        return UploadSupportUtils.create(Constants.getSystem(), "tmp", false, data, "strategy-map-background.png");
    }

    public static String getBackgroundImageBase64FromUpload(String uploadOid) throws ServiceException, Exception {
        byte[] data = UploadSupportUtils.getDataBytes(uploadOid);
        if (data == null) {
            return "";
        }
        return "data:image/png;base64," + Base64.getEncoder().encodeToString(data);
    }

    public static int getMIN_HEIGHT() {
        return MIN_HEIGHT;
    }

    public static int getONE_HEIGHT() {
        return ONE_HEIGHT;
    }
}

