/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.chain.SimpleChain;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ChainResultObj;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.model.PeriodTrendsData;
import com.netsteadfast.greenstep.bsc.util.BscFormulaUtils;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.bsc.util.PerformanceScoreChainUtils;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.lang3.math.NumberUtils;

public class PeriodTrendsCalUtils {
    private static final String KPI_PeriodTrendsTemplateResource = "META-INF/resource/kpi-period-trends-report-body.ftl";

    private static void fillKpiPeriodTrends(List<PeriodTrendsData<KpiVO>> result, ChainResultObj result1, ChainResultObj result2, boolean sameFrequency) throws ServiceException, Exception {
        if (result1.getValue() == null || ((BscStructTreeObj)result1.getValue()).getVisions() == null || ((BscStructTreeObj)result1.getValue()).getVisions().size() == 0) {
            throw new ServiceException("No found previous period data can do calculate change score!<BR/>");
        }
        if (result2.getValue() == null || ((BscStructTreeObj)result2.getValue()).getVisions() == null || ((BscStructTreeObj)result2.getValue()).getVisions().size() == 0) {
            throw new ServiceException("No found current period data can do calculate change score!<BR/>");
        }
        VisionVO visionCV = ((BscStructTreeObj)result1.getValue()).getVisions().get(0);
        VisionVO visionPV = ((BscStructTreeObj)result2.getValue()).getVisions().get(0);
        for (PerspectiveVO perspectiveVO : visionCV.getPerspectives()) {
            for (ObjectiveVO objective : perspectiveVO.getObjectives()) {
                for (KpiVO kpi : objective.getKpis()) {
                    PeriodTrendsData<KpiVO> periodData = new PeriodTrendsData<KpiVO>();
                    periodData.setCurrent(kpi);
                    result.add(periodData);
                }
            }
        }
        for (PeriodTrendsData periodTrendsData : result) {
            for (PerspectiveVO perspective : visionPV.getPerspectives()) {
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    for (KpiVO kpi : objective.getKpis()) {
                        if (!((KpiVO)periodTrendsData.getCurrent()).getId().equals(kpi.getId())) continue;
                        periodTrendsData.setPrevious(kpi);
                    }
                }
            }
            if (periodTrendsData.getPrevious() == null) {
                throw new ServiceException("No found previous period data can do calculate change score!<BR/>KPI: " + ((KpiVO)periodTrendsData.getCurrent()).getName());
            }
            Object ans = BscFormulaUtils.parseKPIPeroidScoreChangeValue(((KpiVO)periodTrendsData.getCurrent()).getTrendsFormula(), ((KpiVO)periodTrendsData.getCurrent()).getScore(), ((KpiVO)periodTrendsData.getPrevious()).getScore());
            String change = String.valueOf(ans);
            if (NumberUtils.isCreatable(String.valueOf(change))) {
                periodTrendsData.setChange(NumberUtils.toFloat(change));
            }
            if (!sameFrequency || ((KpiVO)periodTrendsData.getCurrent()).getDateRangeScores().size() != ((KpiVO)periodTrendsData.getPrevious()).getDateRangeScores().size()) continue;
            PeriodTrendsCalUtils.fillKpiPeriodTrendsDateRangeScore(periodTrendsData);
        }
    }

    private static void fillKpiPeriodTrendsDateRangeScore(PeriodTrendsData<KpiVO> periodData) throws Exception {
        int i = 0;
        while (i < periodData.getCurrent().getDateRangeScores().size()) {
            DateRangeScoreVO currentRangeScore = periodData.getCurrent().getDateRangeScores().get(i);
            DateRangeScoreVO previousRangeScore = periodData.getPrevious().getDateRangeScores().get(i);
            periodData.getDateRangeLabels().add(String.valueOf(currentRangeScore.getDate()) + "(C) / " + previousRangeScore.getDate() + "(P)");
            float score = 0.0f;
            Object ans = BscFormulaUtils.parseKPIPeroidScoreChangeValue(periodData.getCurrent().getTrendsFormula(), currentRangeScore.getScore(), previousRangeScore.getScore());
            String change = String.valueOf(ans);
            if (NumberUtils.isCreatable(String.valueOf(change))) {
                score = NumberUtils.toFloat(change);
            }
            periodData.getDateRangeScores().add(Float.valueOf(NumberUtils.toFloat(BscReportSupportUtils.parse2(score))));
            periodData.getCurrentDateRangeScores().add(Float.valueOf(currentRangeScore.getScore()));
            periodData.getPreviousDateRangeScores().add(Float.valueOf(previousRangeScore.getScore()));
            ++i;
        }
        if (periodData.getDateRangeLabels().size() > 1) {
            periodData.setCanChart("Y");
        }
    }

    public static List<PeriodTrendsData<KpiVO>> getKpiScoreChange(String visionOid1, String startDate1, String endDate1, String startYearDate1, String endYearDate1, String frequency1, String dataFor1, String measureDataOrganizationOid1, String measureDataEmployeeOid1, String visionOid2, String startDate2, String endDate2, String startYearDate2, String endYearDate2, String frequency2, String dataFor2, String measureDataOrganizationOid2, String measureDataEmployeeOid2) throws ServiceException, Exception {
        ArrayList<PeriodTrendsData<KpiVO>> result = new ArrayList<PeriodTrendsData<KpiVO>>();
        Context context1 = PerformanceScoreChainUtils.getContext(visionOid1, startDate1, endDate1, startYearDate1, endYearDate1, frequency1, dataFor1, measureDataOrganizationOid1, measureDataEmployeeOid1);
        Context context2 = PerformanceScoreChainUtils.getContext(visionOid2, startDate2, endDate2, startYearDate2, endYearDate2, frequency2, dataFor2, measureDataOrganizationOid2, measureDataEmployeeOid2);
        PeriodTrendsCalUtils.fillKpiPeriodTrends(result, PerformanceScoreChainUtils.getResult(context1), PerformanceScoreChainUtils.getResult(context2), frequency1.equals(frequency2));
        return result;
    }

    public static String renderKpiPeriodTrendsBody(List<PeriodTrendsData<KpiVO>> periodDatas, String currentPeriodDateRange, String previousPeriodDateRange) throws Exception {
        if (periodDatas == null || periodDatas.size() < 1) {
            return "";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("periodDatas", periodDatas);
        paramMap.put("currentPeriodDateRange", currentPeriodDateRange);
        paramMap.put("previousPeriodDateRange", previousPeriodDateRange);
        String content = TemplateUtils.processTemplate("resourceTemplate", PeriodTrendsCalUtils.class.getClassLoader(), KPI_PeriodTrendsTemplateResource, paramMap);
        return content;
    }

    public static String renderKpiPeriodTrendsBody(String visionOid1, String startDate1, String endDate1, String startYearDate1, String endYearDate1, String frequency1, String dataFor1, String measureDataOrganizationOid1, String measureDataEmployeeOid1, String visionOid2, String startDate2, String endDate2, String startYearDate2, String endYearDate2, String frequency2, String dataFor2, String measureDataOrganizationOid2, String measureDataEmployeeOid2) throws ServiceException, Exception {
        String currentPeriodDateRange = PeriodTrendsCalUtils.getDateRange(frequency1, startYearDate1, endYearDate1, startDate1, endDate1);
        String previousPeriodDateRange = PeriodTrendsCalUtils.getDateRange(frequency2, startYearDate2, endYearDate2, startDate2, endDate2);
        return PeriodTrendsCalUtils.renderKpiPeriodTrendsBody(PeriodTrendsCalUtils.getKpiScoreChange(visionOid1, startDate1, endDate1, startYearDate1, endYearDate1, frequency1, dataFor1, measureDataOrganizationOid1, measureDataEmployeeOid1, visionOid2, startDate2, endDate2, startYearDate2, endYearDate2, frequency2, dataFor2, measureDataOrganizationOid2, measureDataEmployeeOid2), currentPeriodDateRange, previousPeriodDateRange);
    }

    public static String generateKpiPeriodTrendsExcel(List<PeriodTrendsData<KpiVO>> periodDatas, String currentPeriodDateRange, String previousPeriodDateRange) throws Exception {
        ContextBase context = new ContextBase();
        context.put("periodDatas", periodDatas);
        context.put("currentPeriodDateRange", currentPeriodDateRange);
        context.put("previousPeriodDateRange", previousPeriodDateRange);
        SimpleChain chain = new SimpleChain();
        ChainResultObj resultObj = chain.getResultFromResource("kpiPeriodTrendsExcelCommandExcelContentChain", context);
        if (!(resultObj.getValue() instanceof String)) {
            throw new IllegalStateException("kpiPeriodTrendsExcelCommandExcelContentChain error!");
        }
        return (String)resultObj.getValue();
    }

    public static String generateKpiPeriodTrendsExcel(String visionOid1, String startDate1, String endDate1, String startYearDate1, String endYearDate1, String frequency1, String dataFor1, String measureDataOrganizationOid1, String measureDataEmployeeOid1, String visionOid2, String startDate2, String endDate2, String startYearDate2, String endYearDate2, String frequency2, String dataFor2, String measureDataOrganizationOid2, String measureDataEmployeeOid2) throws ServiceException, Exception {
        String currentPeriodDateRange = PeriodTrendsCalUtils.getDateRange(frequency1, startYearDate1, endYearDate1, startDate1, endDate1);
        String previousPeriodDateRange = PeriodTrendsCalUtils.getDateRange(frequency2, startYearDate2, endYearDate2, startDate2, endDate2);
        return PeriodTrendsCalUtils.generateKpiPeriodTrendsExcel(PeriodTrendsCalUtils.getKpiScoreChange(visionOid1, startDate1, endDate1, startYearDate1, endYearDate1, frequency1, dataFor1, measureDataOrganizationOid1, measureDataEmployeeOid1, visionOid2, startDate2, endDate2, startYearDate2, endYearDate2, frequency2, dataFor2, measureDataOrganizationOid2, measureDataEmployeeOid2), currentPeriodDateRange, previousPeriodDateRange);
    }

    public static String getDateRange(String frequency, String startYearDate, String endYearDate, String startDate, String endDate) {
        String dateRange = String.valueOf(startYearDate) + " ~ " + endYearDate;
        if ("1".equals(frequency) || "2".equals(frequency) || "3".equals(frequency)) {
            dateRange = String.valueOf(startDate) + " ~ " + endDate;
        }
        return "Frequency(" + BscMeasureDataFrequency.getFrequencyMap(false).get(frequency) + ") " + dateRange;
    }
}

