/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.chain.SimpleChain;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.BaseValueObj;
import com.netsteadfast.greenstep.base.model.ChainResultObj;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicServiceCommonSupport;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IKpiEmplService;
import com.netsteadfast.greenstep.bsc.service.IKpiOrgaService;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbKpiEmpl;
import com.netsteadfast.greenstep.po.hbm.BbKpiOrga;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.util.DataUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiEmplVO;
import com.netsteadfast.greenstep.vo.KpiOrgaVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.transaction.support.TransactionTemplate;

public class PerformanceScoreChainUtils {
    protected static Logger logger = Logger.getLogger(PerformanceScoreChainUtils.class);
    private static final int MAX_SCORE_FIELD_SIZE = 13;
    private static IVisionService<VisionVO, BbVision, String> visionService = (IVisionService)AppContext.getBean("bsc.service.VisionService");
    private static IOrganizationService<OrganizationVO, BbOrganization, String> organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    private static IEmployeeService<EmployeeVO, BbEmployee, String> employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");
    private static IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService = (IMonitorItemScoreService)AppContext.getBean("bsc.service.MonitorItemScoreService");
    private static IKpiEmplService<KpiEmplVO, BbKpiEmpl, String> kpiEmplService = (IKpiEmplService)AppContext.getBean("bsc.service.KpiEmplService");
    private static IKpiOrgaService<KpiOrgaVO, BbKpiOrga, String> kpiOrgaService = (IKpiOrgaService)AppContext.getBean("bsc.service.KpiOrgaService");
    private static TransactionTemplate transactionTemplate = DataUtils.getTransactionTemplate();

    public static void clearExpressionContentOut(VisionVO vision) throws Exception {
        if (vision == null) {
            return;
        }
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            for (ObjectiveVO objective : perspective.getObjectives()) {
                for (KpiVO kpi : objective.getKpis()) {
                    kpi.getFormula().setExpression("");
                    kpi.getFormula().setDescription("");
                    kpi.getTrendsFormula().setExpression("");
                    kpi.getTrendsFormula().setDescription("");
                    kpi.getAggregationMethod().setExpression1("");
                    kpi.getAggregationMethod().setExpression2("");
                    kpi.getAggregationMethod().setDescription("");
                }
            }
        }
    }

    public static void clearExpressionContentOut(ChainResultObj result) throws Exception {
        if (result.getValue() == null || ((BscStructTreeObj)result.getValue()).getVisions() == null || ((BscStructTreeObj)result.getValue()).getVisions().size() == 0) {
            return;
        }
        List<VisionVO> visions = ((BscStructTreeObj)result.getValue()).getVisions();
        for (VisionVO vision : visions) {
            PerformanceScoreChainUtils.clearExpressionContentOut(vision);
        }
    }

    public static Context getContext(String visionOid, String startDate, String endDate, String startYearDate, String endYearDate, String frequency, String dataFor, String measureDataOrganizationOid, String measureDataEmployeeOid) throws ServiceException, Exception {
        DefaultResult<BaseValueObj> result;
        ContextBase context = new ContextBase();
        context.put("visionOid", visionOid);
        context.put("startDate", startDate);
        context.put("endDate", endDate);
        context.put("startYearDate", startYearDate);
        context.put("endYearDate", endYearDate);
        context.put("frequency", frequency);
        context.put("dataFor", dataFor);
        context.put("orgId", "*");
        context.put("empId", "*");
        context.put("account", "");
        if (!"all".equals(measureDataOrganizationOid) && !StringUtils.isBlank(measureDataOrganizationOid)) {
            OrganizationVO organization = new OrganizationVO();
            organization.setOid(measureDataOrganizationOid);
            result = organizationService.findObjectByOid(organization);
            if (result.getValue() == null) {
                throw new ServiceException(result.getSystemMessage().getValue());
            }
            organization = result.getValue();
            context.put("orgId", organization.getOrgId());
        }
        if (!"all".equals(measureDataEmployeeOid) && !StringUtils.isBlank(measureDataEmployeeOid)) {
            EmployeeVO employee = new EmployeeVO();
            employee.setOid(measureDataEmployeeOid);
            result = employeeService.findObjectByOid(employee);
            if (result.getValue() == null) {
                throw new ServiceException(result.getSystemMessage().getValue());
            }
            employee = (EmployeeVO)result.getValue();
            context.put("empId", employee.getEmpId());
            context.put("account", employee.getAccount());
        }
        return context;
    }

    public static ChainResultObj getResult(Context context) throws ServiceException, Exception {
        SimpleChain chain = new SimpleChain();
        ChainResultObj resultObj = chain.getResultFromResource("performanceScoreChain", context);
        return resultObj;
    }

    public static ChainResultObj getResult(String visionOid, String startDate, String endDate, String startYearDate, String endYearDate, String frequency, String dataFor, String measureDataOrganizationOid, String measureDataEmployeeOid) throws ServiceException, Exception {
        return PerformanceScoreChainUtils.getResult(PerformanceScoreChainUtils.getContext(visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid));
    }

    public static void createOrUpdateMonitorItemScoreCurrentDateForEmployees(String frequency) throws ServiceException, Exception {
        Map<String, String> employeeMap = employeeService.findForMap(false);
        if (employeeMap == null || employeeMap.size() < 1) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (Map.Entry<String, String> emp : employeeMap.entrySet()) {
            EmployeeVO employee = BscBaseLogicServiceCommonSupport.findEmployeeData(employeeService, emp.getKey());
            paramMap.put("empId", employee.getEmpId());
            if (kpiEmplService.countByParams(paramMap) < 1L) continue;
            try {
                PerformanceScoreChainUtils.createOrUpdateMonitorItemScoreCurrentDate(frequency, "employee", "", employee.getOid());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void createOrUpdateMonitorItemScoreCurrentDateForOrganizations(String frequency) throws ServiceException, Exception {
        Map<String, String> organizationMap = organizationService.findForMap(false);
        if (organizationMap == null || organizationMap.size() < 1) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (Map.Entry<String, String> org : organizationMap.entrySet()) {
            OrganizationVO organization = BscBaseLogicServiceCommonSupport.findOrganizationData(organizationService, org.getKey());
            paramMap.put("orgId", organization.getOrgId());
            if (kpiOrgaService.countByParams(paramMap) < 1L) continue;
            try {
                PerformanceScoreChainUtils.createOrUpdateMonitorItemScoreCurrentDate(frequency, "organization", organization.getOid(), "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void createOrUpdateMonitorItemScoreCurrentDate(String frequency, String dataFor, String measureDataOrganizationOid, String measureDataEmployeeOid) throws ServiceException, Exception {
        String dateVal = SimpleUtils.getStrYMD("");
        String year = dateVal.substring(0, 4);
        String startDate = "";
        String endDate = "";
        String startYearDate = year;
        String endYearDate = year;
        if ("3".equals(frequency) || "2".equals(frequency)) {
            Map<String, String> dateMap = BscMeasureDataFrequency.getWeekOrMonthStartEnd(frequency, dateVal, dateVal);
            startDate = dateMap.get("startDate");
            endDate = dateMap.get("endDate");
        }
        if ("1".equals(frequency)) {
            startDate = dateVal;
            endDate = dateVal;
        }
        Map<String, String> visions = visionService.findForMap(false);
        for (Map.Entry<String, String> visionData : visions.entrySet()) {
            String visionOid = visionData.getKey();
            Context context = PerformanceScoreChainUtils.getContext(visionOid, startDate, endDate, startYearDate, endYearDate, frequency, dataFor, measureDataOrganizationOid, measureDataEmployeeOid);
            PerformanceScoreChainUtils.createOrUpdateMonitorItemScore(dateVal, context);
        }
    }

    public static void createOrUpdateMonitorItemScore(String dateVal, Context context) throws ServiceException, Exception {
        ChainResultObj result = PerformanceScoreChainUtils.getResult(context);
        if (result.getValue() == null || ((BscStructTreeObj)result.getValue()).getVisions() == null || ((BscStructTreeObj)result.getValue()).getVisions().size() == 0) {
            logger.warn("No data!");
            return;
        }
        String frequency = (String)context.get("frequency");
        String orgId = (String)context.get("orgId");
        String empId = (String)context.get("empId");
        List<VisionVO> visions = ((BscStructTreeObj)result.getValue()).getVisions();
        for (VisionVO vision : visions) {
            List<PerspectiveVO> perspectives = vision.getPerspectives();
            MonitorItemScoreVO visionMonitorItemScore = PerformanceScoreChainUtils.getMonitorItemScore(dateVal, frequency, orgId, empId, "1", vision.getVisId());
            PerformanceScoreChainUtils.setScore(visionMonitorItemScore, vision.getScore());
            PerformanceScoreChainUtils.saveOrUpdateMonitorItemScore(visionMonitorItemScore);
            for (PerspectiveVO perspective : perspectives) {
                List<ObjectiveVO> objectives = perspective.getObjectives();
                MonitorItemScoreVO perspectiveMonitorItemScore = PerformanceScoreChainUtils.getMonitorItemScore(dateVal, frequency, orgId, empId, "2", perspective.getPerId());
                PerformanceScoreChainUtils.setScore(perspectiveMonitorItemScore, perspective.getScore());
                PerformanceScoreChainUtils.saveOrUpdateMonitorItemScore(perspectiveMonitorItemScore);
                for (ObjectiveVO objective : objectives) {
                    List<KpiVO> kpis = objective.getKpis();
                    MonitorItemScoreVO objectiveMonitorItemScore = PerformanceScoreChainUtils.getMonitorItemScore(dateVal, frequency, orgId, empId, "3", objective.getObjId());
                    PerformanceScoreChainUtils.setScore(objectiveMonitorItemScore, objective.getScore());
                    PerformanceScoreChainUtils.saveOrUpdateMonitorItemScore(objectiveMonitorItemScore);
                    for (KpiVO kpi : kpis) {
                        MonitorItemScoreVO kpiMonitorItemScore = PerformanceScoreChainUtils.getMonitorItemScore(dateVal, frequency, orgId, empId, "4", kpi.getId());
                        PerformanceScoreChainUtils.setScore(kpiMonitorItemScore, kpi.getScore());
                        PerformanceScoreChainUtils.saveOrUpdateMonitorItemScore(kpiMonitorItemScore);
                    }
                }
            }
        }
    }

    private static void setScore(MonitorItemScoreVO itemScoreObj, float score) {
        String scoreStr = BscReportSupportUtils.parse2(score);
        if (scoreStr.length() > 13) {
            String[] tmp = scoreStr.split("[.]");
            scoreStr = tmp.length != 2 ? StringUtils.leftPad("", 13, "9") : (tmp[0].length() > 13 ? StringUtils.leftPad("", 13, "9") : scoreStr.substring(0, 13));
        }
        itemScoreObj.setScore(scoreStr);
    }

    private static void saveOrUpdateMonitorItemScore(MonitorItemScoreVO item) throws ServiceException, Exception {
        if (StringUtils.isBlank(item.getOid())) {
            monitorItemScoreService.saveObject(item);
        } else {
            monitorItemScoreService.updateObject(item);
        }
    }

    private static MonitorItemScoreVO getMonitorItemScore(String dateVal, String frequency, String orgId, String empId, String itemType, String itemId) throws ServiceException, Exception {
        MonitorItemScoreVO item = new MonitorItemScoreVO();
        item.setDateVal(dateVal);
        item.setEmpId(empId);
        item.setFrequency(frequency);
        item.setItemId(itemId);
        item.setItemType(itemType);
        item.setOrgId(orgId);
        DefaultResult<MonitorItemScoreVO> result = monitorItemScoreService.findByUK(item);
        if (result.getValue() == null) {
            return item;
        }
        item = result.getValue();
        return item;
    }

    public static float getWeightPercentage(BigDecimal weight) {
        if (weight == null) {
            return 0.0f;
        }
        if (weight.floatValue() == 0.0f) {
            return 0.0f;
        }
        return weight.floatValue() / 100.0f;
    }
}

