/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.model.BscKpiCode;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IMeasureDataService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.util.AggregationMethodUtils;
import com.netsteadfast.greenstep.bsc.util.BscFormulaUtils;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.util.DataUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.FormulaVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.MeasureDataVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class MeasureDataCalendarUtils {
    private static final String[][] resourceTables = new String[][]{{"1", "META-INF/resource/measure-data-calendar-day.ftl"}, {"2", "META-INF/resource/measure-data-calendar-week.ftl"}, {"3", "META-INF/resource/measure-data-calendar-month.ftl"}, {"4", "META-INF/resource/measure-data-calendar-quarter.ftl"}, {"5", "META-INF/resource/measure-data-calendar-halfyear.ftl"}, {"6", "META-INF/resource/measure-data-calendar-year.ftl"}};
    private static IKpiService<KpiVO, BbKpi, String> kpiService = (IKpiService)AppContext.getBean("bsc.service.KpiService");
    private static IMeasureDataService<MeasureDataVO, BbMeasureData, String> measureDataService = (IMeasureDataService)AppContext.getBean("bsc.service.MeasureDataService");
    private static IOrganizationService<OrganizationVO, BbOrganization, String> organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    private static IEmployeeService<EmployeeVO, BbEmployee, String> employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");
    private static TransactionTemplate transactionTemplate = DataUtils.getTransactionTemplate();

    private static String getTemplateResource(String frequency) {
        String resource = "";
        int i = 0;
        while (i < resourceTables.length) {
            if (resourceTables[i][0].equals(frequency)) {
                resource = resourceTables[i][1];
            }
            ++i;
        }
        return resource;
    }

    private static KpiVO findKpi(String oid) throws ServiceException, Exception {
        KpiVO kpi = new KpiVO();
        kpi.setOid(oid);
        DefaultResult<KpiVO> result = kpiService.findObjectByOid(kpi);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        kpi = result.getValue();
        return kpi;
    }

    private static EmployeeVO findEmployee(String empOid) throws ServiceException, Exception {
        EmployeeVO employee = new EmployeeVO();
        employee.setOid(empOid);
        DefaultResult<EmployeeVO> result = employeeService.findObjectByOid(employee);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        employee = result.getValue();
        return employee;
    }

    private static OrganizationVO findOrganization(String orgOid) throws ServiceException, Exception {
        OrganizationVO organization = new OrganizationVO();
        organization.setOid(orgOid);
        DefaultResult<OrganizationVO> result = organizationService.findObjectByOid(organization);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        organization = result.getValue();
        return organization;
    }

    public static MeasureDataVO findMeasureData(final String kpiId, final String date, final String frequency, final String orgaId, final String emplId) throws ServiceException, Exception {
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.setIsolationLevel(-1);
        transactionTemplate.setReadOnly(true);
        MeasureDataVO measureData = null;
        measureData = (MeasureDataVO)transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                MeasureDataVO value = new MeasureDataVO();
                value.setKpiId(kpiId);
                value.setDate(date);
                value.setFrequency(frequency);
                value.setOrgId(orgaId);
                value.setEmpId(emplId);
                try {
                    DefaultResult<MeasureDataVO> mdResult = measureDataService.findByUK(value);
                    value = mdResult.getValue() != null ? mdResult.getValue() : null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    value = null;
                }
                return value;
            }
        });
        return measureData;
    }

    private static List<BbMeasureData> findMeasureData(KpiVO kpi, String date, String frequency, String dataFor, String orgaId, String emplId) throws ServiceException, Exception {
        List<BbMeasureData> searchList = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> likeParams = new HashMap<String, String>();
        params.put("kpiId", kpi.getId());
        params.put("frequency", frequency);
        params.put("orgId", orgaId);
        params.put("empId", emplId);
        String queryDate = BscMeasureDataFrequency.getQueryDate(date, frequency);
        likeParams.put("date", String.valueOf(queryDate) + "%");
        searchList = measureDataService.findListByParams(params, likeParams);
        if (searchList == null) {
            searchList = new ArrayList<BbMeasureData>();
        }
        return searchList;
    }

    private static Map<String, Object> getParameter(KpiVO kpi, FormulaVO formula, String date, String frequency, String dataFor, String orgaOid, String emplOid) throws ServiceException, Exception {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("date", date);
        parameter.put("frequency", frequency);
        parameter.put("dataFor", dataFor);
        parameter.put("kpi", kpi);
        parameter.put("formula", formula);
        parameter.put("managementName", BscKpiCode.getManagementMap(false).get(kpi.getManagement()));
        parameter.put("calculationName", AggregationMethodUtils.getNameByAggrId(kpi.getCal()));
        parameter.put("orgId", "*");
        parameter.put("empId", "*");
        if ("organization".equals(dataFor)) {
            OrganizationVO organization = MeasureDataCalendarUtils.findOrganization(orgaOid);
            parameter.put("orgId", organization.getOrgId());
        }
        if ("employee".equals(dataFor)) {
            EmployeeVO employee = MeasureDataCalendarUtils.findEmployee(emplOid);
            parameter.put("empId", employee.getEmpId());
        }
        parameter.put("masureDatas", MeasureDataCalendarUtils.findMeasureData(kpi, date, frequency, dataFor, (String)parameter.get("orgId"), (String)parameter.get("empId")));
        return parameter;
    }

    private static void fillParameterForDay(Map<String, Object> parameter) throws Exception {
        String[] tmp = ((String)parameter.get("date")).split("-");
        String yyyy = tmp[0];
        String mm = tmp[1];
        String yyyyMM = String.valueOf(yyyy) + mm;
        int maxday = SimpleUtils.getMaxDayOfMonth(SimpleUtils.getInt(yyyy, 1990), SimpleUtils.getInt(mm, 1));
        int dayOfWeek = SimpleUtils.getDayOfWeek(SimpleUtils.getInt(yyyy, 1990), SimpleUtils.getInt(mm, 1));
        int showLen = (maxday + dayOfWeek) / 7;
        if ((maxday + dayOfWeek) % 7 > 1) {
            ++showLen;
        }
        int previousMonthMaxDay = 0;
        int previousMonth = SimpleUtils.getInt(mm, 1) - 1;
        int previousYear = SimpleUtils.getInt(yyyy, 1990);
        if (previousMonth < 1) {
            --previousYear;
            previousMonth = 12;
        }
        previousMonthMaxDay = SimpleUtils.getMaxDayOfMonth(previousYear, previousMonth);
        parameter.put("yyyy", yyyy);
        parameter.put("mm", mm);
        parameter.put("yyyyMM", yyyyMM);
        parameter.put("maxday", maxday);
        parameter.put("dayOfWeek", dayOfWeek);
        parameter.put("showLen", showLen);
        parameter.put("previousMonthMaxDay", previousMonthMaxDay);
        parameter.put("previousMonth", previousMonth);
        parameter.put("previousYear", previousYear);
    }

    private static void fillParameterForWeekOrMonth(Map<String, Object> parameter) throws Exception {
        String[] tmp = ((String)parameter.get("date")).split("-");
        String yyyy = tmp[0];
        String mm = tmp[1];
        String yyyyMM = String.valueOf(yyyy) + mm;
        parameter.put("yyyy", yyyy);
        parameter.put("mm", mm);
        parameter.put("yyyyMM", yyyyMM);
    }

    private static void fillParameterForQuarterOrYear(Map<String, Object> parameter) throws Exception {
        String[] tmp = ((String)parameter.get("date")).split("-");
        String yyyy = tmp[0];
        parameter.put("yyyy", yyyy);
    }

    private static String render(Map<String, Object> parameter, String templateResource) throws Exception {
        return TemplateUtils.processTemplate("resourceTemplate", MeasureDataCalendarUtils.class.getClassLoader(), templateResource, parameter);
    }

    public static String renderBody(String kpiOid, String date, String frequency, String dataFor, String orgaOid, String emplOid, Map<String, String> labels) throws ServiceException, Exception {
        if (StringUtils.isBlank(kpiOid) || StringUtils.isBlank(date) || StringUtils.isBlank(frequency) || StringUtils.isBlank(dataFor)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        KpiVO kpi = MeasureDataCalendarUtils.findKpi(kpiOid);
        FormulaVO formula = BscFormulaUtils.getFormulaById(kpi.getForId());
        Map<String, Object> parameter = MeasureDataCalendarUtils.getParameter(kpi, formula, date, frequency, dataFor, orgaOid, emplOid);
        if ("1".equals(frequency)) {
            MeasureDataCalendarUtils.fillParameterForDay(parameter);
        }
        if ("2".equals(frequency) || "3".equals(frequency)) {
            MeasureDataCalendarUtils.fillParameterForWeekOrMonth(parameter);
        }
        if ("4".equals(frequency) || "5".equals(frequency) || "6".equals(frequency)) {
            MeasureDataCalendarUtils.fillParameterForQuarterOrYear(parameter);
        }
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            parameter.put(entry.getKey(), entry.getValue());
        }
        return MeasureDataCalendarUtils.render(parameter, MeasureDataCalendarUtils.getTemplateResource(frequency));
    }
}

