/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackItemService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackLevelService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackProjectService;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackScoreService;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackItem;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackLevel;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackProject;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackScore;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.vo.DegreeFeedbackItemVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackLevelVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackProjectVO;
import com.netsteadfast.greenstep.vo.DegreeFeedbackScoreVO;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DegreeFeedbackScoreCalculateUtils {
    private static IDegreeFeedbackProjectService<DegreeFeedbackProjectVO, BbDegreeFeedbackProject, String> degreeFeedbackProjectService = (IDegreeFeedbackProjectService)AppContext.getBean("bsc.service.DegreeFeedbackProjectService");
    private static IDegreeFeedbackItemService<DegreeFeedbackItemVO, BbDegreeFeedbackItem, String> degreeFeedbackItemService = (IDegreeFeedbackItemService)AppContext.getBean("bsc.service.DegreeFeedbackItemService");
    private static IDegreeFeedbackLevelService<DegreeFeedbackLevelVO, BbDegreeFeedbackLevel, String> degreeFeedbackLevelService = (IDegreeFeedbackLevelService)AppContext.getBean("bsc.service.DegreeFeedbackLevelService");
    private static IDegreeFeedbackScoreService<DegreeFeedbackScoreVO, BbDegreeFeedbackScore, String> degreeFeedbackScoreService = (IDegreeFeedbackScoreService)AppContext.getBean("bsc.service.DegreeFeedbackScoreService");
    private static IEmployeeService<EmployeeVO, BbEmployee, String> employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");

    public static DegreeFeedbackProjectVO getProjectScore(String projectOid, String ownerEmployeeOid) throws ServiceException, Exception {
        DegreeFeedbackProjectVO project = new DegreeFeedbackProjectVO();
        project.setOid(projectOid);
        DefaultResult<DegreeFeedbackProjectVO> projectResult = degreeFeedbackProjectService.findObjectByOid(project);
        if (projectResult.getValue() == null) {
            throw new ServiceException(projectResult.getSystemMessage().getValue());
        }
        project = projectResult.getValue();
        EmployeeVO employee = new EmployeeVO();
        employee.setOid(ownerEmployeeOid);
        DefaultResult<EmployeeVO> empResult = employeeService.findObjectByOid(employee);
        if (empResult.getValue() == null) {
            throw new ServiceException(empResult.getSystemMessage().getValue());
        }
        employee = empResult.getValue();
        List<DegreeFeedbackItemVO> items = DegreeFeedbackScoreCalculateUtils.getItemsScore(project, employee);
        if (items != null && items.size() > 0) {
            project.setEmployee(employee);
            project.setItems(items);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("projectOid", project.getOid());
            HashMap<String, String> orderMap = new HashMap<String, String>();
            orderMap.put("value", "asc");
            List<BbDegreeFeedbackLevel> levels = degreeFeedbackLevelService.findListByParams(paramMap, null, orderMap);
            project.setLevels(DegreeFeedbackScoreCalculateUtils.wrapLevels(levels));
        }
        return project;
    }

    public static List<DegreeFeedbackItemVO> getItemsScore(DegreeFeedbackProjectVO project, EmployeeVO employee) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectOid", project.getOid());
        List<DegreeFeedbackItemVO> items = degreeFeedbackItemService.findListVOByParams(paramMap);
        DefaultResult<List<BbDegreeFeedbackScore>> scoresResult = degreeFeedbackScoreService.findResultsByProjectAndOwner(project.getOid(), employee.getEmpId());
        if (scoresResult.getValue() != null) {
            DegreeFeedbackScoreCalculateUtils.setItemScoreCalculate(project, items, scoresResult.getValue());
        }
        return items;
    }

    private static void setItemScoreCalculate(DegreeFeedbackProjectVO project, List<DegreeFeedbackItemVO> items, List<BbDegreeFeedbackScore> scores) throws ServiceException, Exception {
        ArrayList<String> assigns = new ArrayList<String>();
        for (BbDegreeFeedbackScore scoreData : scores) {
            if (assigns.contains(scoreData.getAssignOid())) continue;
            assigns.add(scoreData.getAssignOid());
        }
        for (DegreeFeedbackItemVO item : items) {
            int sumScore = 0;
            float avgScore = 0.0f;
            for (BbDegreeFeedbackScore scoreData : scores) {
                if (!scoreData.getItemOid().equals(item.getOid())) continue;
                sumScore += scoreData.getScore();
            }
            if (sumScore > 0 && assigns.size() > 0) {
                avgScore = Float.valueOf(sumScore).floatValue() / Float.valueOf(assigns.size()).floatValue();
                BigDecimal bd = new BigDecimal(avgScore);
                avgScore = bd.setScale(1, 4).floatValue();
            }
            item.setSumScore(sumScore);
            item.setAvgScore(avgScore);
        }
        assigns.clear();
        assigns = null;
    }

    private static List<DegreeFeedbackLevelVO> wrapLevels(List<BbDegreeFeedbackLevel> levels) throws Exception {
        LinkedList<DegreeFeedbackLevelVO> newLevels = new LinkedList<DegreeFeedbackLevelVO>();
        for (BbDegreeFeedbackLevel level : levels) {
            DegreeFeedbackLevelVO obj = new DegreeFeedbackLevelVO();
            degreeFeedbackLevelService.copyProperties(level, obj);
            newLevels.add(obj);
        }
        return newLevels;
    }
}

