/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.bsc.service.IScoreColorService;
import com.netsteadfast.greenstep.po.hbm.BbScoreColor;
import com.netsteadfast.greenstep.vo.ScoreColorVO;
import java.util.List;

public class BscScoreColorUtils {
    public static final String DEFAULT_BACKGROUND_COLOR = "#ffffff";
    public static final String DEFAULT_FONT_COLOR = "#000000";
    private static IScoreColorService<ScoreColorVO, BbScoreColor, String> scoreColorService;
    private static ThreadLocal<List<BbScoreColor>> scoreColorsThreadLocal;

    static {
        scoreColorsThreadLocal = new ThreadLocal();
        scoreColorService = (IScoreColorService)AppContext.getBean("bsc.service.ScoreColorService");
    }

    public static void clearThreadLocal() {
        scoreColorsThreadLocal.remove();
    }

    public static void loadScoreColors() throws ServiceException, Exception {
        if (scoreColorsThreadLocal.get() != null && scoreColorsThreadLocal.get().size() > 0) {
            return;
        }
        List<BbScoreColor> scoreColors = scoreColorService.findListByParamsCacheable();
        scoreColorsThreadLocal.set(scoreColors);
    }

    public static String getFontColor(int score) throws Exception {
        List<BbScoreColor> scoreColors = scoreColorsThreadLocal.get();
        if (scoreColors == null || scoreColors.size() < 1) {
            return DEFAULT_FONT_COLOR;
        }
        String value = DEFAULT_FONT_COLOR;
        for (BbScoreColor scoreColor : scoreColors) {
            if (score < scoreColor.getScoreMin() || score > scoreColor.getScoreMax()) continue;
            value = scoreColor.getFontColor();
        }
        return value;
    }

    public static String getFontColor(float score) throws Exception {
        return BscScoreColorUtils.getFontColor((int)score);
    }

    public static String getBackgroundColor(int score) throws Exception {
        List<BbScoreColor> scoreColors = scoreColorsThreadLocal.get();
        if (scoreColors == null || scoreColors.size() < 1) {
            return DEFAULT_BACKGROUND_COLOR;
        }
        String value = DEFAULT_BACKGROUND_COLOR;
        for (BbScoreColor scoreColor : scoreColors) {
            if (score < scoreColor.getScoreMin() || score > scoreColor.getScoreMax()) continue;
            value = scoreColor.getBgColor();
        }
        return value;
    }

    public static String getBackgroundColor(float score) throws Exception {
        return BscScoreColorUtils.getBackgroundColor((int)score);
    }
}

