/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.TbSysExpression;
import com.netsteadfast.greenstep.service.ISysExpressionService;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.SysExpressionVO;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class BscReportSupportUtils {
    private static final String REPORT_UP_DOWN_HTML_ICON_STATUS_EXPR_ID = "BSC_RPT_EXPR0003";
    private static final String REPORT_UP_DOWN_BYTE_ICON_STATUS_EXPR_ID = "BSC_RPT_EXPR0004";
    private static final String REPORT_UP_DOWN_HTML_ICON_STATUS_FOR_BASE_EXPR_ID = "BSC_RPT_EXPR0005";
    private static final String REPORT_UP_DOWN_BYTE_ICON_STATUS_FOR_BASE_EXPR_ID = "BSC_RPT_EXPR0006";
    private static ISysExpressionService<SysExpressionVO, TbSysExpression, String> sysExpressionService;
    private static IEmployeeService<EmployeeVO, BbEmployee, String> employeeService;
    private static IOrganizationService<OrganizationVO, BbOrganization, String> organizationService;
    private static ThreadLocal<SysExpressionVO> exprThreadLocal01;
    private static ThreadLocal<SysExpressionVO> exprThreadLocal02;
    private static ThreadLocal<SysExpressionVO> exprThreadLocal03;
    private static ThreadLocal<SysExpressionVO> exprThreadLocal04;
    private static NumberFormat numberFormat;

    static {
        exprThreadLocal01 = new ThreadLocal();
        exprThreadLocal02 = new ThreadLocal();
        exprThreadLocal03 = new ThreadLocal();
        exprThreadLocal04 = new ThreadLocal();
        numberFormat = null;
        numberFormat = new DecimalFormat("0.00");
        numberFormat.setCurrency(Currency.getInstance(Locale.US));
        sysExpressionService = (ISysExpressionService)AppContext.getBean("core.service.SysExpressionService");
        employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");
        organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    }

    public static void clearThreadLocal() {
        exprThreadLocal01.remove();
        exprThreadLocal02.remove();
        exprThreadLocal03.remove();
        exprThreadLocal04.remove();
    }

    public static void loadExpression() throws ServiceException, Exception {
        BscReportSupportUtils.loadExpression(exprThreadLocal01, REPORT_UP_DOWN_HTML_ICON_STATUS_EXPR_ID);
        BscReportSupportUtils.loadExpression(exprThreadLocal02, REPORT_UP_DOWN_BYTE_ICON_STATUS_EXPR_ID);
        BscReportSupportUtils.loadExpression(exprThreadLocal03, REPORT_UP_DOWN_HTML_ICON_STATUS_FOR_BASE_EXPR_ID);
        BscReportSupportUtils.loadExpression(exprThreadLocal04, REPORT_UP_DOWN_BYTE_ICON_STATUS_FOR_BASE_EXPR_ID);
    }

    public static void loadExpression(ThreadLocal<SysExpressionVO> exprThreadLocal, String exprId) throws ServiceException, Exception {
        if (exprThreadLocal.get() == null) {
            SysExpressionVO sysExpression = new SysExpressionVO();
            sysExpression.setExprId(exprId);
            DefaultResult<SysExpressionVO> result = sysExpressionService.findByUkCacheable(sysExpression);
            if (result.getValue() != null) {
                sysExpression = result.getValue();
                exprThreadLocal.set(sysExpression);
            }
        }
    }

    public static String getUrlIcon(KpiVO kpi, float score) throws Exception {
        String icon = "";
        SysExpressionVO sysExpression = exprThreadLocal01.get();
        if (sysExpression == null) {
            return icon;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Object> results = new HashMap<String, Object>();
        parameters.put("kpi", kpi);
        parameters.put("score", Float.valueOf(score));
        results.put("icon", " ");
        ScriptExpressionUtils.execute(sysExpression.getType(), sysExpression.getContent(), results, parameters);
        icon = (String)results.get("icon");
        return StringUtils.defaultString(icon);
    }

    public static String getUrlIconBase(String mode, float target, float min, float score, String kpiCompareType, String kpiManagement, float kpiQuasiRange) throws Exception {
        String icon = "";
        SysExpressionVO sysExpression = exprThreadLocal03.get();
        if (sysExpression == null) {
            return icon;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Object> results = new HashMap<String, Object>();
        parameters.put("mode", mode);
        parameters.put("target", Float.valueOf(target));
        parameters.put("min", Float.valueOf(min));
        parameters.put("score", Float.valueOf(score));
        parameters.put("compareType", kpiCompareType);
        parameters.put("management", kpiManagement);
        parameters.put("quasiRange", Float.valueOf(kpiQuasiRange));
        results.put("icon", " ");
        ScriptExpressionUtils.execute(sysExpression.getType(), sysExpression.getContent(), results, parameters);
        icon = (String)results.get("icon");
        return StringUtils.defaultString(icon);
    }

    public static String getHtmlIcon(KpiVO kpi, float score) throws Exception {
        String icon = BscReportSupportUtils.getUrlIcon(kpi, score);
        if (StringUtils.isBlank(icon)) {
            return "";
        }
        return "<img src='./images/" + icon + "' border='0' >";
    }

    public static byte[] getByteIcon(KpiVO kpi, float score) throws Exception {
        byte[] datas = null;
        SysExpressionVO sysExpression = exprThreadLocal02.get();
        if (sysExpression == null) {
            return datas;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Object> results = new HashMap<String, Object>();
        parameters.put("kpi", kpi);
        parameters.put("score", Float.valueOf(score));
        results.put("icon", " ");
        ScriptExpressionUtils.execute(sysExpression.getType(), sysExpression.getContent(), results, parameters);
        String iconResource = (String)results.get("icon");
        ClassLoader classLoader = BscReportSupportUtils.class.getClassLoader();
        datas = IOUtils.toByteArray(classLoader.getResource(iconResource).openStream());
        return datas;
    }

    public static String getHtmlIconBase(String mode, float target, float min, float score, String kpiCompareType, String kpiManagement, float kpiQuasiRange) throws Exception {
        String icon = BscReportSupportUtils.getUrlIconBase(mode, target, min, score, kpiCompareType, kpiManagement, kpiQuasiRange);
        if (StringUtils.isBlank(icon)) {
            return "";
        }
        return "<img src='./images/" + icon + "' border='0' >";
    }

    public static byte[] getByteIconBase(String mode, float target, float min, float score, String kpiCompareType, String kpiManagement, float kpiQuasiRange) throws Exception {
        byte[] datas = null;
        SysExpressionVO sysExpression = exprThreadLocal04.get();
        if (sysExpression == null) {
            return datas;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Object> results = new HashMap<String, Object>();
        parameters.put("mode", mode);
        parameters.put("target", Float.valueOf(target));
        parameters.put("min", Float.valueOf(min));
        parameters.put("score", Float.valueOf(score));
        parameters.put("compareType", kpiCompareType);
        parameters.put("management", kpiManagement);
        parameters.put("quasiRange", Float.valueOf(kpiQuasiRange));
        results.put("icon", " ");
        ScriptExpressionUtils.execute(sysExpression.getType(), sysExpression.getContent(), results, parameters);
        String iconResource = (String)results.get("icon");
        ClassLoader classLoader = BscReportSupportUtils.class.getClassLoader();
        datas = IOUtils.toByteArray(classLoader.getResource(iconResource).openStream());
        return datas;
    }

    public static String parse(float score) {
        return numberFormat.format(score);
    }

    public static String parse2(float score) {
        String str = numberFormat.format(score);
        if (str.endsWith(".00")) {
            str = str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static void fillKpiOrganizations(KpiVO kpi) throws ServiceException, Exception {
        List<String> appendOrgaOids = organizationService.findForAppendOrganizationOidsByKpiOrga(kpi.getId());
        int i = 0;
        while (appendOrgaOids != null && i < appendOrgaOids.size()) {
            OrganizationVO organization = new OrganizationVO();
            organization.setOid(appendOrgaOids.get(i));
            DefaultResult<OrganizationVO> result = organizationService.findObjectByOid(organization);
            if (result.getValue() != null) {
                organization = result.getValue();
                kpi.getOrganizations().add(organization);
            }
            ++i;
        }
    }

    public static void fillKpiEmployees(KpiVO kpi) throws ServiceException, Exception {
        List<String> appendEmplOids = employeeService.findForAppendEmployeeOidsByKpiEmpl(kpi.getId());
        int i = 0;
        while (appendEmplOids != null && i < appendEmplOids.size()) {
            EmployeeVO employee = new EmployeeVO();
            employee.setOid(appendEmplOids.get(i));
            DefaultResult<EmployeeVO> result = employeeService.findObjectByOid(employee);
            if (result.getValue() != null) {
                employee = result.getValue();
                kpi.getEmployees().add(employee);
            }
            ++i;
        }
    }
}

