/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.chain.SimpleChain;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ChainResultObj;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.model.BscKpiCode;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.util.BscReportPropertyUtils;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.bsc.util.PerformanceScoreChainUtils;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.util.JFreeChartDataMapperUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.lang3.StringUtils;

public class BscMobileCardUtils {
    private static IVisionService<VisionVO, BbVision, String> visionService = (IVisionService)AppContext.getBean("bsc.service.VisionService");
    private static final String _RESOURCE_VISION_CARD = "META-INF/resource/mobile-card/vision-card.ftl";
    private static final String _RESOURCE_PERSPECTIVE_CARD = "META-INF/resource/mobile-card/perspective-card.ftl";
    private static final String _RESOURCE_OBJECTIVE_CARD = "META-INF/resource/mobile-card/objective-card.ftl";
    private static final String _RESOURCE_KPI_CARD = "META-INF/resource/mobile-card/kpi-card.ftl";

    public static VisionVO getVisionCardFromUpload(String uploadOid) throws ServiceException, Exception {
        byte[] content = UploadSupportUtils.getDataBytes(uploadOid);
        String jsonStr = new String(content, "utf-8");
        if (StringUtils.isBlank(jsonStr)) {
            throw new Exception("vision-card json data error.");
        }
        VisionVO vision = new ObjectMapper().readValue(jsonStr, VisionVO.class);
        return vision;
    }

    public static String getVisionCardUpload(VisionVO vision) throws ServiceException, Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonData = objectMapper.writeValueAsString(vision);
        return UploadSupportUtils.create(Constants.getSystem(), "tmp", false, jsonData.getBytes(), String.valueOf(SimpleUtils.getUUIDStr()) + ".json");
    }

    public static String getVisionCardUpload(String frequency, String startDate, String endDate) throws ServiceException, Exception {
        List<VisionVO> visionScores = BscMobileCardUtils.getVisionCard(frequency, startDate, endDate);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonData = objectMapper.writeValueAsString(visionScores);
        return UploadSupportUtils.create(Constants.getSystem(), "tmp", false, jsonData.getBytes(), String.valueOf(SimpleUtils.getUUIDStr()) + ".json");
    }

    public static List<VisionVO> getVisionCard(String frequency, String startDate, String endDate) throws ServiceException, Exception {
        ArrayList<VisionVO> visionScores = new ArrayList<VisionVO>();
        Map<String, String> visions = visionService.findForMap(false);
        if (visions == null || visions.size() < 1) {
            return visionScores;
        }
        ContextBase context = new ContextBase();
        context.put("startDate", startDate);
        context.put("endDate", endDate);
        context.put("startYearDate", startDate.substring(0, 4));
        context.put("endYearDate", endDate.substring(0, 4));
        context.put("frequency", frequency);
        context.put("dataFor", "all");
        context.put("orgId", "*");
        context.put("empId", "*");
        for (Map.Entry<String, String> entry : visions.entrySet()) {
            String visionOid = entry.getKey();
            context.put("visionOid", visionOid);
            SimpleChain chain = new SimpleChain();
            ChainResultObj resultObj = chain.getResultFromResource("performanceScoreChain", context);
            BscStructTreeObj treeObj = (BscStructTreeObj)resultObj.getValue();
            int i = 0;
            while (treeObj.getVisions() != null && i < treeObj.getVisions().size()) {
                VisionVO vision = treeObj.getVisions().get(i);
                vision.setContent(" ".getBytes());
                DefaultResult<VisionVO> vResult = visionService.findObjectByOid(vision);
                if (vResult.getValue() != null) {
                    vision.setContent(new String(vResult.getValue().getContent(), "utf-8").getBytes());
                }
                for (PerspectiveVO perspective : vision.getPerspectives()) {
                    for (ObjectiveVO objective : perspective.getObjectives()) {
                        for (KpiVO kpi : objective.getKpis()) {
                            kpi.getAggregationMethod().setDescription(" ");
                            kpi.getAggregationMethod().setExpression1(" ");
                            kpi.getAggregationMethod().setExpression2(" ");
                            kpi.getFormula().setExpression(" ");
                        }
                    }
                }
                visionScores.add(vision);
                ++i;
            }
        }
        return visionScores;
    }

    public static String getVisionCardContent(VisionVO vision, String frequencyName, String startDate, String endDate) throws ServiceException, Exception {
        String content = "";
        int perspectiveSize = vision.getPerspectives().size();
        int objectiveSize = 0;
        int kpiSize = 0;
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            objectiveSize += perspective.getObjectives().size();
            List<ObjectiveVO> objectives = perspective.getObjectives();
            for (ObjectiveVO objective : objectives) {
                kpiSize += objective.getKpis().size();
            }
        }
        BscReportPropertyUtils.loadData();
        String uploadOid = BscMobileCardUtils.getVisionCardUpload(vision);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("perspectiveTitle", BscReportPropertyUtils.getPerspectiveTitle());
        paramMap.put("objectiveTitle", BscReportPropertyUtils.getObjectiveTitle());
        paramMap.put("kpiTitle", BscReportPropertyUtils.getKpiTitle());
        paramMap.put("backgroundColor", BscReportPropertyUtils.getBackgroundColor());
        paramMap.put("fontColor", BscReportPropertyUtils.getFontColor());
        paramMap.put("vision", vision);
        paramMap.put("visionContent", new String(vision.getContent(), "utf-8"));
        paramMap.put("perspectiveSize", perspectiveSize);
        paramMap.put("objectiveSize", objectiveSize);
        paramMap.put("kpiSize", kpiSize);
        paramMap.put("percentage", BscMobileCardUtils.getPercentage(vision.getScore(), 100.0f));
        paramMap.put("uploadOid", uploadOid);
        paramMap.put("frequencyName", frequencyName);
        paramMap.put("startDate", startDate);
        paramMap.put("endDate", endDate);
        content = TemplateUtils.processTemplate("resourceTemplate", BscMobileCardUtils.class.getClassLoader(), _RESOURCE_VISION_CARD, paramMap);
        return content;
    }

    public static String getPerspectivesCardContent(String uploadOid, PerspectiveVO perspective) throws ServiceException, Exception {
        String content = "";
        BscReportPropertyUtils.loadData();
        BscReportSupportUtils.loadExpression();
        if (StringUtils.isBlank(perspective.getImgIcon())) {
            String icon = BscReportSupportUtils.getHtmlIconBase("PERSPECTIVES", perspective.getTarget(), perspective.getMin(), perspective.getScore(), "", "", 0.0f);
            perspective.setImgIcon(icon);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("perspective", perspective);
        paramMap.put("backgroundColor", BscReportPropertyUtils.getBackgroundColor());
        paramMap.put("fontColor", BscReportPropertyUtils.getFontColor());
        paramMap.put("percentage", BscMobileCardUtils.getPercentage(perspective.getScore(), perspective.getTarget()));
        paramMap.put("uploadOid", uploadOid);
        content = TemplateUtils.processTemplate("resourceTemplate", BscMobileCardUtils.class.getClassLoader(), _RESOURCE_PERSPECTIVE_CARD, paramMap);
        return content;
    }

    public static String getObjectivesCardContent(String uploadOid, ObjectiveVO objective) throws ServiceException, Exception {
        String content = "";
        BscReportPropertyUtils.loadData();
        BscReportSupportUtils.loadExpression();
        if (StringUtils.isBlank(objective.getImgIcon())) {
            String icon = BscReportSupportUtils.getHtmlIconBase("OBJECTIVES", objective.getTarget(), objective.getMin(), objective.getScore(), "", "", 0.0f);
            objective.setImgIcon(icon);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("objective", objective);
        paramMap.put("backgroundColor", BscReportPropertyUtils.getBackgroundColor());
        paramMap.put("fontColor", BscReportPropertyUtils.getFontColor());
        paramMap.put("percentage", BscMobileCardUtils.getPercentage(objective.getScore(), objective.getTarget()));
        paramMap.put("uploadOid", uploadOid);
        content = TemplateUtils.processTemplate("resourceTemplate", BscMobileCardUtils.class.getClassLoader(), _RESOURCE_OBJECTIVE_CARD, paramMap);
        return content;
    }

    public static String getKPIsCardContent(String uploadOid, KpiVO kpi) throws ServiceException, Exception {
        String content = "";
        BscReportPropertyUtils.loadData();
        float compareValue = kpi.getTarget();
        if ("2".equals(kpi.getCompareType())) {
            compareValue = kpi.getMin();
        }
        if (StringUtils.isBlank(kpi.getImgIcon())) {
            String icon = BscReportSupportUtils.getHtmlIconBase("KPI", kpi.getTarget(), kpi.getMin(), kpi.getScore(), kpi.getCompareType(), kpi.getManagement(), kpi.getQuasiRange());
            kpi.setImgIcon(icon);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("kpi", kpi);
        paramMap.put("backgroundColor", BscReportPropertyUtils.getBackgroundColor());
        paramMap.put("fontColor", BscReportPropertyUtils.getFontColor());
        paramMap.put("percentage", BscMobileCardUtils.getPercentage(kpi.getScore(), compareValue));
        paramMap.put("uploadOid", uploadOid);
        paramMap.put("compareTypeName", BscKpiCode.getCompareTypeMap(false).get(kpi.getCompareType()));
        int score = (int)kpi.getScore();
        int lowerBound = (int)kpi.getMin();
        int upperBound = (int)compareValue;
        if (score <= lowerBound) {
            lowerBound = score;
        }
        if (score >= upperBound) {
            upperBound = score;
        }
        if (lowerBound >= upperBound) {
            upperBound += lowerBound;
        }
        String chartDataOid = JFreeChartDataMapperUtils.createMeterData(kpi.getName(), kpi.getScore(), lowerBound, upperBound, 320, 280);
        paramMap.put("chartDataOid", chartDataOid);
        content = TemplateUtils.processTemplate("resourceTemplate", BscMobileCardUtils.class.getClassLoader(), _RESOURCE_KPI_CARD, paramMap);
        return content;
    }

    public static String getDashboardScoreUpload(String visionOid, String frequency, String startDate, String endDate) throws ServiceException, Exception {
        VisionVO visionObj = BscMobileCardUtils.getDashboardScore(visionOid, frequency, startDate, endDate);
        return BscMobileCardUtils.getVisionCardUpload(visionObj);
    }

    public static VisionVO getDashboardScore(String visionOid, String frequency, String startDate, String endDate) throws ServiceException, Exception {
        ChainResultObj result;
        String startYear = "";
        String endYear = "";
        if ("6".equals(frequency) || "5".equals(frequency) || "4".equals(frequency)) {
            startYear = startDate.substring(0, 4);
            endYear = endDate.substring(0, 4);
        }
        if ((result = PerformanceScoreChainUtils.getResult(visionOid, startDate, endDate, startYear, endYear, frequency, "all", "", "")).getValue() == null || ((BscStructTreeObj)result.getValue()).getVisions() == null || ((BscStructTreeObj)result.getValue()).getVisions().size() == 0) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        BscStructTreeObj resultObj = (BscStructTreeObj)result.getValue();
        VisionVO visionObj = resultObj.getVisions().get(0);
        return visionObj;
    }

    private static String getPercentage(float score, float compareValue) {
        int percentage = 0;
        if (score != 0.0f && compareValue != 0.0f) {
            float p = score / compareValue * 100.0f;
            percentage = Math.round(p);
        }
        return String.valueOf(percentage);
    }
}

