/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.service.IAggregationMethodService;
import com.netsteadfast.greenstep.po.hbm.BbAggregationMethod;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.vo.AggregationMethodVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AggregationMethodUtils {
    private static IAggregationMethodService<AggregationMethodVO, BbAggregationMethod, String> aggregationMethodService;
    private static ThreadLocal<Map<String, AggregationMethodVO>> aggrMethodPkThreadLocal;
    private static ThreadLocal<Map<String, AggregationMethodVO>> aggrMethodUkThreadLocal;

    static {
        aggrMethodPkThreadLocal = new ThreadLocal();
        aggrMethodUkThreadLocal = new ThreadLocal();
        aggregationMethodService = (IAggregationMethodService)AppContext.getBean("bsc.service.AggregationMethodService");
    }

    public static void clearThreadLocal() {
        aggrMethodPkThreadLocal.remove();
        aggrMethodUkThreadLocal.remove();
    }

    private static AggregationMethodVO findAggregationMethod(String oid) throws ServiceException, Exception {
        Map<String, AggregationMethodVO> datas = aggrMethodPkThreadLocal.get();
        if (datas != null && datas.get(oid) != null) {
            return datas.get(oid);
        }
        AggregationMethodVO aggr = new AggregationMethodVO();
        aggr.setOid(oid);
        DefaultResult<AggregationMethodVO> result = aggregationMethodService.findObjectByOid(aggr);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        aggr = result.getValue();
        if (aggrMethodPkThreadLocal.get() == null) {
            aggrMethodPkThreadLocal.set(new HashMap());
        }
        aggrMethodPkThreadLocal.get().put(oid, aggr);
        return aggr;
    }

    private static AggregationMethodVO findAggregationMethodByUK(String id) throws ServiceException, Exception {
        Map<String, AggregationMethodVO> datas = aggrMethodUkThreadLocal.get();
        if (datas != null && datas.get(id) != null) {
            return datas.get(id);
        }
        AggregationMethodVO aggr = new AggregationMethodVO();
        aggr.setAggrId(id);
        DefaultResult<AggregationMethodVO> result = aggregationMethodService.findByUK(aggr);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        aggr = result.getValue();
        if (aggrMethodUkThreadLocal.get() == null) {
            aggrMethodUkThreadLocal.set(new HashMap());
        }
        aggrMethodUkThreadLocal.get().put(id, aggr);
        return aggr;
    }

    private static Map<String, Object> getParameter(KpiVO kpi, String frequency) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("kpi", kpi);
        parameter.put("score", Float.valueOf(0.0f));
        if (!StringUtils.isBlank(frequency)) {
            parameter.put("frequency", frequency);
        }
        return parameter;
    }

    private static Map<String, Object> getScore(String type, String expression, KpiVO kpi, String frequency) throws Exception {
        if (kpi == null || kpi.getMeasureDatas() == null) {
            throw new Exception("no measure data!");
        }
        String bscExpression = ScriptExpressionUtils.replaceFormulaExpression(type, expression);
        Map<String, Object> results = new HashMap<String, Object>();
        results.put("score", null);
        results = ScriptExpressionUtils.execute(type, bscExpression, results, AggregationMethodUtils.getParameter(kpi, frequency));
        return results;
    }

    public static float processDefaultMode(KpiVO kpi) throws Exception {
        Map<String, Object> results = AggregationMethodUtils.getScore(kpi.getAggregationMethod().getType(), kpi.getAggregationMethod().getExpression1(), kpi, null);
        Object value = results.get("score");
        if (value == null) {
            return 0.0f;
        }
        if (!NumberUtils.isCreatable(String.valueOf(value))) {
            return 0.0f;
        }
        return NumberUtils.toFloat(String.valueOf(value), 0.0f);
    }

    public static float processDateRangeMode(KpiVO kpi, String frequency) throws Exception {
        Map<String, Object> results = AggregationMethodUtils.getScore(kpi.getAggregationMethod().getType(), kpi.getAggregationMethod().getExpression2(), kpi, frequency);
        Object value = results.get("score");
        if (value == null) {
            return 0.0f;
        }
        if (!NumberUtils.isCreatable(String.valueOf(value))) {
            return 0.0f;
        }
        return NumberUtils.toFloat(String.valueOf(value), 0.0f);
    }

    public static Object processDefaultModeByOid(String aggregationMethodOid, KpiVO kpi) throws ServiceException, Exception {
        AggregationMethodVO aggr = AggregationMethodUtils.findAggregationMethod(aggregationMethodOid);
        return AggregationMethodUtils.getScore(aggr.getType(), aggr.getExpression1(), kpi, null);
    }

    public static Object processDateRangeModeByOid(String aggregationMethodOid, KpiVO kpi, String frequency) throws ServiceException, Exception {
        AggregationMethodVO aggr = AggregationMethodUtils.findAggregationMethod(aggregationMethodOid);
        return AggregationMethodUtils.getScore(aggr.getType(), aggr.getExpression2(), kpi, frequency);
    }

    public static Object processDefaultModeByUK(String id, KpiVO kpi) throws ServiceException, Exception {
        AggregationMethodVO aggr = AggregationMethodUtils.findAggregationMethodByUK(id);
        return AggregationMethodUtils.getScore(aggr.getType(), aggr.getExpression1(), kpi, null);
    }

    public static Object processDateRangeModeByUK(String id, KpiVO kpi, String frequency) throws ServiceException, Exception {
        AggregationMethodVO aggr = AggregationMethodUtils.findAggregationMethodByUK(id);
        return AggregationMethodUtils.getScore(aggr.getType(), aggr.getExpression2(), kpi, frequency);
    }

    public static AggregationMethodVO findSimpleByOid(String oid) throws ServiceException, Exception {
        DefaultResult<AggregationMethodVO> result = aggregationMethodService.findSimpleByOid(oid);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        return result.getValue();
    }

    public static AggregationMethodVO findSimpleById(String id) throws ServiceException, Exception {
        DefaultResult<AggregationMethodVO> result = aggregationMethodService.findSimpleById(id);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        return result.getValue();
    }

    public static String getNameByOid(String oid) throws ServiceException, Exception {
        return AggregationMethodUtils.findSimpleByOid(oid).getName();
    }

    public static String getNameByAggrId(String id) throws ServiceException, Exception {
        return AggregationMethodUtils.findSimpleById(id).getName();
    }

    public Map<String, String> findMap(boolean pleaseSelect) throws ServiceException, Exception {
        return aggregationMethodService.findForMap(pleaseSelect);
    }
}

