/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.util;

import com.netsteadfast.greenstep.bsc.model.BscMeasureData;
import com.netsteadfast.greenstep.bsc.util.BscFormulaUtils;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.bsc.util.BscScoreColorUtils;
import com.netsteadfast.greenstep.po.hbm.BbMeasureData;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class AggregationMethod {
    public static final String QUARTER_1 = "Q1";
    public static final String QUARTER_2 = "Q2";
    public static final String QUARTER_3 = "Q3";
    public static final String QUARTER_4 = "Q4";
    public static final String HALF_YEAR_FIRST = "first";
    public static final String HALF_YEAR_LAST = "last";

    public static AggregationMethod build() throws InstantiationException, IllegalAccessException {
        return (AggregationMethod)AggregationMethod.class.newInstance();
    }

    private boolean isDateRange(String date, String frequency, BbMeasureData measureData) {
        if ("4".equals(frequency)) {
            String yyyy = date.substring(0, 4);
            if (date.endsWith(QUARTER_1) && !(String.valueOf(yyyy) + "0101").equals(measureData.getDate())) {
                return false;
            }
            if (date.endsWith(QUARTER_2) && !(String.valueOf(yyyy) + "0401").equals(measureData.getDate())) {
                return false;
            }
            if (date.endsWith(QUARTER_3) && !(String.valueOf(yyyy) + "0701").equals(measureData.getDate())) {
                return false;
            }
            if (date.endsWith(QUARTER_4) && !(String.valueOf(yyyy) + "1001").equals(measureData.getDate())) {
                return false;
            }
        } else if ("5".equals(frequency)) {
            String yyyy = date.substring(0, 4);
            if (date.endsWith(HALF_YEAR_FIRST) && !(String.valueOf(yyyy) + "0101").equals(measureData.getDate())) {
                return false;
            }
            if (date.endsWith(HALF_YEAR_LAST) && !(String.valueOf(yyyy) + "0701").equals(measureData.getDate())) {
                return false;
            }
        } else if (!measureData.getDate().startsWith(date)) {
            return false;
        }
        return true;
    }

    public float average(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        float score = 0.0f;
        int size = 0;
        for (BbMeasureData measureData : measureDatas) {
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            try {
                Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                score += NumberUtils.toFloat(String.valueOf(value), 0.0f);
                ++size;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (score != 0.0f && size > 0) {
            score /= (float)size;
        }
        return score;
    }

    public void averageDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            float score = 0.0f;
            int size = 0;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                BscMeasureData data = new BscMeasureData();
                data.setActual(Float.valueOf(measureData.getActual()));
                data.setTarget(Float.valueOf(measureData.getTarget()));
                data.setKpi(kpi);
                try {
                    Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                    if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                    score += NumberUtils.toFloat(String.valueOf(value), 0.0f);
                    ++size;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (score != 0.0f && size > 0) {
                score /= (float)size;
            }
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }

    public float averageDistinct(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        ArrayList<Float> scores = new ArrayList<Float>();
        float score = 0.0f;
        int size = 0;
        for (BbMeasureData measureData : measureDatas) {
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            try {
                float nowScore;
                Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                if (value == null || !NumberUtils.isCreatable(String.valueOf(value)) || scores.contains(Float.valueOf(nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f)))) continue;
                scores.add(Float.valueOf(nowScore));
                score += nowScore;
                ++size;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (score != 0.0f && size > 0) {
            score /= (float)size;
        }
        return score;
    }

    public void averageDistinctDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            ArrayList<Float> scores = new ArrayList<Float>();
            float score = 0.0f;
            int size = 0;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                BscMeasureData data = new BscMeasureData();
                data.setActual(Float.valueOf(measureData.getActual()));
                data.setTarget(Float.valueOf(measureData.getTarget()));
                data.setKpi(kpi);
                try {
                    float nowScore;
                    Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                    if (value == null || !NumberUtils.isCreatable(String.valueOf(value)) || scores.contains(Float.valueOf(nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f)))) continue;
                    scores.add(Float.valueOf(nowScore));
                    score += nowScore;
                    ++size;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (score != 0.0f && size > 0) {
                score /= (float)size;
            }
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }

    public float count(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        return Float.valueOf(measureDatas.size()).floatValue();
    }

    public void countDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            float score = 0.0f;
            int size = 0;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                ++size;
            }
            score = Float.valueOf(size).floatValue();
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }

    public float countDistinct(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        ArrayList<Float> scores = new ArrayList<Float>();
        for (BbMeasureData measureData : measureDatas) {
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            try {
                float nowScore;
                Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                if (value == null || !NumberUtils.isCreatable(String.valueOf(value)) || scores.contains(Float.valueOf(nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f)))) continue;
                scores.add(Float.valueOf(nowScore));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Float.valueOf(scores.size()).floatValue();
    }

    public void countDistinctDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            ArrayList<Float> scores = new ArrayList<Float>();
            float score = 0.0f;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                BscMeasureData data = new BscMeasureData();
                data.setActual(Float.valueOf(measureData.getActual()));
                data.setTarget(Float.valueOf(measureData.getTarget()));
                data.setKpi(kpi);
                try {
                    float nowScore;
                    Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                    if (value == null || !NumberUtils.isCreatable(String.valueOf(value)) || scores.contains(Float.valueOf(nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f)))) continue;
                    scores.add(Float.valueOf(nowScore));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            score = Float.valueOf(scores.size()).floatValue();
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }

    public float max(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        float score = 0.0f;
        int size = 0;
        float nowScore = 0.0f;
        for (BbMeasureData measureData : measureDatas) {
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            try {
                Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f);
                if (size < 1) {
                    score = nowScore;
                } else if (score < nowScore) {
                    score = nowScore;
                }
                ++size;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return score;
    }

    public void maxDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            float score = 0.0f;
            float nowScore = 0.0f;
            int size = 0;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                BscMeasureData data = new BscMeasureData();
                data.setActual(Float.valueOf(measureData.getActual()));
                data.setTarget(Float.valueOf(measureData.getTarget()));
                data.setKpi(kpi);
                try {
                    Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                    if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                    nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f);
                    if (size < 1) {
                        score = nowScore;
                    } else if (score < nowScore) {
                        score = nowScore;
                    }
                    ++size;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }

    public float min(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        float score = 0.0f;
        int size = 0;
        float nowScore = 0.0f;
        for (BbMeasureData measureData : measureDatas) {
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            try {
                Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f);
                if (size < 1) {
                    score = nowScore;
                } else if (score > nowScore) {
                    score = nowScore;
                }
                ++size;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return score;
    }

    public void minDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            float score = 0.0f;
            float nowScore = 0.0f;
            int size = 0;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                BscMeasureData data = new BscMeasureData();
                data.setActual(Float.valueOf(measureData.getActual()));
                data.setTarget(Float.valueOf(measureData.getTarget()));
                data.setKpi(kpi);
                try {
                    Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                    if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                    nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f);
                    if (size < 1) {
                        score = nowScore;
                    } else if (score > nowScore) {
                        score = nowScore;
                    }
                    ++size;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }

    public float sum(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        float score = 0.0f;
        for (BbMeasureData measureData : measureDatas) {
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            try {
                Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                score += NumberUtils.toFloat(String.valueOf(value), 0.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return score;
    }

    public void sumDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            float score = 0.0f;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                BscMeasureData data = new BscMeasureData();
                data.setActual(Float.valueOf(measureData.getActual()));
                data.setTarget(Float.valueOf(measureData.getTarget()));
                data.setKpi(kpi);
                try {
                    Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                    if (value == null || !NumberUtils.isCreatable(String.valueOf(value))) continue;
                    score += NumberUtils.toFloat(String.valueOf(value), 0.0f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }

    public float sumDistinct(KpiVO kpi) throws Exception {
        List<BbMeasureData> measureDatas = kpi.getMeasureDatas();
        ArrayList<Float> scores = new ArrayList<Float>();
        float score = 0.0f;
        for (BbMeasureData measureData : measureDatas) {
            BscMeasureData data = new BscMeasureData();
            data.setActual(Float.valueOf(measureData.getActual()));
            data.setTarget(Float.valueOf(measureData.getTarget()));
            data.setKpi(kpi);
            try {
                float nowScore;
                Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                if (value == null || !NumberUtils.isCreatable(String.valueOf(value)) || scores.contains(Float.valueOf(nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f)))) continue;
                scores.add(Float.valueOf(nowScore));
                score += nowScore;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return score;
    }

    public void sumDistinctDateRange(KpiVO kpi, String frequency) throws Exception {
        BscReportSupportUtils.loadExpression();
        for (DateRangeScoreVO dateScore : kpi.getDateRangeScores()) {
            ArrayList<Float> scores = new ArrayList<Float>();
            float score = 0.0f;
            for (BbMeasureData measureData : kpi.getMeasureDatas()) {
                String date = dateScore.getDate().replaceAll("/", "");
                if (!this.isDateRange(date, frequency, measureData)) continue;
                BscMeasureData data = new BscMeasureData();
                data.setActual(Float.valueOf(measureData.getActual()));
                data.setTarget(Float.valueOf(measureData.getTarget()));
                data.setKpi(kpi);
                try {
                    float nowScore;
                    Object value = BscFormulaUtils.parse(kpi.getFormula(), data);
                    if (value == null || !NumberUtils.isCreatable(String.valueOf(value)) || scores.contains(Float.valueOf(nowScore = NumberUtils.toFloat(String.valueOf(value), 0.0f)))) continue;
                    scores.add(Float.valueOf(nowScore));
                    score += nowScore;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dateScore.setScore(score);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateScore.setImgIcon(BscReportSupportUtils.getHtmlIcon(kpi, score));
        }
    }
}

