/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.support;

import com.netsteadfast.greenstep.bsc.support.ScoreCalculationCallableData;
import com.netsteadfast.greenstep.bsc.util.AggregationMethodUtils;
import com.netsteadfast.greenstep.bsc.util.BscScoreColorUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.Years;

public class ScoreCalculationCallable
implements Callable<ScoreCalculationCallableData> {
    private ScoreCalculationCallableData data = null;

    public ScoreCalculationCallable(ScoreCalculationCallableData data) {
        this.data = data;
    }

    @Override
    public ScoreCalculationCallableData call() throws Exception {
        BscScoreColorUtils.loadScoreColors();
        if (this.data.isDefaultMode()) {
            float score = AggregationMethodUtils.processDefaultMode(this.data.getKpi());
            this.data.getKpi().setScore(score);
            this.data.getKpi().setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            this.data.getKpi().setFontColor(BscScoreColorUtils.getFontColor(score));
        } else if ("1".equals(this.data.getFrequency()) || "2".equals(this.data.getFrequency()) || "3".equals(this.data.getFrequency())) {
            this.fillDateRangeMonth(this.data.getKpi(), this.data.getFrequency(), this.data.getDate1(), this.data.getDate2());
        } else {
            this.fillDateRangeYear(this.data.getKpi(), this.data.getFrequency(), this.data.getDate1(), this.data.getDate2());
        }
        return this.data;
    }

    public ScoreCalculationCallableData getData() {
        return this.data;
    }

    public void setData(ScoreCalculationCallableData data) {
        this.data = data;
    }

    private void fillDateRangeYear(KpiVO kpi, String frequency, String date1, String date2) throws Exception {
        List<String> dateRange = this.getDateRange(frequency, date1, date2);
        this.initKpiDateRangeScores(kpi, dateRange);
        AggregationMethodUtils.processDateRangeMode(kpi, frequency);
    }

    private void fillDateRangeMonth(KpiVO kpi, String frequency, String date1, String date2) throws Exception {
        List<String> dateRange = this.getDateRange(frequency, date1, date2);
        this.initKpiDateRangeScores(kpi, dateRange);
        AggregationMethodUtils.processDateRangeMode(kpi, frequency);
    }

    private List<String> getDateRange(String frequency, String date1, String date2) throws Exception {
        LinkedList<String> dateRange = new LinkedList<String>();
        if ("1".equals(frequency) || "2".equals(frequency) || "3".equals(frequency)) {
            DateTime dt1 = new DateTime(String.valueOf(date1.replaceAll("/", "-").substring(0, date1.length() - 2)) + "01");
            DateTime dt2 = new DateTime(String.valueOf(date2.replaceAll("/", "-").substring(0, date2.length() - 2)) + "01");
            int betweenMonths = Months.monthsBetween(dt1, dt2).getMonths();
            Date nowDate = dt1.toDate();
            int i = 0;
            while (i <= betweenMonths) {
                dateRange.add(SimpleUtils.getStrYMD(nowDate, "/").substring(0, 7));
                nowDate = DateUtils.addMonths(nowDate, 1);
                ++i;
            }
            return dateRange;
        }
        if ("4".equals(frequency)) {
            DateTime dt1 = new DateTime(String.valueOf(date1) + "-01-01");
            DateTime dt2 = new DateTime(String.valueOf(date2) + "-01-01");
            int betweenYears = Years.yearsBetween(dt1, dt2).getYears();
            Date nowDate = dt1.toDate();
            int i = 0;
            while (i <= betweenYears) {
                String yyyy = SimpleUtils.getStrYMD(nowDate, "/").substring(0, 4);
                dateRange.add(String.valueOf(yyyy) + "/" + "Q1");
                dateRange.add(String.valueOf(yyyy) + "/" + "Q2");
                dateRange.add(String.valueOf(yyyy) + "/" + "Q3");
                dateRange.add(String.valueOf(yyyy) + "/" + "Q4");
                nowDate = DateUtils.addYears(nowDate, 1);
                ++i;
            }
            return dateRange;
        }
        if ("5".equals(frequency)) {
            DateTime dt1 = new DateTime(String.valueOf(date1) + "-01-01");
            DateTime dt2 = new DateTime(String.valueOf(date2) + "-01-01");
            int betweenYears = Years.yearsBetween(dt1, dt2).getYears();
            Date nowDate = dt1.toDate();
            int i = 0;
            while (i <= betweenYears) {
                String yyyy = SimpleUtils.getStrYMD(nowDate, "/").substring(0, 4);
                dateRange.add(String.valueOf(yyyy) + "/" + "first");
                dateRange.add(String.valueOf(yyyy) + "/" + "last");
                nowDate = DateUtils.addYears(nowDate, 1);
                ++i;
            }
            return dateRange;
        }
        int begYear = Integer.parseInt(date1.substring(0, 4));
        int endYear = Integer.parseInt(date2.substring(0, 4));
        int i = begYear;
        while (i <= endYear) {
            dateRange.add(String.valueOf(i));
            ++i;
        }
        return dateRange;
    }

    private void initKpiDateRangeScores(KpiVO kpi, List<String> dateRange) throws Exception {
        for (String date : dateRange) {
            DateRangeScoreVO dateScore = new DateRangeScoreVO();
            dateScore.setTarget(kpi.getTarget());
            dateScore.setMin(kpi.getMin());
            dateScore.setDate(date);
            dateScore.setScore(0.0f);
            dateScore.setFontColor(BscScoreColorUtils.getFontColor(0.0f));
            dateScore.setBgColor(BscScoreColorUtils.getBackgroundColor(0.0f));
            dateScore.setImgIcon("");
            kpi.getDateRangeScores().add(dateScore);
        }
    }
}

