/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.BaseEntity;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IObjectiveService;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.logic.IWeightLogicService;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbObjective;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.WeightLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class WeightLogicServiceImpl
extends CoreBaseLogicService
implements IWeightLogicService {
    protected Logger logger = Logger.getLogger(WeightLogicServiceImpl.class);
    private IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService;
    private IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;

    public IPerspectiveService<PerspectiveVO, BbPerspective, String> getPerspectiveService() {
        return this.perspectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.PerspectiveService")
    @Required
    public void setPerspectiveService(IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    public IObjectiveService<ObjectiveVO, BbObjective, String> getObjectiveService() {
        return this.objectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.ObjectiveService")
    @Required
    public void setObjectiveService(IObjectiveService<ObjectiveVO, BbObjective, String> objectiveService) {
        this.objectiveService = objectiveService;
    }

    public IKpiService<KpiVO, BbKpi, String> getKpiService() {
        return this.kpiService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiService")
    @Required
    public void setKpiService(IKpiService<KpiVO, BbKpi, String> kpiService) {
        this.kpiService = kpiService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> update(List<PerspectiveVO> perspectives, List<ObjectiveVO> objectives, List<KpiVO> kpis) throws ServiceException, Exception {
        BaseEntity entity;
        if (perspectives == null || perspectives.size() < 1 || objectives == null || objectives.size() < 1 || kpis == null || kpis.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        for (PerspectiveVO perspective : perspectives) {
            entity = (BbPerspective)this.perspectiveService.findByPKng(perspective.getOid());
            ((BbPerspective)entity).setWeight(perspective.getWeight());
            this.perspectiveService.update((BbPerspective)entity);
        }
        for (ObjectiveVO objective : objectives) {
            entity = (BbObjective)this.objectiveService.findByPKng(objective.getOid());
            ((BbObjective)entity).setWeight(objective.getWeight());
            this.objectiveService.update((BbObjective)entity);
        }
        for (KpiVO kpi : kpis) {
            entity = (BbKpi)this.kpiService.findByPKng(kpi.getOid());
            ((BbKpi)entity).setWeight(kpi.getWeight());
            this.kpiService.update((BbKpi)entity);
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        result.setValue(Boolean.TRUE);
        return result;
    }
}

