/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IMonitorItemScoreService;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapConnsService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapNodesService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapService;
import com.netsteadfast.greenstep.bsc.service.ISwotService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.service.logic.IVisionLogicService;
import com.netsteadfast.greenstep.po.hbm.BbMonitorItemScore;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMap;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMapConns;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMapNodes;
import com.netsteadfast.greenstep.po.hbm.BbSwot;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.MonitorItemScoreVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.StrategyMapConnsVO;
import com.netsteadfast.greenstep.vo.StrategyMapNodesVO;
import com.netsteadfast.greenstep.vo.StrategyMapVO;
import com.netsteadfast.greenstep.vo.SwotVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.VisionLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class VisionLogicServiceImpl
extends CoreBaseLogicService
implements IVisionLogicService {
    protected Logger logger = Logger.getLogger(VisionLogicServiceImpl.class);
    private IVisionService<VisionVO, BbVision, String> visionService;
    private IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService;
    private IStrategyMapService<StrategyMapVO, BbStrategyMap, String> strategyMapService;
    private IStrategyMapNodesService<StrategyMapNodesVO, BbStrategyMapNodes, String> strategyMapNodesService;
    private IStrategyMapConnsService<StrategyMapConnsVO, BbStrategyMapConns, String> strategyMapConnsService;
    private ISwotService<SwotVO, BbSwot, String> swotService;
    private IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService;

    public IVisionService<VisionVO, BbVision, String> getVisionService() {
        return this.visionService;
    }

    @Autowired
    @Resource(name="bsc.service.VisionService")
    @Required
    public void setVisionService(IVisionService<VisionVO, BbVision, String> visionService) {
        this.visionService = visionService;
    }

    public IPerspectiveService<PerspectiveVO, BbPerspective, String> getPerspectiveService() {
        return this.perspectiveService;
    }

    @Autowired
    @Resource(name="bsc.service.PerspectiveService")
    @Required
    public void setPerspectiveService(IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    public IStrategyMapService<StrategyMapVO, BbStrategyMap, String> getStrategyMapService() {
        return this.strategyMapService;
    }

    @Autowired
    @Resource(name="bsc.service.StrategyMapService")
    @Required
    public void setStrategyMapService(IStrategyMapService<StrategyMapVO, BbStrategyMap, String> strategyMapService) {
        this.strategyMapService = strategyMapService;
    }

    public IStrategyMapNodesService<StrategyMapNodesVO, BbStrategyMapNodes, String> getStrategyMapNodesService() {
        return this.strategyMapNodesService;
    }

    @Autowired
    @Resource(name="bsc.service.StrategyMapNodesService")
    @Required
    public void setStrategyMapNodesService(IStrategyMapNodesService<StrategyMapNodesVO, BbStrategyMapNodes, String> strategyMapNodesService) {
        this.strategyMapNodesService = strategyMapNodesService;
    }

    public IStrategyMapConnsService<StrategyMapConnsVO, BbStrategyMapConns, String> getStrategyMapConnsService() {
        return this.strategyMapConnsService;
    }

    @Autowired
    @Resource(name="bsc.service.StrategyMapConnsService")
    @Required
    public void setStrategyMapConnsService(IStrategyMapConnsService<StrategyMapConnsVO, BbStrategyMapConns, String> strategyMapConnsService) {
        this.strategyMapConnsService = strategyMapConnsService;
    }

    public ISwotService<SwotVO, BbSwot, String> getSwotService() {
        return this.swotService;
    }

    @Autowired
    @Resource(name="bsc.service.SwotService")
    @Required
    public void setSwotService(ISwotService<SwotVO, BbSwot, String> swotService) {
        this.swotService = swotService;
    }

    public IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> getMonitorItemScoreService() {
        return this.monitorItemScoreService;
    }

    @Autowired
    @Resource(name="bsc.service.MonitorItemScoreService")
    @Required
    public void setMonitorItemScoreService(IMonitorItemScoreService<MonitorItemScoreVO, BbMonitorItemScore, String> monitorItemScoreService) {
        this.monitorItemScoreService = monitorItemScoreService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<VisionVO> create(VisionVO vision) throws ServiceException, Exception {
        if (vision == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (!SimpleUtils.checkBeTrueOf_azAZ09(4, 14, vision.getVisId())) {
            vision.setVisId(this.findForMaxVisId(SimpleUtils.getStrYMD("")));
        }
        return this.visionService.saveObject(vision);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<VisionVO> update(VisionVO vision) throws ServiceException, Exception {
        if (vision == null || super.isBlank(vision.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<VisionVO> oldResult = this.visionService.findObjectByOid(vision);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        oldResult.getValue().setContent(null);
        this.visionService.updateObject(oldResult.getValue());
        vision.setVisId(oldResult.getValue().getVisId());
        return this.visionService.updateObject(vision);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(VisionVO vision) throws ServiceException, Exception {
        if (vision == null || super.isBlank(vision.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<VisionVO> oldResult = this.visionService.findObjectByOid(vision);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        vision = oldResult.getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("visId", vision.getVisId());
        if (this.perspectiveService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        this.deleteStrategyMap(vision);
        this.swotService.deleteForVisId(vision.getVisId());
        this.monitorItemScoreService.deleteForTypeClass("1", vision.getVisId());
        return this.visionService.deleteObject(vision);
    }

    private void deleteStrategyMap(VisionVO vision) throws ServiceException, Exception {
        StrategyMapVO strategyMap = new StrategyMapVO();
        strategyMap.setVisId(vision.getVisId());
        DefaultResult<StrategyMapVO> smResult = this.strategyMapService.findByUK(strategyMap);
        if (smResult.getValue() == null) {
            return;
        }
        strategyMap = smResult.getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterOid", strategyMap.getOid());
        List nodes = this.strategyMapNodesService.findListByParams(params);
        List conns = this.strategyMapConnsService.findListByParams(params);
        int i = 0;
        while (nodes != null && i < nodes.size()) {
            this.strategyMapNodesService.delete((BbStrategyMapNodes)nodes.get(i));
            ++i;
        }
        i = 0;
        while (conns != null && i < conns.size()) {
            this.strategyMapConnsService.delete((BbStrategyMapConns)conns.get(i));
            ++i;
        }
        this.strategyMapService.deleteObject(strategyMap);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public String findForMaxVisId(String date) throws ServiceException, Exception {
        if (super.isBlank(date) || !NumberUtils.isCreatable(date) || date.length() != 8) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        String maxVisionId = this.visionService.findForMaxVisId("VIS" + date);
        if (StringUtils.isBlank(maxVisionId)) {
            return "VIS" + date + "001";
        }
        int maxSeq = Integer.parseInt(maxVisionId.substring(11, 14)) + 1;
        if (maxSeq > 999) {
            throw new ServiceException(String.valueOf(SysMessageUtil.get("MSG_STD0005")) + " over max seq 999!");
        }
        return "VIS" + date + StringUtils.leftPad(String.valueOf(maxSeq), 3, "0");
    }
}

