/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BscBaseBusinessProcessManagementLogicService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IPdcaAuditService;
import com.netsteadfast.greenstep.bsc.service.IPdcaDocService;
import com.netsteadfast.greenstep.bsc.service.IPdcaItemDocService;
import com.netsteadfast.greenstep.bsc.service.IPdcaItemOwnerService;
import com.netsteadfast.greenstep.bsc.service.IPdcaItemService;
import com.netsteadfast.greenstep.bsc.service.IPdcaKpisService;
import com.netsteadfast.greenstep.bsc.service.IPdcaMeasureFreqService;
import com.netsteadfast.greenstep.bsc.service.IPdcaOrgaService;
import com.netsteadfast.greenstep.bsc.service.IPdcaOwnerService;
import com.netsteadfast.greenstep.bsc.service.IPdcaService;
import com.netsteadfast.greenstep.bsc.service.logic.IPdcaLogicService;
import com.netsteadfast.greenstep.bsc.vo.PdcaProjectRelatedVO;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbPdca;
import com.netsteadfast.greenstep.po.hbm.BbPdcaAudit;
import com.netsteadfast.greenstep.po.hbm.BbPdcaDoc;
import com.netsteadfast.greenstep.po.hbm.BbPdcaItem;
import com.netsteadfast.greenstep.po.hbm.BbPdcaItemDoc;
import com.netsteadfast.greenstep.po.hbm.BbPdcaItemOwner;
import com.netsteadfast.greenstep.po.hbm.BbPdcaKpis;
import com.netsteadfast.greenstep.po.hbm.BbPdcaMeasureFreq;
import com.netsteadfast.greenstep.po.hbm.BbPdcaOrga;
import com.netsteadfast.greenstep.po.hbm.BbPdcaOwner;
import com.netsteadfast.greenstep.util.BusinessProcessManagementUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.BusinessProcessManagementTaskVO;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PdcaAuditVO;
import com.netsteadfast.greenstep.vo.PdcaDocVO;
import com.netsteadfast.greenstep.vo.PdcaItemDocVO;
import com.netsteadfast.greenstep.vo.PdcaItemOwnerVO;
import com.netsteadfast.greenstep.vo.PdcaItemVO;
import com.netsteadfast.greenstep.vo.PdcaKpisVO;
import com.netsteadfast.greenstep.vo.PdcaMeasureFreqVO;
import com.netsteadfast.greenstep.vo.PdcaOrgaVO;
import com.netsteadfast.greenstep.vo.PdcaOwnerVO;
import com.netsteadfast.greenstep.vo.PdcaVO;
import com.netsteadfast.greenstep.vo.SysUploadVO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.PdcaLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class PdcaLogicServiceImpl
extends BscBaseBusinessProcessManagementLogicService
implements IPdcaLogicService {
    protected Logger logger = Logger.getLogger(PdcaLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private static final int MAX_PROJECT_RELATED_SHOW = 5;
    private IPdcaService<PdcaVO, BbPdca, String> pdcaService;
    private IPdcaDocService<PdcaDocVO, BbPdcaDoc, String> pdcaDocService;
    private IPdcaKpisService<PdcaKpisVO, BbPdcaKpis, String> pdcaKpisService;
    private IPdcaOrgaService<PdcaOrgaVO, BbPdcaOrga, String> pdcaOrgaService;
    private IPdcaOwnerService<PdcaOwnerVO, BbPdcaOwner, String> pdcaOwnerService;
    private IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> pdcaMeasureFreqService;
    private IPdcaItemService<PdcaItemVO, BbPdcaItem, String> pdcaItemService;
    private IPdcaAuditService<PdcaAuditVO, BbPdcaAudit, String> pdcaAuditService;
    private IPdcaItemDocService<PdcaItemDocVO, BbPdcaItemDoc, String> pdcaItemDocService;
    private IPdcaItemOwnerService<PdcaItemOwnerVO, BbPdcaItemOwner, String> pdcaItemOwnerService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;

    @Override
    public String getBusinessProcessManagementResourceId() {
        return "PDCAProjectProcess";
    }

    public IPdcaService<PdcaVO, BbPdca, String> getPdcaService() {
        return this.pdcaService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaService")
    @Required
    public void setPdcaService(IPdcaService<PdcaVO, BbPdca, String> pdcaService) {
        this.pdcaService = pdcaService;
    }

    public IPdcaDocService<PdcaDocVO, BbPdcaDoc, String> getPdcaDocService() {
        return this.pdcaDocService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaDocService")
    @Required
    public void setPdcaDocService(IPdcaDocService<PdcaDocVO, BbPdcaDoc, String> pdcaDocService) {
        this.pdcaDocService = pdcaDocService;
    }

    public IPdcaKpisService<PdcaKpisVO, BbPdcaKpis, String> getPdcaKpisService() {
        return this.pdcaKpisService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaKpisService")
    @Required
    public void setPdcaKpisService(IPdcaKpisService<PdcaKpisVO, BbPdcaKpis, String> pdcaKpisService) {
        this.pdcaKpisService = pdcaKpisService;
    }

    public IPdcaOrgaService<PdcaOrgaVO, BbPdcaOrga, String> getPdcaOrgaService() {
        return this.pdcaOrgaService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaOrgaService")
    @Required
    public void setPdcaOrgaService(IPdcaOrgaService<PdcaOrgaVO, BbPdcaOrga, String> pdcaOrgaService) {
        this.pdcaOrgaService = pdcaOrgaService;
    }

    public IPdcaOwnerService<PdcaOwnerVO, BbPdcaOwner, String> getPdcaOwnerService() {
        return this.pdcaOwnerService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaOwnerService")
    @Required
    public void setPdcaOwnerService(IPdcaOwnerService<PdcaOwnerVO, BbPdcaOwner, String> pdcaOwnerService) {
        this.pdcaOwnerService = pdcaOwnerService;
    }

    public IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> getPdcaMeasureFreqService() {
        return this.pdcaMeasureFreqService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaMeasureFreqService")
    @Required
    public void setPdcaMeasureFreqService(IPdcaMeasureFreqService<PdcaMeasureFreqVO, BbPdcaMeasureFreq, String> pdcaMeasureFreqService) {
        this.pdcaMeasureFreqService = pdcaMeasureFreqService;
    }

    public IPdcaItemService<PdcaItemVO, BbPdcaItem, String> getPdcaItemService() {
        return this.pdcaItemService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaItemService")
    @Required
    public void setPdcaItemService(IPdcaItemService<PdcaItemVO, BbPdcaItem, String> pdcaItemService) {
        this.pdcaItemService = pdcaItemService;
    }

    public IPdcaAuditService<PdcaAuditVO, BbPdcaAudit, String> getPdcaAuditService() {
        return this.pdcaAuditService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaAuditService")
    @Required
    public void setPdcaAuditService(IPdcaAuditService<PdcaAuditVO, BbPdcaAudit, String> pdcaAuditService) {
        this.pdcaAuditService = pdcaAuditService;
    }

    public IPdcaItemDocService<PdcaItemDocVO, BbPdcaItemDoc, String> getPdcaItemDocService() {
        return this.pdcaItemDocService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaItemDocService")
    @Required
    public void setPdcaItemDocService(IPdcaItemDocService<PdcaItemDocVO, BbPdcaItemDoc, String> pdcaItemDocService) {
        this.pdcaItemDocService = pdcaItemDocService;
    }

    public IPdcaItemOwnerService<PdcaItemOwnerVO, BbPdcaItemOwner, String> getPdcaItemOwnerService() {
        return this.pdcaItemOwnerService;
    }

    @Autowired
    @Resource(name="bsc.service.PdcaItemOwnerService")
    @Required
    public void setPdcaItemOwnerService(IPdcaItemOwnerService<PdcaItemOwnerVO, BbPdcaItemOwner, String> pdcaItemOwnerService) {
        this.pdcaItemOwnerService = pdcaItemOwnerService;
    }

    public IKpiService<KpiVO, BbKpi, String> getKpiService() {
        return this.kpiService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiService")
    @Required
    public void setKpiService(IKpiService<KpiVO, BbKpi, String> kpiService) {
        this.kpiService = kpiService;
    }

    private Map<String, Object> getProcessFlowParam(String pdcaOid, String pdcaType, String date, String userid, String confirm, String reason, String newChild) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdcaOid);
        paramMap.put("pdcaType", pdcaType);
        paramMap.put("confirm", confirm);
        paramMap.put("reason", super.defaultString(reason).length() > 500 ? reason.substring(0, 500) : reason);
        paramMap.put("date", date);
        paramMap.put("cuserid", userid);
        paramMap.put("new_chile", newChild);
        return paramMap;
    }

    private PdcaVO findPdca(String oid) throws ServiceException, Exception {
        PdcaVO pdca = new PdcaVO();
        pdca.setOid(oid);
        DefaultResult<PdcaVO> result = this.pdcaService.findObjectByOid(pdca);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        pdca = result.getValue();
        return pdca;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<PdcaVO> create(PdcaVO pdca, PdcaMeasureFreqVO measureFreq, List<String> organizationOids, List<String> employeeOids, List<String> kpiOids, List<String> attachment, List<PdcaItemVO> items) throws ServiceException, Exception {
        if (pdca == null || super.isBlank(pdca.getTitle()) || items == null || items.size() < 1 || organizationOids.size() < 1 || employeeOids.size() < 1 || kpiOids.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        this.setStringValueMaxLength(pdca, "description", 500);
        pdca.setConfirmFlag("N");
        this.replaceSplit2Blank(pdca, "startDate", "/");
        this.replaceSplit2Blank(pdca, "endDate", "/");
        DefaultResult<PdcaVO> result = this.pdcaService.saveObject(pdca);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        pdca = result.getValue();
        this.createMeasureFreq(pdca, measureFreq);
        this.createOwner(pdca, employeeOids);
        this.createOrganization(pdca, organizationOids);
        this.createKpis(pdca, kpiOids);
        this.createDocuments(pdca, attachment);
        this.createItems(pdca, items);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<PdcaVO> update(PdcaVO pdca, PdcaMeasureFreqVO measureFreq, List<String> organizationOids, List<String> employeeOids, List<String> kpiOids, List<String> attachment, List<PdcaItemVO> items) throws ServiceException, Exception {
        if (pdca == null || super.isBlank(pdca.getOid()) || super.isBlank(pdca.getTitle()) || items == null || items.size() < 1 || organizationOids.size() < 1 || employeeOids.size() < 1 || kpiOids.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<PdcaVO> oldResult = this.pdcaService.findObjectByOid(pdca);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        if (pdca.getTitle().equals(oldResult.getValue().getTitle()) && !pdca.getOid().equals(oldResult.getValue().getOid())) {
            throw new ServiceException("Same title is found: " + pdca.getTitle());
        }
        if ("Y".equals(oldResult.getValue().getConfirmFlag())) {
            throw new ServiceException("Cannot update/modify confirm project!");
        }
        this.setStringValueMaxLength(pdca, "description", 500);
        pdca.setConfirmFlag("N");
        this.replaceSplit2Blank(pdca, "startDate", "/");
        this.replaceSplit2Blank(pdca, "endDate", "/");
        pdca.setParentOid(oldResult.getValue().getParentOid());
        DefaultResult<PdcaVO> result = this.pdcaService.updateObject(pdca);
        pdca = result.getValue();
        this.deleteMeasureFreq(pdca);
        this.deleteOwner(pdca);
        this.deleteOrganization(pdca);
        this.deleteKpis(pdca);
        this.deleteDocuments(pdca);
        this.deleteItems(pdca);
        this.createMeasureFreq(pdca, measureFreq);
        this.createOwner(pdca, employeeOids);
        this.createOrganization(pdca, organizationOids);
        this.createKpis(pdca, kpiOids);
        this.createDocuments(pdca, attachment);
        this.createItems(pdca, items);
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(PdcaVO pdca) throws ServiceException, Exception {
        if (pdca == null || super.isBlank(pdca.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("parentOid", pdca.getOid());
        if (this.pdcaService.countByParams(paramMap) > 0L) {
            throw new ServiceException("The project has child project, cannot delete!");
        }
        List<BusinessProcessManagementTaskVO> tasks = this.queryTaskByVariablePdcaOid(pdca.getOid());
        if (tasks != null && tasks.size() > 0) {
            throw new ServiceException("Audit processing running, project cannot delete!");
        }
        this.deleteMeasureFreq(pdca);
        this.deleteOwner(pdca);
        this.deleteOrganization(pdca);
        this.deleteKpis(pdca);
        this.deleteDocuments(pdca);
        this.deleteItems(pdca);
        return this.pdcaService.deleteObject(pdca);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<PdcaVO> startProcess(PdcaVO pdca) throws ServiceException, Exception {
        if (pdca == null || super.isBlank(pdca.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<PdcaVO> result = this.pdcaService.findObjectByOid(pdca);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        pdca = result.getValue();
        if ("Y".equals(pdca.getConfirmFlag())) {
            throw new ServiceException("The project is confirm, cannot start audit processing!");
        }
        List<BusinessProcessManagementTaskVO> tasks = this.queryTaskByVariablePdcaOid(pdca.getOid());
        if (tasks != null && tasks.size() > 0) {
            throw new ServiceException("Audit processing has been started!");
        }
        String reason = "Start PDCA audit processing, " + pdca.getTitle();
        this.startProcess(this.getProcessFlowParam(pdca.getOid(), "*", SimpleUtils.getStrYMD(""), super.getAccountId(), "Y", reason, "N"));
        result.setSystemMessage(new SystemMessage(reason));
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public List<BusinessProcessManagementTaskVO> queryTaskByVariablePdcaOid(String pdcaOid) throws ServiceException, Exception {
        if (super.isBlank(pdcaOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.queryTaskPlus("pdcaOid", pdcaOid);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public String getTaskDiagram(String taskId) throws ServiceException, Exception {
        if (super.isBlank(taskId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return BusinessProcessManagementUtils.getTaskDiagramById2Upload(this.getBusinessProcessManagementResourceId(), taskId);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public void confirmTask(String pdcaOid, String taskId, String confirm, String reason, String newChild) throws ServiceException, Exception {
        if (super.isBlank(pdcaOid) || super.isBlank(taskId) || super.isBlank(confirm)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        PdcaVO pdca = this.findPdca(pdcaOid);
        String newDate = SimpleUtils.getStrYMD("");
        String type = "E";
        List<BusinessProcessManagementTaskVO> tasks = this.queryTaskByVariablePdcaOid(pdca.getOid());
        if (tasks != null && tasks.size() > 0) {
            type = tasks.get(0).getTask().getName().substring(0, 1);
        }
        Map<String, Object> flowDataMap = this.getProcessFlowParam(pdcaOid, type, newDate, super.getAccountId(), confirm, reason, newChild);
        this.completeTask(taskId, flowDataMap);
        this.createAudit(pdca, flowDataMap);
        tasks = this.queryTaskByVariablePdcaOid(pdca.getOid());
        if (tasks != null && tasks.size() > 0) {
            return;
        }
        if ("Y".equals(confirm)) {
            pdca.setConfirmDate(newDate);
            pdca.setConfirmEmpId(this.findEmployeeDataByAccountId(super.getAccountId()).getEmpId());
            pdca.setConfirmFlag("Y");
            this.pdcaService.updateObject(pdca);
        }
        if ("Y".equals(confirm) && "Y".equals(newChild)) {
            this.cloneNewProject(pdca);
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public PdcaProjectRelatedVO findProjectRelated(String pdcaOid) throws ServiceException, Exception {
        if (super.isBlank(pdcaOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        PdcaVO pdca = this.findPdca(pdcaOid);
        PdcaProjectRelatedVO projectRelated = new PdcaProjectRelatedVO();
        projectRelated.setProject(pdca);
        this.findProjectRelatedParent(projectRelated, pdca);
        this.findProjectRelatedChild(projectRelated, pdca);
        return projectRelated;
    }

    private void findProjectRelatedParent(PdcaProjectRelatedVO projectRelated, PdcaVO pdca) throws ServiceException, Exception {
        if (super.isBlank(pdca.getParentOid()) || projectRelated.getParent().size() >= 5) {
            return;
        }
        PdcaVO parentPdca = this.findPdca(pdca.getParentOid());
        ((LinkedList)projectRelated.getParent()).addFirst(parentPdca);
        this.findProjectRelatedParent(projectRelated, parentPdca);
    }

    private void findProjectRelatedChild(PdcaProjectRelatedVO projectRelated, PdcaVO pdca) throws ServiceException, Exception {
        if (projectRelated.getChild().size() >= 5) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("parentOid", pdca.getOid());
        List childList = this.pdcaService.findListVOByParams(paramMap);
        if (childList == null || childList.size() < 1) {
            return;
        }
        if (childList.size() != 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        ((LinkedList)projectRelated.getChild()).addLast((PdcaVO)childList.get(0));
        this.findProjectRelatedChild(projectRelated, (PdcaVO)childList.get(0));
    }

    private void deleteMeasureFreq(PdcaVO pdca) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List measureFreqList = this.pdcaMeasureFreqService.findListByParams(paramMap);
        for (BbPdcaMeasureFreq measureFreq : measureFreqList) {
            this.pdcaMeasureFreqService.delete(measureFreq);
        }
    }

    private void createMeasureFreq(PdcaVO pdca, PdcaMeasureFreqVO measureFreq) throws ServiceException, Exception {
        measureFreq.setPdcaOid(pdca.getOid());
        this.replaceSplit2Blank(measureFreq, "startDate", "/");
        this.replaceSplit2Blank(measureFreq, "endDate", "/");
        if (this.isNoSelectId(measureFreq.getOrganizationOid())) {
            measureFreq.setOrgId("*");
        } else {
            measureFreq.setOrgId(this.findOrganizationData(measureFreq.getOrganizationOid()).getOrgId());
        }
        if (this.isNoSelectId(measureFreq.getEmployeeOid())) {
            measureFreq.setEmpId("*");
        } else {
            measureFreq.setEmpId(this.findEmployeeData(measureFreq.getEmployeeOid()).getEmpId());
        }
        this.pdcaMeasureFreqService.saveObject(measureFreq);
    }

    private void deleteOrganization(PdcaVO pdca) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List orgaList = this.pdcaOrgaService.findListByParams(paramMap);
        for (BbPdcaOrga orga : orgaList) {
            this.pdcaOrgaService.delete(orga);
        }
    }

    private void createOrganization(PdcaVO pdca, List<String> orgaOids) throws ServiceException, Exception {
        for (String oid : orgaOids) {
            OrganizationVO organization = this.findOrganizationData(oid);
            PdcaOrgaVO pdcaOrga = new PdcaOrgaVO();
            pdcaOrga.setPdcaOid(pdca.getOid());
            pdcaOrga.setOrgId(organization.getOrgId());
            this.pdcaOrgaService.saveObject(pdcaOrga);
        }
    }

    private void deleteOwner(PdcaVO pdca) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List ownerList = this.pdcaOwnerService.findListByParams(paramMap);
        for (BbPdcaOwner owner : ownerList) {
            this.pdcaOwnerService.delete(owner);
        }
    }

    private void createOwner(PdcaVO pdca, List<String> emplOids) throws ServiceException, Exception {
        for (String oid : emplOids) {
            EmployeeVO employee = this.findEmployeeData(oid);
            PdcaOwnerVO pdcaOwner = new PdcaOwnerVO();
            pdcaOwner.setPdcaOid(pdca.getOid());
            pdcaOwner.setEmpId(employee.getEmpId());
            this.pdcaOwnerService.saveObject(pdcaOwner);
        }
    }

    private void deleteKpis(PdcaVO pdca) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List kpisList = this.pdcaKpisService.findListByParams(paramMap);
        for (BbPdcaKpis kpi : kpisList) {
            this.pdcaKpisService.delete(kpi);
        }
    }

    private void createKpis(PdcaVO pdca, List<String> kpiOids) throws ServiceException, Exception {
        for (String oid : kpiOids) {
            KpiVO kpi = new KpiVO();
            kpi.setOid(oid);
            DefaultResult<KpiVO> kpiResult = this.kpiService.findObjectByOid(kpi);
            if (kpiResult.getValue() == null) {
                throw new ServiceException(kpiResult.getSystemMessage().getValue());
            }
            kpi = kpiResult.getValue();
            if (!"Y".equals(kpi.getActivate())) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            PdcaKpisVO pdcaKpi = new PdcaKpisVO();
            pdcaKpi.setPdcaOid(pdca.getOid());
            pdcaKpi.setKpiId(kpi.getId());
            this.pdcaKpisService.saveObject(pdcaKpi);
        }
    }

    private void deleteDocuments(PdcaVO pdca) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List docList = this.pdcaDocService.findListByParams(paramMap);
        for (BbPdcaDoc doc : docList) {
            UploadSupportUtils.updateType(doc.getUploadOid(), "tmp");
            this.pdcaDocService.delete(doc);
        }
    }

    private void createDocuments(PdcaVO pdca, List<String> attachment) throws ServiceException, Exception {
        if (attachment == null || attachment.size() < 1) {
            return;
        }
        for (String oid : attachment) {
            SysUploadVO upload = this.findUploadDataForNoByteContent(oid);
            if (!upload.getSystem().equals(Constants.getSystem()) || !upload.getType().equals("tmp")) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            PdcaDocVO pdcaDoc = new PdcaDocVO();
            pdcaDoc.setPdcaOid(pdca.getOid());
            pdcaDoc.setUploadOid(upload.getOid());
            pdcaDoc.setViewMode(UploadSupportUtils.getViewMode(upload.getShowName()));
            DefaultResult<PdcaDocVO> result = this.pdcaDocService.saveObject(pdcaDoc);
            if (result.getValue() == null) {
                throw new ServiceException(result.getSystemMessage().getValue());
            }
            UploadSupportUtils.updateType(oid, "pdca-doc");
        }
    }

    private void deleteItems(PdcaVO pdca) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List items = this.pdcaItemService.findListByParams(paramMap);
        for (BbPdcaItem item : items) {
            this.deleteItemOwner(item);
            this.deleteItemDocuments(item);
            this.pdcaItemService.delete(item);
        }
    }

    private void createItems(PdcaVO pdca, List<PdcaItemVO> items) throws ServiceException, Exception {
        for (PdcaItemVO itemObj : items) {
            itemObj.setPdcaOid(pdca.getOid());
            this.setStringValueMaxLength(itemObj, "description", 500);
            this.replaceSplit2Blank(itemObj, "startDate", "/");
            this.replaceSplit2Blank(itemObj, "endDate", "/");
            DefaultResult<PdcaItemVO> result = this.pdcaItemService.saveObject(itemObj);
            if (result.getValue() == null) {
                throw new ServiceException(result.getSystemMessage().getValue());
            }
            PdcaItemVO item = result.getValue();
            item.setEmployeeOids(itemObj.getEmployeeOids());
            item.setUploadOids(itemObj.getUploadOids());
            this.createItemOwner(item);
            this.createItemDocuments(item);
        }
    }

    private void deleteItemOwner(BbPdcaItem pdcaItem) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdcaItem.getPdcaOid());
        paramMap.put("itemOid", pdcaItem.getOid());
        List itemOwnerList = this.pdcaItemOwnerService.findListByParams(paramMap);
        for (BbPdcaItemOwner owner : itemOwnerList) {
            this.pdcaItemOwnerService.delete(owner);
        }
    }

    private void createItemOwner(PdcaItemVO pdcaItem) throws ServiceException, Exception {
        for (String oid : pdcaItem.getEmployeeOids()) {
            EmployeeVO employee = this.findEmployeeData(oid);
            PdcaItemOwnerVO itemOwner = new PdcaItemOwnerVO();
            itemOwner.setPdcaOid(pdcaItem.getPdcaOid());
            itemOwner.setItemOid(pdcaItem.getOid());
            itemOwner.setEmpId(employee.getEmpId());
            this.pdcaItemOwnerService.saveObject(itemOwner);
        }
    }

    private void deleteItemDocuments(BbPdcaItem pdcaItem) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdcaItem.getPdcaOid());
        paramMap.put("itemOid", pdcaItem.getOid());
        List itemDocList = this.pdcaItemDocService.findListByParams(paramMap);
        for (BbPdcaItemDoc doc : itemDocList) {
            UploadSupportUtils.updateType(doc.getUploadOid(), "tmp");
            this.pdcaItemDocService.delete(doc);
        }
    }

    private void createItemDocuments(PdcaItemVO pdcaItem) throws ServiceException, Exception {
        if (pdcaItem.getUploadOids() == null || pdcaItem.getUploadOids().size() < 1) {
            return;
        }
        for (String oid : pdcaItem.getUploadOids()) {
            SysUploadVO upload = this.findUploadDataForNoByteContent(oid);
            if (!upload.getSystem().equals(Constants.getSystem()) || !upload.getType().equals("tmp")) {
                throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
            }
            PdcaItemDocVO itemDoc = new PdcaItemDocVO();
            itemDoc.setPdcaOid(pdcaItem.getPdcaOid());
            itemDoc.setItemOid(pdcaItem.getOid());
            itemDoc.setUploadOid(upload.getOid());
            itemDoc.setViewMode(UploadSupportUtils.getViewMode(upload.getShowName()));
            DefaultResult<PdcaItemDocVO> result = this.pdcaItemDocService.saveObject(itemDoc);
            if (result.getValue() == null) {
                throw new ServiceException(result.getSystemMessage().getValue());
            }
            UploadSupportUtils.updateType(oid, "pdca-doc");
        }
    }

    private void createAudit(PdcaVO pdca, Map<String, Object> flowDataMap) throws ServiceException, Exception {
        PdcaAuditVO audit = new PdcaAuditVO();
        audit.setPdcaOid(pdca.getOid());
        audit.setEmpId(this.getEmployeeService().findByAccountId((String)flowDataMap.get("cuserid")).getEmpId());
        audit.setType((String)flowDataMap.get("pdcaType"));
        audit.setConfirmDate((String)flowDataMap.get("date"));
        audit.setConfirmSeq(this.pdcaAuditService.findForMaxConfirmSeq(pdca.getOid()) + 1);
        this.pdcaAuditService.saveObject(audit);
    }

    private void cloneNewProject(PdcaVO parentPdca) throws ServiceException, Exception {
        PdcaVO pdca = new PdcaVO();
        this.pdcaService.copyProperties(parentPdca, pdca);
        pdca.setOid(null);
        pdca.setConfirmDate(null);
        pdca.setConfirmEmpId(null);
        pdca.setConfirmFlag("N");
        pdca.setParentOid(parentPdca.getOid());
        String lastTitle = "-(New)";
        if ((String.valueOf(pdca.getTitle()) + lastTitle).length() <= 100) {
            pdca.setTitle(String.valueOf(pdca.getTitle()) + lastTitle);
        } else {
            pdca.setTitle(String.valueOf(pdca.getTitle().substring(pdca.getTitle().length() - lastTitle.length(), 100)) + lastTitle);
        }
        PdcaMeasureFreqVO measureFreq = new PdcaMeasureFreqVO();
        measureFreq.setPdcaOid(parentPdca.getOid());
        DefaultResult<PdcaMeasureFreqVO> mfResult = this.pdcaMeasureFreqService.findByUK(measureFreq);
        if (mfResult.getValue() == null) {
            throw new ServiceException(mfResult.getSystemMessage().getValue());
        }
        measureFreq = mfResult.getValue();
        measureFreq.setOid(null);
        measureFreq.setPdcaOid(null);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", parentPdca.getOid());
        ArrayList<String> organizationOids = new ArrayList<String>();
        List pdcaOrgaList = this.pdcaOrgaService.findListByParams(paramMap);
        for (BbPdcaOrga pdcaOrga : pdcaOrgaList) {
            OrganizationVO organization = this.findOrganizationDataByUK(pdcaOrga.getOrgId());
            organizationOids.add(organization.getOid());
        }
        ArrayList<String> employeeOids = new ArrayList<String>();
        List pdcaOwnerList = this.pdcaOwnerService.findListByParams(paramMap);
        for (BbPdcaOwner pdcaOwner : pdcaOwnerList) {
            EmployeeVO employee = this.findEmployeeDataByEmpId(pdcaOwner.getEmpId());
            employeeOids.add(employee.getOid());
        }
        ArrayList<String> kpiOids = new ArrayList<String>();
        List pdcaKpisList = this.pdcaKpisService.findListByParams(paramMap);
        for (BbPdcaKpis pdcaKpi : pdcaKpisList) {
            KpiVO kpi = new KpiVO();
            kpi.setId(pdcaKpi.getKpiId());
            DefaultResult<KpiVO> kResult = this.kpiService.findByUK(kpi);
            if (kResult.getValue() == null) {
                throw new ServiceException(kResult.getSystemMessage().getValue());
            }
            kpi = (KpiVO)kResult.getValue();
            kpiOids.add(kpi.getOid());
        }
        ArrayList<String> attachment = new ArrayList<String>();
        List pdcaDocList = this.pdcaDocService.findListByParams(paramMap);
        for (BbPdcaDoc pdcaDoc : pdcaDocList) {
            DefaultResult<SysUploadVO> upResult = this.getSysUploadService().findForNoByteContent(pdcaDoc.getUploadOid());
            if (upResult.getValue() == null) {
                throw new ServiceException(upResult.getSystemMessage().getValue());
            }
            SysUploadVO upload = upResult.getValue();
            File oldFile = UploadSupportUtils.getRealFile(pdcaDoc.getUploadOid());
            attachment.add(UploadSupportUtils.create(Constants.getSystem(), "tmp", true, oldFile, upload.getShowName()));
        }
        ArrayList<PdcaItemVO> items = new ArrayList<PdcaItemVO>();
        List pdcaItems = this.pdcaItemService.findListByParams(paramMap);
        for (BbPdcaItem pdcaItem : pdcaItems) {
            PdcaItemVO itemObj = new PdcaItemVO();
            this.pdcaItemService.doMapper(pdcaItem, itemObj, "pdcaItem.po2vo");
            items.add(itemObj);
        }
        for (PdcaItemVO itemObj : items) {
            itemObj.setEmployeeOids(new ArrayList<String>());
            paramMap.put("itemOid", itemObj.getOid());
            List itemOwnerList = this.pdcaItemOwnerService.findListByParams(paramMap);
            for (BbPdcaItemOwner itemOwner : itemOwnerList) {
                itemObj.getEmployeeOids().add(this.findEmployeeDataByEmpId(itemOwner.getEmpId()).getOid());
            }
        }
        for (PdcaItemVO itemObj : items) {
            itemObj.setUploadOids(new ArrayList<String>());
            paramMap.put("itemOid", itemObj.getOid());
            List itemDocList = this.pdcaItemDocService.findListByParams(paramMap);
            for (BbPdcaItemDoc itemDoc : itemDocList) {
                DefaultResult<SysUploadVO> upResult = this.getSysUploadService().findForNoByteContent(itemDoc.getUploadOid());
                if (upResult.getValue() == null) {
                    throw new ServiceException(upResult.getSystemMessage().getValue());
                }
                SysUploadVO upload = upResult.getValue();
                File oldFile = UploadSupportUtils.getRealFile(itemDoc.getUploadOid());
                itemObj.getUploadOids().add(UploadSupportUtils.create(Constants.getSystem(), "tmp", true, oldFile, upload.getShowName()));
            }
        }
        for (PdcaItemVO itemObj : items) {
            itemObj.setOid(null);
            itemObj.setPdcaOid(null);
        }
        this.create(pdca, measureFreq, organizationOids, employeeOids, kpiOids, attachment, items);
    }
}

