/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.CoreBaseLogicService;
import com.netsteadfast.greenstep.bsc.service.IFormulaService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.logic.IFormulaLogicService;
import com.netsteadfast.greenstep.po.hbm.BbFormula;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.vo.FormulaVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="bsc.service.logic.FormulaLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class FormulaLogicServiceImpl
extends CoreBaseLogicService
implements IFormulaLogicService {
    protected Logger logger = Logger.getLogger(FormulaLogicServiceImpl.class);
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private IFormulaService<FormulaVO, BbFormula, String> formulaService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;

    public IFormulaService<FormulaVO, BbFormula, String> getFormulaService() {
        return this.formulaService;
    }

    @Autowired
    @Resource(name="bsc.service.FormulaService")
    @Required
    public void setFormulaService(IFormulaService<FormulaVO, BbFormula, String> formulaService) {
        this.formulaService = formulaService;
    }

    public IKpiService<KpiVO, BbKpi, String> getKpiService() {
        return this.kpiService;
    }

    @Autowired
    @Resource(name="bsc.service.KpiService")
    @Required
    public void setKpiService(IKpiService<KpiVO, BbKpi, String> kpiService) {
        this.kpiService = kpiService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<FormulaVO> create(FormulaVO formula) throws ServiceException, Exception {
        if (formula == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        this.setStringValueMaxLength(formula, "description", 500);
        return this.formulaService.saveObject(formula);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<FormulaVO> update(FormulaVO formula) throws ServiceException, Exception {
        if (formula == null || super.isBlank(formula.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<FormulaVO> oldResult = this.formulaService.findObjectByOid(formula);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        formula.setForId(oldResult.getValue().getForId());
        this.setStringValueMaxLength(formula, "description", 500);
        return this.formulaService.updateObject(formula);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(FormulaVO formula) throws ServiceException, Exception {
        if (formula == null || super.isBlank(formula.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<FormulaVO> oldResult = this.formulaService.findObjectByOid(formula);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("forId", oldResult.getValue().getForId());
        if (this.kpiService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        return this.formulaService.deleteObject(formula);
    }
}

