/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.IWorkspaceDAO;
import com.netsteadfast.greenstep.bsc.service.IWorkspaceService;
import com.netsteadfast.greenstep.po.hbm.BbWorkspace;
import com.netsteadfast.greenstep.vo.WorkspaceVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.WorkspaceService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class WorkspaceServiceImpl
extends BaseService<WorkspaceVO, BbWorkspace, String>
implements IWorkspaceService<WorkspaceVO, BbWorkspace, String> {
    protected Logger logger = Logger.getLogger(WorkspaceServiceImpl.class);
    private IWorkspaceDAO<BbWorkspace, String> workspaceDAO;

    public IWorkspaceDAO<BbWorkspace, String> getWorkspaceDAO() {
        return this.workspaceDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.WorkspaceDAO")
    @Required
    public void setWorkspaceDAO(IWorkspaceDAO<BbWorkspace, String> workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    @Override
    protected IBaseDAO<BbWorkspace, String> getBaseDataAccessObject() {
        return this.workspaceDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "workspace.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "workspace.vo2po";
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).fullEquals4TextField("spaceId").containingLike("name").getValue();
    }

    @Override
    public QueryResult<List<WorkspaceVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<WorkspaceVO>> result = this.workspaceDAO.findPageQueryResultByQueryName("findWorkspacePageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public Map<String, String> findForMap(boolean pleaseSelect) throws ServiceException, Exception {
        Map<String, String> dataMap = this.providedSelectZeroDataMap(pleaseSelect);
        HashMap<String, String> orderParams = new HashMap<String, String>();
        orderParams.put("spaceId", "asc");
        List workspaces = this.findListByParams(null, null, orderParams);
        int i = 0;
        while (workspaces != null && i < workspaces.size()) {
            BbWorkspace workspace = (BbWorkspace)workspaces.get(i);
            dataMap.put(workspace.getOid(), workspace.getName());
            ++i;
        }
        return dataMap;
    }
}

