/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.ITsaDAO;
import com.netsteadfast.greenstep.bsc.service.ITsaService;
import com.netsteadfast.greenstep.po.hbm.BbTsa;
import com.netsteadfast.greenstep.vo.TsaVO;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.TsaService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class TsaServiceImpl
extends BaseService<TsaVO, BbTsa, String>
implements ITsaService<TsaVO, BbTsa, String> {
    protected Logger logger = Logger.getLogger(TsaServiceImpl.class);
    private ITsaDAO<BbTsa, String> tsaDAO;

    public ITsaDAO<BbTsa, String> getTsaDAO() {
        return this.tsaDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.TsaDAO")
    @Required
    public void setTsaDAO(ITsaDAO<BbTsa, String> tsaDAO) {
        this.tsaDAO = tsaDAO;
    }

    @Override
    protected IBaseDAO<BbTsa, String> getBaseDataAccessObject() {
        return this.tsaDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "tsa.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "tsa.vo2po";
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).containingLike("name").getValue();
    }

    @Override
    public QueryResult<List<TsaVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<TsaVO>> result = this.tsaDAO.findPageQueryResultByQueryName("findTsaPageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public Map<String, String> findForMap(boolean pleaseSelect) throws ServiceException, Exception {
        Map<String, String> dataMap = this.providedSelectZeroDataMap(pleaseSelect);
        List searchList = this.findListByParams(null);
        if (searchList == null || searchList.size() < 1) {
            return dataMap;
        }
        for (BbTsa tsa : searchList) {
            dataMap.put(tsa.getOid(), tsa.getName());
        }
        return dataMap;
    }
}

