/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.IFormulaDAO;
import com.netsteadfast.greenstep.bsc.service.IFormulaService;
import com.netsteadfast.greenstep.po.hbm.BbFormula;
import com.netsteadfast.greenstep.vo.FormulaVO;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.FormulaService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class FormulaServiceImpl
extends BaseService<FormulaVO, BbFormula, String>
implements IFormulaService<FormulaVO, BbFormula, String> {
    protected Logger logger = Logger.getLogger(FormulaServiceImpl.class);
    private IFormulaDAO<BbFormula, String> formulaDAO;

    public IFormulaDAO<BbFormula, String> getFormulaDAO() {
        return this.formulaDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.FormulaDAO")
    @Required
    public void setFormulaDAO(IFormulaDAO<BbFormula, String> formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    @Override
    protected IBaseDAO<BbFormula, String> getBaseDataAccessObject() {
        return this.formulaDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "formula.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "formula.vo2po";
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).fullEquals4TextField("forId").containingLike("name").getValue();
    }

    @Override
    public QueryResult<List<FormulaVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<FormulaVO>> result = this.formulaDAO.findPageQueryResultByQueryName("findFormulaPageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public DefaultResult<List<FormulaVO>> findForSimple(boolean trendsFlag) throws ServiceException, Exception {
        DefaultResult<List<FormulaVO>> result = new DefaultResult<List<FormulaVO>>();
        List<FormulaVO> searchList = this.formulaDAO.findForSimple(trendsFlag ? "Y" : "N");
        if (searchList != null && searchList.size() > 0) {
            result.setValue(searchList);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    public Map<String, String> findForMap(boolean pleaseSelect, boolean trendsFlag) throws ServiceException, Exception {
        Map<String, String> dataMap = this.providedSelectZeroDataMap(pleaseSelect);
        List<FormulaVO> searchList = this.formulaDAO.findForSimple(trendsFlag ? "Y" : "N");
        int i = 0;
        while (searchList != null && i < searchList.size()) {
            FormulaVO formula = searchList.get(i);
            dataMap.put(formula.getOid(), formula.getName());
            ++i;
        }
        return dataMap;
    }
}

