/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.bsc.dao.IDegreeFeedbackScoreDAO;
import com.netsteadfast.greenstep.bsc.service.IDegreeFeedbackScoreService;
import com.netsteadfast.greenstep.po.hbm.BbDegreeFeedbackScore;
import com.netsteadfast.greenstep.vo.DegreeFeedbackScoreVO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bsc.service.DegreeFeedbackScoreService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class DegreeFeedbackScoreServiceImpl
extends BaseService<DegreeFeedbackScoreVO, BbDegreeFeedbackScore, String>
implements IDegreeFeedbackScoreService<DegreeFeedbackScoreVO, BbDegreeFeedbackScore, String> {
    protected Logger logger = Logger.getLogger(DegreeFeedbackScoreServiceImpl.class);
    private IDegreeFeedbackScoreDAO<BbDegreeFeedbackScore, String> degreeFeedbackScoreDAO;

    public IDegreeFeedbackScoreDAO<BbDegreeFeedbackScore, String> getDegreeFeedbackScoreDAO() {
        return this.degreeFeedbackScoreDAO;
    }

    @Autowired
    @Resource(name="bsc.dao.DegreeFeedbackScoreDAO")
    @Required
    public void setDegreeFeedbackScoreDAO(IDegreeFeedbackScoreDAO<BbDegreeFeedbackScore, String> degreeFeedbackScoreDAO) {
        this.degreeFeedbackScoreDAO = degreeFeedbackScoreDAO;
    }

    @Override
    protected IBaseDAO<BbDegreeFeedbackScore, String> getBaseDataAccessObject() {
        return this.degreeFeedbackScoreDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "degreeFeedbackScore.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "degreeFeedbackScore.vo2po";
    }

    @Override
    public DefaultResult<List<BbDegreeFeedbackScore>> findResultsByProjectAndOwner(String projectOid, String ownerId) throws Exception {
        if (StringUtils.isBlank(projectOid) || StringUtils.isBlank(ownerId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        List<BbDegreeFeedbackScore> searchList = this.degreeFeedbackScoreDAO.findForListByProjectAndOwner(projectOid, ownerId);
        DefaultResult<List<BbDegreeFeedbackScore>> result = new DefaultResult<List<BbDegreeFeedbackScore>>();
        if (searchList != null && searchList.size() > 0) {
            result.setValue(searchList);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }
}

