/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.model;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbSysCode;
import com.netsteadfast.greenstep.service.ISysCodeService;
import com.netsteadfast.greenstep.vo.SysCodeVO;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PdcaType {
    private static ISysCodeService<SysCodeVO, TbSysCode, String> sysCodeService;
    private static Map<String, String> pdcaMap;
    public static final String CODE_TYPE = "PDCA";
    public static final String PLAN = "P";
    public static final String PLAN_CODE = "PDCA_CODE001";
    public static final String DO = "D";
    public static final String DO_CODE = "PDCA_CODE002";
    public static final String CHECK = "C";
    public static final String CHECK_CODE = "PDCA_CODE003";
    public static final String ACTION = "A";
    public static final String ACTION_CODE = "PDCA_CODE004";

    static {
        pdcaMap = new LinkedHashMap<String, String>();
        sysCodeService = (ISysCodeService)AppContext.getBean("core.service.SysCodeService");
    }

    private static void loadMapData() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", CODE_TYPE);
        HashMap<String, String> orderParams = new HashMap<String, String>();
        orderParams.put("code", "ASC");
        try {
            List codes = sysCodeService.findListByParams(params, null, orderParams);
            for (TbSysCode code : codes) {
                if (code.getCode().equals(PLAN_CODE)) {
                    pdcaMap.put(PLAN, code.getName());
                }
                if (code.getCode().equals(DO_CODE)) {
                    pdcaMap.put(DO, code.getName());
                }
                if (code.getCode().equals(CHECK_CODE)) {
                    pdcaMap.put(CHECK, code.getName());
                }
                if (!code.getCode().equals(ACTION_CODE)) continue;
                pdcaMap.put(ACTION, code.getName());
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getDataMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (pdcaMap.size() < 1) {
            PdcaType.loadMapData();
        }
        dataMap.putAll(pdcaMap);
        return dataMap;
    }
}

