/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.model;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbSysCode;
import com.netsteadfast.greenstep.service.ISysCodeService;
import com.netsteadfast.greenstep.vo.SysCodeVO;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FormulaMode {
    private static ISysCodeService<SysCodeVO, TbSysCode, String> sysCodeService;
    private static Map<String, String> returnModeMap;
    public static final String CODE_TYPE = "BFM";
    public static final String MODE_DEFAULT = "D";
    public static final String MODE_DEFAULT_CODE = "BSC_FORMD01";
    public static final String MODE_CUSTOM = "C";
    public static final String MODE_CUSTOM_CODE = "BSC_FORMD02";

    static {
        returnModeMap = new LinkedHashMap<String, String>();
        sysCodeService = (ISysCodeService)AppContext.getBean("core.service.SysCodeService");
    }

    private static void loadReturnModeMapData() {
        returnModeMap.clear();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", CODE_TYPE);
        HashMap<String, String> orderParams = new HashMap<String, String>();
        orderParams.put("code", "ASC");
        try {
            List codes = sysCodeService.findListByParams(params, null, orderParams);
            for (TbSysCode code : codes) {
                if (MODE_DEFAULT_CODE.equals(code.getCode())) {
                    returnModeMap.put(MODE_DEFAULT, code.getName());
                }
                if (!MODE_CUSTOM_CODE.equals(code.getCode())) continue;
                returnModeMap.put(MODE_CUSTOM, code.getName());
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (returnModeMap.size() != 2) {
            returnModeMap.clear();
            returnModeMap.put(MODE_DEFAULT, MODE_DEFAULT);
            returnModeMap.put(MODE_CUSTOM, MODE_CUSTOM);
        }
    }

    public static Map<String, String> getReturnModeMap(boolean pleaseSelect) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelect) {
            dataMap.put("all", " - please select - ");
        }
        if (returnModeMap.size() < 1) {
            FormulaMode.loadReturnModeMapData();
        }
        dataMap.putAll(returnModeMap);
        return dataMap;
    }
}

