/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.dao.impl;

import com.netsteadfast.greenstep.base.dao.BaseDAO;
import com.netsteadfast.greenstep.bsc.dao.IOrganizationDAO;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="bsc.dao.OrganizationDAO")
public class OrganizationDAOImpl
extends BaseDAO<BbOrganization, String>
implements IOrganizationDAO<BbOrganization, String> {
    @Override
    public List<OrganizationVO> findForJoinParent() throws Exception {
        return this.getCurrentSession().createQuery("SELECT new com.netsteadfast.greenstep.vo.OrganizationVO(m.oid, m.orgId, m.name, p.parId) FROM BbOrganization m, BbOrganizationPar p WHERE m.orgId = p.orgId ").list();
    }

    @Override
    public List<String> findForAppendNames(List<String> oids) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.name FROM BbOrganization m WHERE m.oid IN (:oids) ").setParameterList("oids", oids).list();
    }

    @Override
    public List<String> findForAppendOrganizationOids(String empId) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbOrganization m WHERE m.orgId IN ( SELECT b.orgId FROM BbEmployeeOrga b WHERE b.empId = :empId ) ").setString("empId", empId).list();
    }

    @Override
    public List<String> findForAppendOrganizationOidsByKpiOrga(String kpiId) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbOrganization m WHERE m.orgId IN ( SELECT b.orgId FROM BbKpiOrga b WHERE b.kpiId = :kpiId ) ").setString("kpiId", kpiId).list();
    }

    @Override
    public List<BbOrganization> findForInKpiOrga(String kpiId) throws Exception {
        return this.getCurrentSession().createQuery("FROM BbOrganization m WHERE m.orgId IN ( SELECT b.orgId FROM BbKpiOrga b WHERE b.kpiId = :kpiId ) ").setString("kpiId", kpiId).list();
    }

    @Override
    public List<String> findForAppendOrganizationOidsByReportRoleViewOrga(String roleId) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbOrganization m WHERE m.orgId IN ( SELECT b.idName FROM BbReportRoleView b WHERE b.role = :role and b.type = :type ) ").setString("role", roleId).setString("type", "ORG").list();
    }

    @Override
    public List<String> findForAppendOrganizationOidsByPdcaOrga(String pdcaOid) throws Exception {
        return this.getCurrentSession().createQuery("SELECT m.oid FROM BbOrganization m WHERE m.orgId IN ( SELECT b.orgId FROM BbPdcaOrga b WHERE b.pdcaOid = :pdcaOid ) ").setString("pdcaOid", pdcaOid).list();
    }
}

