/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.compoments;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.service.IWorkspaceCompomentService;
import com.netsteadfast.greenstep.compoments.BaseCompoment;
import com.netsteadfast.greenstep.compoments.CompomentsModel;
import com.netsteadfast.greenstep.po.hbm.BbWorkspaceCompoment;
import com.netsteadfast.greenstep.vo.WorkspaceCompomentVO;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseWorkspaceCompoment
extends BaseCompoment<CompomentsModel> {
    private static final long serialVersionUID = -5581734340485912925L;
    private IWorkspaceCompomentService<WorkspaceCompomentVO, BbWorkspaceCompoment, String> workspaceCompomentService = (IWorkspaceCompomentService)AppContext.getBean("bsc.service.WorkspaceCompomentService");

    public abstract String getResource();

    public abstract Map<String, Object> getParameters();

    public abstract String getBody() throws Exception;

    @Override
    public CompomentsModel loadFromId(String compomentId) throws ServiceException, Exception {
        if (StringUtils.isBlank(compomentId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        WorkspaceCompomentVO compoment = new WorkspaceCompomentVO();
        compoment.setCompId(compomentId);
        DefaultResult<WorkspaceCompomentVO> result = this.workspaceCompomentService.findByUK(compoment);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        compoment = result.getValue();
        CompomentsModel model = new CompomentsModel();
        this.setModel(model);
        model.setId(compoment.getCompId());
        model.setName(compoment.getName());
        model.setResource(this.getResource());
        model.setParameters(this.getParameters());
        model.setContent("");
        return model;
    }
}

