/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.model.BscSwotCode;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.service.IPerspectiveService;
import com.netsteadfast.greenstep.bsc.service.ISwotService;
import com.netsteadfast.greenstep.bsc.service.IVisionService;
import com.netsteadfast.greenstep.bsc.vo.SwotDataVO;
import com.netsteadfast.greenstep.bsc.vo.SwotIssuesVO;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.BbPerspective;
import com.netsteadfast.greenstep.po.hbm.BbSwot;
import com.netsteadfast.greenstep.po.hbm.BbVision;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.SwotVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;

public class SwotDataProvideCommand
extends BaseChainCommandSupport
implements Command {
    private IVisionService<VisionVO, BbVision, String> visionService = (IVisionService)AppContext.getBean("bsc.service.VisionService");
    private IOrganizationService<OrganizationVO, BbOrganization, String> organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    private ISwotService<SwotVO, BbSwot, String> swotService = (ISwotService)AppContext.getBean("bsc.service.SwotService");
    private IPerspectiveService<PerspectiveVO, BbPerspective, String> perspectiveService = (IPerspectiveService)AppContext.getBean("bsc.service.PerspectiveService");

    @Override
    public boolean execute(Context context) throws Exception {
        String visionOid = (String)context.get("visionOid");
        String organizationOid = (String)context.get("organizationOid");
        VisionVO vision = this.findVision(visionOid);
        OrganizationVO organization = this.findOrganization(organizationOid);
        if (StringUtils.isBlank(vision.getVisId()) || StringUtils.isBlank(organization.getOrgId())) {
            this.setMessage(context, SysMessageUtil.get("MSG_DOS0009"));
            return false;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> orderParams = new HashMap<String, String>();
        params.put("visId", vision.getVisId());
        orderParams.put("perId", "asc");
        List<BbPerspective> perspectives = this.perspectiveService.findListByParams(params, null, orderParams);
        if (perspectives == null || perspectives.size() < 1) {
            this.setMessage(context, SysMessageUtil.get("MSG_DOS0009"));
            return false;
        }
        params.put("orgId", organization.getOrgId());
        List<BbSwot> swots = this.swotService.findListByParams(params, null, orderParams);
        SwotDataVO swotData = new SwotDataVO();
        swotData.setVision(vision);
        swotData.setOrganization(organization);
        swotData.setContents(swots);
        swotData.setPerspectives(perspectives);
        this.initIssues(swotData, vision.getVisId(), organization.getOrgId());
        this.setResult(context, swotData);
        return false;
    }

    private void initIssues(SwotDataVO swotData, String visId, String orgId) throws Exception {
        String sep = ":";
        for (BbPerspective perspective : swotData.getPerspectives()) {
            SwotIssuesVO issues = new SwotIssuesVO();
            BbSwot sMain = null;
            BbSwot wMain = null;
            BbSwot oMain = null;
            BbSwot tMain = null;
            String sStr = "";
            String wStr = "";
            String oStr = "";
            String tStr = "";
            String sId = "BSC_PROG002D0008Q";
            String wId = "BSC_PROG002D0008Q";
            String oId = "BSC_PROG002D0008Q";
            String tId = "BSC_PROG002D0008Q";
            String[] stringArray = BscSwotCode.CODES;
            int n = BscSwotCode.CODES.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if ("S".equals(type)) {
                    sMain = this.getIssuesMain(perspective.getPerId(), type, swotData.getContents());
                    if (sMain != null) {
                        sStr = StringUtils.defaultString(sMain.getIssues());
                    }
                    sId = String.valueOf(sId) + sep + type + sep + visId + sep + perspective.getPerId() + sep + orgId;
                }
                if ("W".equals(type)) {
                    wMain = this.getIssuesMain(perspective.getPerId(), type, swotData.getContents());
                    if (wMain != null) {
                        wStr = StringUtils.defaultString(wMain.getIssues());
                    }
                    wId = String.valueOf(wId) + sep + type + sep + visId + sep + perspective.getPerId() + sep + orgId;
                }
                if ("O".equals(type)) {
                    oMain = this.getIssuesMain(perspective.getPerId(), type, swotData.getContents());
                    if (oMain != null) {
                        oStr = StringUtils.defaultString(oMain.getIssues());
                    }
                    oId = String.valueOf(oId) + sep + type + sep + visId + sep + perspective.getPerId() + sep + orgId;
                }
                if ("T".equals(type)) {
                    tMain = this.getIssuesMain(perspective.getPerId(), type, swotData.getContents());
                    if (tMain != null) {
                        tStr = StringUtils.defaultString(tMain.getIssues());
                    }
                    tId = String.valueOf(tId) + sep + type + sep + visId + sep + perspective.getPerId() + sep + orgId;
                }
                ++n2;
            }
            issues.setPerspectiveName(perspective.getName());
            issues.setStrengthsMain(sMain);
            issues.setStrengths(sStr);
            issues.setWeaknessesMain(wMain);
            issues.setWeaknesses(wStr);
            issues.setOpportunitiesMain(oMain);
            issues.setOpportunities(oStr);
            issues.setThreatsMain(tMain);
            issues.setThreats(tStr);
            issues.setStrengthsTextId(sId);
            issues.setWeaknessesTextId(wId);
            issues.setOpportunitiesTextId(oId);
            issues.setThreatsTextId(tId);
            swotData.getIssues().add(issues);
        }
    }

    private BbSwot getIssuesMain(String perId, String type, List<BbSwot> swotList) throws Exception {
        BbSwot data = null;
        for (BbSwot swot : swotList) {
            if (!swot.getPerId().equals(perId) || !swot.getType().equals(type)) continue;
            data = swot;
        }
        return data;
    }

    private VisionVO findVision(String oid) throws Exception {
        VisionVO vision = new VisionVO();
        vision.setOid(oid);
        DefaultResult<VisionVO> result = this.visionService.findObjectByOid(vision);
        if (result.getValue() == null) {
            return vision;
        }
        vision = result.getValue();
        return vision;
    }

    private OrganizationVO findOrganization(String oid) throws Exception {
        OrganizationVO organization = new OrganizationVO();
        organization.setOid(oid);
        DefaultResult<OrganizationVO> result = this.organizationService.findObjectByOid(organization);
        if (result.getValue() == null) {
            return organization;
        }
        organization = result.getValue();
        return organization;
    }
}

