/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.util.ApplicationSiteUtils;
import com.netsteadfast.greenstep.util.IconUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;

public class ProcessBscTreeItemsCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        String host = String.valueOf(StringUtils.defaultString((String)context.get("http"))) + ApplicationSiteUtils.getHost(Constants.getMainSystem()) + "/" + ApplicationSiteUtils.getContextPathFromMap(Constants.getMainSystem()) + "/";
        String iconImg = IconUtils.getMenuIcon(host, "STAR");
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        LinkedList items = new LinkedList();
        for (VisionVO vision : treeObj.getVisions()) {
            HashMap<String, Object> visionDataMap = new HashMap<String, Object>();
            visionDataMap.put("type", "parent");
            visionDataMap.put("name", vision.getTitle());
            visionDataMap.put("id", "NOT-KPI:" + vision.getOid());
            items.add(visionDataMap);
            LinkedList perspectiveItems = new LinkedList();
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                HashMap<String, Object> perspectiveDataMap = new HashMap<String, Object>();
                perspectiveDataMap.put("type", "parent");
                perspectiveDataMap.put("name", perspective.getName());
                perspectiveDataMap.put("id", "NOT-KPI:" + perspective.getOid());
                perspectiveItems.add(perspectiveDataMap);
                visionDataMap.put("children", perspectiveItems);
                LinkedList objectivesStrategyList = new LinkedList();
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    HashMap<String, Object> objectiveMap = new HashMap<String, Object>();
                    objectiveMap.put("type", "parent");
                    objectiveMap.put("name", objective.getName());
                    objectiveMap.put("id", "NOT-KPI:" + objective.getOid());
                    objectivesStrategyList.add(objectiveMap);
                    perspectiveDataMap.put("children", objectivesStrategyList);
                    LinkedList kpiList = new LinkedList();
                    for (KpiVO kpi : objective.getKpis()) {
                        HashMap<String, String> kpiMap = new HashMap<String, String>();
                        kpiMap.put("type", "Leaf");
                        kpiMap.put("name", String.valueOf(iconImg) + kpi.getName());
                        kpiMap.put("id", kpi.getOid());
                        kpiList.add(kpiMap);
                        objectiveMap.put("children", kpiList);
                    }
                }
            }
        }
        this.setResult(context, items);
        if (items == null || items.size() < 1) {
            this.setMessage(context, SysMessageUtil.get("MSG_DOS0009"));
        }
        return false;
    }
}

