/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.util.BscReportPropertyUtils;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;

public class PersonalReportBodyCommand
extends BaseChainCommandSupport
implements Command {
    private static final String templateResource = "META-INF/resource/personal-report-body.ftl";
    private IOrganizationService<OrganizationVO, BbOrganization, String> organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    private IEmployeeService<EmployeeVO, BbEmployee, String> employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");

    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        String dateType = (String)context.get("dateType");
        String empId = (String)context.get("empId");
        String account = (String)context.get("account");
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("treeObj", treeObj);
        parameter.put("dateType", dateType);
        parameter.put("year", (String)context.get("startYearDate"));
        parameter.put("fullName", " ");
        parameter.put("jobTitle", " ");
        parameter.put("departmentName", " ");
        parameter.put("employeeOid", " ");
        parameter.put("total", Float.valueOf(0.0f));
        if (context.get("total") != null && context.get("total") instanceof Float) {
            parameter.put("total", context.get("total"));
        }
        EmployeeVO employee = new EmployeeVO();
        employee.setEmpId(empId);
        employee.setAccount(account);
        DefaultResult<EmployeeVO> result = this.employeeService.findByUK(employee);
        if (result.getValue() != null) {
            parameter.put("fullName", String.valueOf(result.getValue().getEmpId()) + " - " + result.getValue().getFullName());
            parameter.put("jobTitle", result.getValue().getJobTitle());
            parameter.put("employeeOid", result.getValue().getOid());
            List<String> appendIds = this.organizationService.findForAppendOrganizationOids(result.getValue().getEmpId());
            List<String> appendNames = this.organizationService.findForAppendNames(appendIds);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (appendNames != null && i < appendNames.size()) {
                sb.append(appendNames.get(i)).append(";");
                ++i;
            }
            parameter.put("departmentName", sb.toString());
        }
        this.fillReportProperty(parameter);
        String content = TemplateUtils.processTemplate("resourceTemplate", PersonalReportBodyCommand.class.getClassLoader(), templateResource, parameter);
        this.setResult(context, content);
        return false;
    }

    private void fillReportProperty(Map<String, Object> parameter) throws ServiceException, Exception {
        BscReportPropertyUtils.loadData();
        parameter.put("objectiveTitle", BscReportPropertyUtils.getObjectiveTitle());
        parameter.put("kpiTitle", BscReportPropertyUtils.getKpiTitle());
        String classLevel = BscReportPropertyUtils.getPersonalReportClassLevel();
        classLevel = StringUtils.defaultString(classLevel);
        classLevel = classLevel.replaceAll("\n", "<BR/>");
        parameter.put("classLevel", classLevel);
    }
}

