/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.util.BscScoreColorUtils;
import com.netsteadfast.greenstep.bsc.util.PerformanceScoreChainUtils;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public class ParentItemDateRangeScoreCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscScoreColorUtils.loadScoreColors();
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        for (VisionVO vision : treeObj.getVisions()) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    this.handlerObjectiveDateRangeScore(objective);
                }
            }
        }
        for (VisionVO vision : treeObj.getVisions()) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                this.handlerPerspectiveDateRangeScore(perspective);
            }
        }
        for (VisionVO vision : treeObj.getVisions()) {
            this.handlerVisionDateRangeScore(vision);
        }
        return false;
    }

    private void handlerObjectiveDateRangeScore(ObjectiveVO objective) throws Exception {
        if (objective.getKpis() == null || objective.getKpis().size() < 1 || objective.getKpis().get(0).getDateRangeScores() == null || objective.getKpis().get(0).getDateRangeScores().size() < 1) {
            return;
        }
        for (DateRangeScoreVO dateRangeScore : objective.getKpis().get(0).getDateRangeScores()) {
            DateRangeScoreVO d = new DateRangeScoreVO();
            d.setMin(objective.getMin());
            d.setTarget(objective.getTarget());
            d.setFontColor("");
            d.setBgColor("");
            d.setScore(0.0f);
            d.setDate(dateRangeScore.getDate());
            d.setImgIcon("");
            objective.getDateRangeScores().add(d);
        }
        int i = 0;
        while (i < objective.getDateRangeScores().size()) {
            float score = 0.0f;
            DateRangeScoreVO dateRangeScore = objective.getDateRangeScores().get(i);
            for (KpiVO kpi : objective.getKpis()) {
                DateRangeScoreVO kpiDateRangeScore = kpi.getDateRangeScores().get(i);
                score += kpiDateRangeScore.getScore() * PerformanceScoreChainUtils.getWeightPercentage(kpi.getWeight());
            }
            dateRangeScore.setScore(score);
            dateRangeScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateRangeScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            ++i;
        }
    }

    private void handlerPerspectiveDateRangeScore(PerspectiveVO perspective) throws Exception {
        if (perspective.getObjectives() == null || perspective.getObjectives().size() < 1 || perspective.getObjectives().get(0).getDateRangeScores() == null || perspective.getObjectives().get(0).getDateRangeScores().size() < 1) {
            return;
        }
        for (DateRangeScoreVO dateRangeScore : perspective.getObjectives().get(0).getDateRangeScores()) {
            DateRangeScoreVO d = new DateRangeScoreVO();
            d.setMin(perspective.getMin());
            d.setTarget(perspective.getTarget());
            d.setFontColor("");
            d.setBgColor("");
            d.setScore(0.0f);
            d.setDate(dateRangeScore.getDate());
            d.setImgIcon("");
            perspective.getDateRangeScores().add(d);
        }
        int i = 0;
        while (i < perspective.getDateRangeScores().size()) {
            float score = 0.0f;
            DateRangeScoreVO dateRangeScore = perspective.getDateRangeScores().get(i);
            for (ObjectiveVO objective : perspective.getObjectives()) {
                DateRangeScoreVO objDateRangeScore = objective.getDateRangeScores().get(i);
                score += objDateRangeScore.getScore() * PerformanceScoreChainUtils.getWeightPercentage(objective.getWeight());
            }
            dateRangeScore.setScore(score);
            dateRangeScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateRangeScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            ++i;
        }
    }

    private void handlerVisionDateRangeScore(VisionVO vision) throws Exception {
        if (vision.getPerspectives() == null || vision.getPerspectives().size() < 1 || vision.getPerspectives().get(0).getDateRangeScores() == null || vision.getPerspectives().get(0).getDateRangeScores().size() < 1) {
            return;
        }
        for (DateRangeScoreVO dateRangeScore : vision.getPerspectives().get(0).getDateRangeScores()) {
            DateRangeScoreVO d = new DateRangeScoreVO();
            d.setMin(0.0f);
            d.setTarget(0.0f);
            d.setFontColor("");
            d.setBgColor("");
            d.setScore(0.0f);
            d.setDate(dateRangeScore.getDate());
            d.setImgIcon("");
            vision.getDateRangeScores().add(d);
        }
        int i = 0;
        while (i < vision.getDateRangeScores().size()) {
            float score = 0.0f;
            DateRangeScoreVO dateRangeScore = vision.getDateRangeScores().get(i);
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                DateRangeScoreVO perDateRangeScore = perspective.getDateRangeScores().get(i);
                score += perDateRangeScore.getScore() * PerformanceScoreChainUtils.getWeightPercentage(perspective.getWeight());
            }
            dateRangeScore.setScore(score);
            dateRangeScore.setBgColor(BscScoreColorUtils.getBackgroundColor(score));
            dateRangeScore.setFontColor(BscScoreColorUtils.getFontColor(score));
            ++i;
        }
    }
}

