/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapConnsService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapNodesService;
import com.netsteadfast.greenstep.bsc.service.IStrategyMapService;
import com.netsteadfast.greenstep.bsc.util.StrategyMapUtils;
import com.netsteadfast.greenstep.bsc.vo.StrategyMapItemsVO;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMap;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMapConns;
import com.netsteadfast.greenstep.po.hbm.BbStrategyMapNodes;
import com.netsteadfast.greenstep.vo.StrategyMapConnsVO;
import com.netsteadfast.greenstep.vo.StrategyMapNodesVO;
import com.netsteadfast.greenstep.vo.StrategyMapVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public class LoadStrategyMapItemsForRecCommand
extends BaseChainCommandSupport
implements Command {
    private IStrategyMapService<StrategyMapVO, BbStrategyMap, String> strategyMapService = (IStrategyMapService)AppContext.getBean("bsc.service.StrategyMapService");
    private IStrategyMapNodesService<StrategyMapNodesVO, BbStrategyMapNodes, String> strategyMapNodesService = (IStrategyMapNodesService)AppContext.getBean("bsc.service.StrategyMapNodesService");
    private IStrategyMapConnsService<StrategyMapConnsVO, BbStrategyMapConns, String> strategyMapConnsService = (IStrategyMapConnsService)AppContext.getBean("bsc.service.StrategyMapConnsService");

    @Override
    public boolean execute(Context context) throws ServiceException, Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        String visionOid = (String)context.get("visionOid");
        VisionVO vision = null;
        for (VisionVO obj : treeObj.getVisions()) {
            if (!obj.getOid().equals(visionOid)) continue;
            vision = obj;
        }
        StrategyMapItemsVO mapItems = this.fillStrategyMapItems(vision, context);
        int mapHeight = StrategyMapUtils.getMIN_HEIGHT();
        if (vision.getPerspectives().size() > 4) {
            mapHeight = StrategyMapUtils.getONE_HEIGHT() * vision.getPerspectives().size();
        }
        context.put("backgroundOid", StrategyMapUtils.createUpload(vision, 800, mapHeight));
        context.put("mapHeight", String.valueOf(mapHeight));
        this.setResult(context, mapItems);
        return false;
    }

    private StrategyMapItemsVO fillStrategyMapItems(VisionVO vision, Context context) throws ServiceException, Exception {
        StrategyMapItemsVO mapItems = new StrategyMapItemsVO();
        int w = 190;
        StrategyMapVO map = new StrategyMapVO();
        map.setVisId(vision.getVisId());
        DefaultResult<StrategyMapVO> smResult = this.strategyMapService.findByUK(map);
        if (smResult.getValue() == null) {
            this.setMessage(context, smResult.getSystemMessage().getValue());
            return mapItems;
        }
        map = smResult.getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterOid", map.getOid());
        List nodes = this.strategyMapNodesService.findListByParams(params);
        List conns = this.strategyMapConnsService.findListByParams(params);
        int i = 0;
        while (nodes != null && i < nodes.size()) {
            BbStrategyMapNodes node = (BbStrategyMapNodes)nodes.get(i);
            String div = "<div class=\"w\" id=\"" + node.getId() + "\">" + node.getText() + "<div class=\"ep\"></div></div>";
            String css = "#" + node.getId() + " { left:" + node.getPositionX() + "px; top:" + node.getPositionY() + "px; width:" + w + "px; }";
            mapItems.getDiv().add(div);
            mapItems.getCss().add(css);
            ++i;
        }
        i = 0;
        while (conns != null && i < conns.size()) {
            BbStrategyMapConns conn = (BbStrategyMapConns)conns.get(i);
            mapItems.getCon().add("{ source:\"" + conn.getSourceId() + "\", target:\"" + conn.getTargetId() + "\" }");
            ++i;
        }
        return mapItems;
    }
}

