/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.util.StrategyMapUtils;
import com.netsteadfast.greenstep.bsc.vo.StrategyMapItemsVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public class LoadStrategyMapItemsForNewCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        String visionOid = (String)context.get("visionOid");
        VisionVO vision = null;
        for (VisionVO obj : treeObj.getVisions()) {
            if (!obj.getOid().equals(visionOid)) continue;
            vision = obj;
        }
        StrategyMapItemsVO mapItems = this.fillStrategyMapItems(vision);
        int mapHeight = StrategyMapUtils.getMIN_HEIGHT();
        if (vision.getPerspectives().size() > 4) {
            mapHeight = StrategyMapUtils.getONE_HEIGHT() * vision.getPerspectives().size();
        }
        context.put("backgroundOid", StrategyMapUtils.createUpload(vision, 800, mapHeight));
        context.put("mapHeight", String.valueOf(mapHeight));
        this.setResult(context, mapItems);
        return false;
    }

    private StrategyMapItemsVO fillStrategyMapItems(VisionVO vision) throws Exception {
        StrategyMapItemsVO mapItems = new StrategyMapItemsVO();
        int w = 190;
        int top = 10;
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            int left = 10;
            for (ObjectiveVO objective : perspective.getObjectives()) {
                String idName = objective.getObjId();
                String div = "<div class=\"w\" id=\"" + idName + "\">" + objective.getName() + "<div class=\"ep\"></div></div>";
                String css = "#" + idName + " { left:" + left + "px; top:" + top + "px; width:" + w + "px; }";
                mapItems.getDiv().add(div);
                mapItems.getCss().add(css);
                left += w + 80;
            }
            top += 120;
        }
        return mapItems;
    }
}

