/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.service.logic.BscBaseLogicServiceCommonSupport;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IKpiService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.service.IPdcaAuditService;
import com.netsteadfast.greenstep.bsc.service.IPdcaDocService;
import com.netsteadfast.greenstep.bsc.service.IPdcaItemDocService;
import com.netsteadfast.greenstep.bsc.service.IPdcaItemService;
import com.netsteadfast.greenstep.bsc.service.IPdcaService;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbKpi;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.po.hbm.BbPdca;
import com.netsteadfast.greenstep.po.hbm.BbPdcaAudit;
import com.netsteadfast.greenstep.po.hbm.BbPdcaDoc;
import com.netsteadfast.greenstep.po.hbm.BbPdcaItem;
import com.netsteadfast.greenstep.po.hbm.BbPdcaItemDoc;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PdcaAuditVO;
import com.netsteadfast.greenstep.vo.PdcaDocVO;
import com.netsteadfast.greenstep.vo.PdcaItemDocVO;
import com.netsteadfast.greenstep.vo.PdcaItemVO;
import com.netsteadfast.greenstep.vo.PdcaVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LoadPdcaDataCommand
extends BaseChainCommandSupport
implements Command {
    protected Logger logger = Logger.getLogger(LoadPdcaDataCommand.class);
    private IPdcaService<PdcaVO, BbPdca, String> pdcaService;
    private IPdcaDocService<PdcaDocVO, BbPdcaDoc, String> pdcaDocService;
    private IPdcaItemService<PdcaItemVO, BbPdcaItem, String> pdcaItemService;
    private IPdcaItemDocService<PdcaItemDocVO, BbPdcaItemDoc, String> pdcaItemDocService;
    private IPdcaAuditService<PdcaAuditVO, BbPdcaAudit, String> pdcaAuditService;
    private IEmployeeService<EmployeeVO, BbEmployee, String> employeeService;
    private IOrganizationService<OrganizationVO, BbOrganization, String> organizationService;
    private IKpiService<KpiVO, BbKpi, String> kpiService;

    @Override
    public boolean execute(Context context) throws Exception {
        this.pdcaService = (IPdcaService)AppContext.getBean("bsc.service.PdcaService");
        this.pdcaDocService = (IPdcaDocService)AppContext.getBean("bsc.service.PdcaDocService");
        this.pdcaItemService = (IPdcaItemService)AppContext.getBean("bsc.service.PdcaItemService");
        this.pdcaItemDocService = (IPdcaItemDocService)AppContext.getBean("bsc.service.PdcaItemDocService");
        this.pdcaAuditService = (IPdcaAuditService)AppContext.getBean("bsc.service.PdcaAuditService");
        this.employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");
        this.organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
        this.kpiService = (IKpiService)AppContext.getBean("bsc.service.KpiService");
        String pdcaOid = (String)context.get("pdcaOid");
        PdcaVO pdca = new PdcaVO();
        pdca.setOid(pdcaOid);
        DefaultResult<PdcaVO> result = this.pdcaService.findObjectByOid(pdca);
        if (result.getValue() == null) {
            this.setMessage(context, result.getSystemMessage().getValue());
        } else {
            pdca = result.getValue();
            this.loadDetail(pdca);
            this.loadPdcaItems(pdca);
            this.loadAudit(pdca);
            this.setResult(context, pdca);
            context.put("pdca", pdca);
        }
        return false;
    }

    private void loadDetail(PdcaVO pdca) throws ServiceException, Exception {
        List pdcaDocs;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List<String> ownerNames = this.employeeService.findForAppendNames(this.employeeService.findForAppendEmployeeOidsByPdcaOwner(pdca.getOid()));
        pdca.setResponsibilityAppendNames(String.valueOf(StringUtils.join(ownerNames.toArray(), ";")) + ";");
        if (!StringUtils.isBlank(pdca.getConfirmEmpId())) {
            pdca.setConfirmEmployeeName(this.getEmployeeNameNoThrow(pdca.getConfirmEmpId()));
        }
        List<String> orgaNames = this.organizationService.findForAppendNames(this.organizationService.findForAppendOrganizationOidsByPdcaOrga(pdca.getOid()));
        pdca.setOrganizationAppendNames(String.valueOf(StringUtils.join(orgaNames.toArray(), ";")) + ";");
        List<String> kpiNames = this.kpiService.findForAppendNames(this.kpiService.findForAppendOidsByPdcaKpis(pdca.getOid()));
        pdca.setKpisAppendNames(String.valueOf(StringUtils.join(kpiNames.toArray(), ";")) + ";");
        if (!StringUtils.isBlank(pdca.getParentOid())) {
            PdcaVO parentPdca = new PdcaVO();
            parentPdca.setOid(pdca.getParentOid());
            DefaultResult<PdcaVO> pResult = this.pdcaService.findObjectByOid(parentPdca);
            if (pResult.getValue() == null) {
                throw new ServiceException(pResult.getSystemMessage().getValue());
            }
            pdca.setParentName(pResult.getValue().getTitle());
        }
        if ((pdcaDocs = this.pdcaDocService.findListVOByParams(paramMap)) != null && pdcaDocs.size() > 0) {
            pdca.getDocs().addAll(pdcaDocs);
        }
        int i = 0;
        while (pdca.getDocs() != null && i < pdca.getDocs().size()) {
            PdcaDocVO doc = pdca.getDocs().get(i);
            doc.setShowName(UploadSupportUtils.findUploadNoByteContent(doc.getUploadOid()).getShowName());
            ++i;
        }
    }

    private void loadPdcaItems(PdcaVO pdca) throws ServiceException, Exception {
        pdca.setItemPlan(new ArrayList<PdcaItemVO>());
        pdca.setItemDo(new ArrayList<PdcaItemVO>());
        pdca.setItemCheck(new ArrayList<PdcaItemVO>());
        pdca.setItemAction(new ArrayList<PdcaItemVO>());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pdcaOid", pdca.getOid());
        List pdcaItems = this.pdcaItemService.findListByParams(paramMap);
        for (BbPdcaItem pdcaItem : pdcaItems) {
            PdcaItemVO item = new PdcaItemVO();
            this.pdcaItemService.doMapper(pdcaItem, item, "pdcaItem.po2vo");
            List<String> ownerNames = this.employeeService.findForAppendNames(this.employeeService.findForAppendEmployeeOidsByPdcaItemOwner(item.getPdcaOid(), item.getOid()));
            item.setEmployeeAppendNames(String.valueOf(StringUtils.join(ownerNames.toArray(), ";")) + ";");
            paramMap.put("itemOid", item.getOid());
            List itemDocs = this.pdcaItemDocService.findListVOByParams(paramMap);
            if (itemDocs != null && itemDocs.size() > 0) {
                item.getDocs().addAll(itemDocs);
            }
            int i = 0;
            while (item.getDocs() != null && i < item.getDocs().size()) {
                PdcaItemDocVO doc = item.getDocs().get(i);
                doc.setShowName(UploadSupportUtils.findUploadNoByteContent(doc.getUploadOid()).getShowName());
                ++i;
            }
            if ("P".equals(item.getType())) {
                pdca.getItemPlan().add(item);
                continue;
            }
            if ("D".equals(item.getType())) {
                pdca.getItemDo().add(item);
                continue;
            }
            if ("C".equals(item.getType())) {
                pdca.getItemCheck().add(item);
                continue;
            }
            pdca.getItemAction().add(item);
        }
    }

    private void loadAudit(PdcaVO pdca) throws ServiceException, Exception {
        pdca.setAuditPlan(this.findMaxConfirmSeqPdcaAuditData(pdca, "P"));
        pdca.setAuditDo(this.findMaxConfirmSeqPdcaAuditData(pdca, "D"));
        pdca.setAuditCheck(this.findMaxConfirmSeqPdcaAuditData(pdca, "C"));
        pdca.setAuditAction(this.findMaxConfirmSeqPdcaAuditData(pdca, "A"));
        if (pdca.getAuditPlan() != null) {
            pdca.getAuditPlan().setEmpId(this.getEmployeeNameNoThrow(pdca.getAuditPlan().getEmpId()));
        }
        if (pdca.getAuditDo() != null) {
            pdca.getAuditDo().setEmpId(this.getEmployeeNameNoThrow(pdca.getAuditDo().getEmpId()));
        }
        if (pdca.getAuditCheck() != null) {
            pdca.getAuditCheck().setEmpId(this.getEmployeeNameNoThrow(pdca.getAuditCheck().getEmpId()));
        }
        if (pdca.getAuditAction() != null) {
            pdca.getAuditAction().setEmpId(this.getEmployeeNameNoThrow(pdca.getAuditAction().getEmpId()));
        }
    }

    private PdcaAuditVO findMaxConfirmSeqPdcaAuditData(PdcaVO pdca, String type) throws ServiceException, Exception {
        BbPdcaAudit pdcaAudit = this.pdcaAuditService.findForLast(pdca.getOid(), type);
        if (pdcaAudit == null) {
            return null;
        }
        PdcaAuditVO audit = new PdcaAuditVO();
        this.pdcaAuditService.doMapper(pdcaAudit, audit, "pdcaAudit.po2vo");
        return audit;
    }

    private String getEmployeeNameNoThrow(String empId) {
        String name = "";
        try {
            EmployeeVO employee = BscBaseLogicServiceCommonSupport.findEmployeeDataByEmpId(this.employeeService, empId);
            name = employee.getFullName();
        }
        catch (Exception e) {
            this.logger.warn("No find employee: " + empId);
        }
        if (StringUtils.isBlank(name)) {
            return empId;
        }
        return name;
    }
}

