/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.util.BscReportPropertyUtils;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class KpisDashboardExcelCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        String uploadOid = this.createExcel(context);
        this.setResult(context, uploadOid);
        return false;
    }

    private String createExcel(Context context) throws Exception {
        String fileName = String.valueOf(SimpleUtils.getUUIDStr()) + ".xlsx";
        String fileFullPath = String.valueOf(Constants.getWorkTmpDir()) + "/" + fileName;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sh = wb.createSheet();
        BscReportPropertyUtils.loadData();
        int row = this.putDateRange(wb, sh, context);
        this.putCharts(wb, sh, context, row);
        FileOutputStream out = new FileOutputStream(fileFullPath);
        wb.write(out);
        out.close();
        wb = null;
        File file = new File(fileFullPath);
        String oid = UploadSupportUtils.create(Constants.getSystem(), "tmp", false, file, "kpis-dashboard.xlsx");
        file = null;
        return oid;
    }

    private int putDateRange(XSSFWorkbook wb, XSSFSheet sh, Context context) throws Exception {
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        VisionVO vision = treeObj.getVisions().get(0);
        XSSFCellStyle cellHeadStyle = wb.createCellStyle();
        cellHeadStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(BscReportPropertyUtils.getBackgroundColor()), null));
        cellHeadStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellHeadStyle.setBorderBottom(BorderStyle.THIN);
        cellHeadStyle.setBorderTop(BorderStyle.THIN);
        cellHeadStyle.setBorderRight(BorderStyle.THIN);
        cellHeadStyle.setBorderLeft(BorderStyle.THIN);
        XSSFFont cellHeadFont = wb.createFont();
        cellHeadFont.setBold(true);
        cellHeadFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(BscReportPropertyUtils.getFontColor()), null));
        cellHeadStyle.setFont(cellHeadFont);
        sh.setColumnWidth(0, 12000);
        int drSize = vision.getPerspectives().get(0).getObjectives().get(0).getKpis().get(0).getDateRangeScores().size();
        int dCol = 5;
        int left = 0;
        int row = 0;
        XSSFRow nowRow = sh.createRow(row);
        int i = 0;
        while (i < dCol + drSize) {
            Cell cell1 = nowRow.createCell(i);
            cell1.setCellStyle(cellHeadStyle);
            cell1.setCellValue(vision.getTitle());
            ++i;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, dCol + drSize - 1));
        int n = ++row;
        ++row;
        nowRow = sh.createRow(n);
        Cell cell1 = nowRow.createCell(0);
        cell1.setCellStyle(cellHeadStyle);
        cell1.setCellValue(BscReportPropertyUtils.getKpiTitle());
        Cell cell2 = nowRow.createCell(1);
        cell2.setCellStyle(cellHeadStyle);
        cell2.setCellValue("Maximum");
        Cell cell3 = nowRow.createCell(2);
        cell3.setCellStyle(cellHeadStyle);
        cell3.setCellValue("Target");
        Cell cell4 = nowRow.createCell(3);
        cell4.setCellStyle(cellHeadStyle);
        cell4.setCellValue("Minimum");
        Cell cell5 = nowRow.createCell(4);
        cell5.setCellStyle(cellHeadStyle);
        cell5.setCellValue("Score");
        for (DateRangeScoreVO dateRangeScore : vision.getPerspectives().get(0).getObjectives().get(0).getKpis().get(0).getDateRangeScores()) {
            Cell cell = nowRow.createCell(dCol + left);
            cell.setCellStyle(cellHeadStyle);
            cell.setCellValue(dateRangeScore.getDate());
            ++left;
        }
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor("#ffffff"), null));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        XSSFFont cellFont = wb.createFont();
        cellFont.setBold(false);
        cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor("#000000"), null));
        cellStyle.setFont(cellFont);
        int p = 0;
        while (p < vision.getPerspectives().size()) {
            PerspectiveVO perspective = vision.getPerspectives().get(p);
            int o = 0;
            while (o < perspective.getObjectives().size()) {
                ObjectiveVO objective = perspective.getObjectives().get(o);
                int k = 0;
                while (k < objective.getKpis().size()) {
                    left = 0;
                    KpiVO kpi = objective.getKpis().get(k);
                    nowRow = sh.createRow(row++);
                    cell1 = nowRow.createCell(0);
                    cell1.setCellStyle(cellStyle);
                    cell1.setCellValue(kpi.getName());
                    cell2 = nowRow.createCell(1);
                    cell2.setCellStyle(cellStyle);
                    cell2.setCellValue(kpi.getMax());
                    cell3 = nowRow.createCell(2);
                    cell3.setCellStyle(cellStyle);
                    cell3.setCellValue(kpi.getTarget());
                    cell4 = nowRow.createCell(3);
                    cell4.setCellStyle(cellStyle);
                    cell4.setCellValue(kpi.getMin());
                    cell5 = nowRow.createCell(4);
                    XSSFCellStyle s_cellStyle = wb.createCellStyle();
                    s_cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(kpi.getBgColor()), null));
                    s_cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    s_cellStyle.setBorderBottom(BorderStyle.THIN);
                    s_cellStyle.setBorderTop(BorderStyle.THIN);
                    s_cellStyle.setBorderRight(BorderStyle.THIN);
                    s_cellStyle.setBorderLeft(BorderStyle.THIN);
                    XSSFFont s_cellFont = wb.createFont();
                    s_cellFont.setBold(false);
                    s_cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(kpi.getFontColor()), null));
                    s_cellStyle.setFont(s_cellFont);
                    cell5.setCellStyle(s_cellStyle);
                    cell5.setCellValue(BscReportSupportUtils.parse2(kpi.getScore()));
                    for (DateRangeScoreVO dateRangeScore : kpi.getDateRangeScores()) {
                        XSSFCellStyle drs_cellStyle = wb.createCellStyle();
                        drs_cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                        drs_cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        drs_cellStyle.setBorderBottom(BorderStyle.THIN);
                        drs_cellStyle.setBorderTop(BorderStyle.THIN);
                        drs_cellStyle.setBorderRight(BorderStyle.THIN);
                        drs_cellStyle.setBorderLeft(BorderStyle.THIN);
                        XSSFFont drs_cellFont = wb.createFont();
                        drs_cellFont.setBold(false);
                        drs_cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                        drs_cellStyle.setFont(drs_cellFont);
                        Cell cell = nowRow.createCell(dCol + left);
                        cell.setCellStyle(drs_cellStyle);
                        cell.setCellValue(BscReportSupportUtils.parse2(dateRangeScore.getScore()));
                        ++left;
                    }
                    ++k;
                }
                ++o;
            }
            ++p;
        }
        String frequency = (String)context.get("frequency");
        String footContent = "";
        footContent = String.valueOf(footContent) + "Frequency : " + BscMeasureDataFrequency.getFrequencyMap(false).get(frequency) + "  ";
        footContent = String.valueOf(footContent) + "date range : ";
        footContent = !"2".equals(frequency) && !"3".equals(frequency) ? String.valueOf(footContent) + context.get("startYearDate") + " ~ " + context.get("endYearDate") : String.valueOf(footContent) + context.get("startDate") + " ~ " + context.get("endDate");
        String dataType = "";
        if (!StringUtils.isBlank((String)context.get("organizationName"))) {
            dataType = (String)context.get("organizationName");
        }
        if (!StringUtils.isBlank((String)context.get("employeeName"))) {
            dataType = (String)context.get("employeeName");
        }
        if (StringUtils.isBlank(dataType)) {
            dataType = "All";
        }
        footContent = String.valueOf(footContent) + "  Measure data type : " + dataType;
        nowRow = sh.createRow(row);
        int i2 = 0;
        while (i2 < dCol + drSize) {
            Cell cell = nowRow.createCell(0);
            cell.setCellStyle(cellHeadStyle);
            cell.setCellValue(footContent);
            ++i2;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, dCol + drSize - 1));
        return ++row;
    }

    private int putCharts(XSSFWorkbook wb, XSSFSheet sh, Context context, int row) throws Exception {
        int chart_need_row_size = 12;
        ++row;
        int c = 0;
        Map gaugeDatas = (Map)context.get("gaugeDatas");
        List gaugeMapList = (List)gaugeDatas.get("gaugeMapList");
        int i = 0;
        while (i < gaugeMapList.size()) {
            if (c > 1) {
                c = 0;
            }
            if (i > 0 && i % 2 == 0) {
                row += chart_need_row_size;
            }
            Map gaugeMap = (Map)gaugeMapList.get(i);
            String imageDataStr = SimpleUtils.getPNGBase64Content((String)gaugeMap.get("data"));
            BufferedImage image = SimpleUtils.decodeToImage(imageDataStr);
            ByteArrayOutputStream imgBos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", imgBos);
            imgBos.flush();
            SimpleUtils.setCellPicture(wb, sh, imgBos.toByteArray(), row, c++);
            ++i;
        }
        row += chart_need_row_size;
        String dateRangeChartPngData = (String)context.get("dateRangeChartPngData");
        if (StringUtils.isBlank(dateRangeChartPngData)) {
            return row;
        }
        String imageDataStr = SimpleUtils.getPNGBase64Content(dateRangeChartPngData);
        BufferedImage image = SimpleUtils.decodeToImage(imageDataStr);
        ByteArrayOutputStream imgBos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", imgBos);
        imgBos.flush();
        SimpleUtils.setCellPicture(wb, sh, imgBos.toByteArray(), row, 0);
        return row;
    }
}

