/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.BaseValueObj;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.model.BscKpiCode;
import com.netsteadfast.greenstep.bsc.model.BscMeasureDataFrequency;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.bsc.util.AggregationMethodUtils;
import com.netsteadfast.greenstep.bsc.util.BscReportPropertyUtils;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.DateRangeScoreVO;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class KpiReportExcelCommand
extends BaseChainCommandSupport
implements Command {
    private IOrganizationService<OrganizationVO, BbOrganization, String> organizationService = (IOrganizationService)AppContext.getBean("bsc.service.OrganizationService");
    private IEmployeeService<EmployeeVO, BbEmployee, String> employeeService = (IEmployeeService)AppContext.getBean("bsc.service.EmployeeService");

    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        String uploadOid = this.createExcel(context);
        this.setResult(context, uploadOid);
        return false;
    }

    private String createExcel(Context context) throws Exception {
        String visionOid = (String)context.get("visionOid");
        VisionVO vision = null;
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        for (VisionVO visionObj : treeObj.getVisions()) {
            if (!visionObj.getOid().equals(visionOid)) continue;
            vision = visionObj;
        }
        BscReportPropertyUtils.loadData();
        BscReportSupportUtils.loadExpression();
        String fileName = String.valueOf(SimpleUtils.getUUIDStr()) + ".xlsx";
        String fileFullPath = String.valueOf(Constants.getWorkTmpDir()) + "/" + fileName;
        int row = 24;
        if (context.get("pieCanvasToData") == null || context.get("barCanvasToData") == null) {
            row = 0;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sh = wb.createSheet();
        row += this.createHead(wb, sh, row, vision);
        row = this.createMainBody(wb, sh, row, vision);
        ++row;
        row = this.createDateRange(wb, sh, row, vision, context);
        if (context.get("pieCanvasToData") != null && context.get("barCanvasToData") != null) {
            this.putCharts(wb, sh, context);
        }
        this.putSignature(wb, sh, row + 1, context);
        FileOutputStream out = new FileOutputStream(fileFullPath);
        wb.write(out);
        out.close();
        wb = null;
        File file = new File(fileFullPath);
        String oid = UploadSupportUtils.create(Constants.getSystem(), "tmp", false, file, "kpi-report.xlsx");
        file = null;
        return oid;
    }

    private int putCharts(XSSFWorkbook wb, XSSFSheet sh, Context context) throws Exception {
        String pieBase64Content = SimpleUtils.getPNGBase64Content((String)context.get("pieCanvasToData"));
        String barBase64Content = SimpleUtils.getPNGBase64Content((String)context.get("barCanvasToData"));
        BufferedImage pieImage = SimpleUtils.decodeToImage(pieBase64Content);
        BufferedImage barImage = SimpleUtils.decodeToImage(barBase64Content);
        ByteArrayOutputStream pieBos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)pieImage, "png", pieBos);
        pieBos.flush();
        ByteArrayOutputStream barBos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)barImage, "png", barBos);
        barBos.flush();
        SimpleUtils.setCellPicture(wb, sh, pieBos.toByteArray(), 0, 0);
        SimpleUtils.setCellPicture(wb, sh, barBos.toByteArray(), 0, 6);
        return 25;
    }

    private void putSignature(XSSFWorkbook wb, XSSFSheet sh, int row, Context context) throws Exception {
        String uploadOid = (String)context.get("uploadSignatureOid");
        if (StringUtils.isBlank(uploadOid)) {
            return;
        }
        byte[] imageBytes = UploadSupportUtils.getDataBytes(uploadOid);
        if (imageBytes == null) {
            return;
        }
        SimpleUtils.setCellPicture(wb, sh, imageBytes, row, 0);
    }

    private int createHead(XSSFWorkbook wb, XSSFSheet sh, int row, VisionVO vision) throws Exception {
        Cell headCell1;
        XSSFRow headRow = sh.createRow(row);
        headRow.setHeight((short)700);
        int cell = 0;
        XSSFColor bgColor = new XSSFColor(SimpleUtils.getColorRGB4POIColor(vision.getBgColor()), null);
        XSSFColor fnColor = new XSSFColor(SimpleUtils.getColorRGB4POIColor(vision.getFontColor()), null);
        XSSFCellStyle cellHeadStyle = wb.createCellStyle();
        cellHeadStyle.setFillForegroundColor(bgColor);
        cellHeadStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont cellHeadFont = wb.createFont();
        cellHeadFont.setBold(true);
        cellHeadFont.setColor(fnColor);
        cellHeadStyle.setFont(cellHeadFont);
        cellHeadStyle.setBorderBottom(BorderStyle.THIN);
        cellHeadStyle.setBorderTop(BorderStyle.THIN);
        cellHeadStyle.setBorderRight(BorderStyle.THIN);
        cellHeadStyle.setBorderLeft(BorderStyle.THIN);
        cellHeadStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellHeadStyle.setAlignment(HorizontalAlignment.CENTER);
        cellHeadStyle.setWrapText(true);
        int cols = 12;
        int i = 0;
        while (i < cols) {
            sh.setColumnWidth(i, 4000);
            Cell headCell12 = headRow.createCell(cell++);
            headCell12.setCellValue(String.valueOf(vision.getTitle()) + "\nscore: " + BscReportSupportUtils.parse2(vision.getScore()));
            headCell12.setCellStyle(cellHeadStyle);
            ++i;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, cols - 1));
        bgColor = new XSSFColor(SimpleUtils.getColorRGB4POIColor(BscReportPropertyUtils.getBackgroundColor()), null);
        fnColor = new XSSFColor(SimpleUtils.getColorRGB4POIColor(BscReportPropertyUtils.getFontColor()), null);
        cellHeadStyle = wb.createCellStyle();
        cellHeadStyle.setFillForegroundColor(bgColor);
        cellHeadStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellHeadFont = wb.createFont();
        cellHeadFont.setBold(true);
        cellHeadFont.setColor(fnColor);
        cellHeadStyle.setFont(cellHeadFont);
        cellHeadStyle.setBorderBottom(BorderStyle.THIN);
        cellHeadStyle.setBorderTop(BorderStyle.THIN);
        cellHeadStyle.setBorderRight(BorderStyle.THIN);
        cellHeadStyle.setBorderLeft(BorderStyle.THIN);
        cellHeadStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellHeadStyle.setAlignment(HorizontalAlignment.CENTER);
        cellHeadStyle.setWrapText(true);
        headRow = sh.createRow(++row);
        cell = 0;
        int titleCols = 4;
        int i2 = 0;
        while (i2 < titleCols) {
            headCell1 = headRow.createCell(cell++);
            headCell1.setCellValue(BscReportPropertyUtils.getPerspectiveTitle());
            headCell1.setCellStyle(cellHeadStyle);
            ++i2;
        }
        i2 = 0;
        while (i2 < titleCols) {
            headCell1 = headRow.createCell(cell++);
            headCell1.setCellValue(BscReportPropertyUtils.getObjectiveTitle());
            headCell1.setCellStyle(cellHeadStyle);
            ++i2;
        }
        i2 = 0;
        while (i2 < titleCols) {
            headCell1 = headRow.createCell(cell++);
            headCell1.setCellValue(BscReportPropertyUtils.getKpiTitle());
            headCell1.setCellStyle(cellHeadStyle);
            ++i2;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, 3));
        sh.addMergedRegion(new CellRangeAddress(row, row, 4, 7));
        sh.addMergedRegion(new CellRangeAddress(row, row, 8, 11));
        return 2;
    }

    private int createMainBody(XSSFWorkbook wb, XSSFSheet sh, int row, VisionVO vision) throws Exception {
        int kx;
        ObjectiveVO objective;
        int ox;
        PerspectiveVO perspective;
        Map<String, String> managementMap = BscKpiCode.getManagementMap(false);
        int itemCols = 4;
        int mrRow = row;
        int px = 0;
        while (px < vision.getPerspectives().size()) {
            perspective = vision.getPerspectives().get(px);
            ox = 0;
            while (ox < perspective.getObjectives().size()) {
                objective = perspective.getObjectives().get(ox);
                kx = 0;
                while (kx < objective.getKpis().size()) {
                    byte[] imgBytes;
                    Cell contentCell1;
                    XSSFFont cellFont;
                    XSSFCellStyle cellStyle;
                    String content;
                    KpiVO kpi = objective.getKpis().get(kx);
                    XSSFRow contentRow = sh.createRow(row++);
                    contentRow.setHeight((short)4000);
                    int cell = 0;
                    int i = 0;
                    while (i < itemCols) {
                        content = this.getItemsContent(perspective.getName(), perspective.getScore(), perspective.getWeight(), perspective.getTarget(), perspective.getMin());
                        cellStyle = wb.createCellStyle();
                        cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(perspective.getBgColor()), null));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cellFont = wb.createFont();
                        cellFont.setBold(false);
                        cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(perspective.getFontColor()), null));
                        cellStyle.setFont(cellFont);
                        cellStyle.setWrapText(true);
                        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                        contentCell1 = contentRow.createCell(cell++);
                        contentCell1.setCellValue("\n" + content);
                        contentCell1.setCellStyle(cellStyle);
                        if (i == 0 && ox == 0 && (imgBytes = BscReportSupportUtils.getByteIconBase("PERSPECTIVES", perspective.getTarget(), perspective.getMin(), perspective.getScore(), "", "", 0.0f)) != null) {
                            SimpleUtils.setCellPicture(wb, sh, imgBytes, contentCell1.getRowIndex(), contentCell1.getColumnIndex());
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < itemCols) {
                        content = this.getItemsContent(objective.getName(), objective.getScore(), objective.getWeight(), objective.getTarget(), objective.getMin());
                        cellStyle = wb.createCellStyle();
                        cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(objective.getBgColor()), null));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cellFont = wb.createFont();
                        cellFont.setBold(false);
                        cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(objective.getFontColor()), null));
                        cellStyle.setFont(cellFont);
                        cellStyle.setWrapText(true);
                        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                        contentCell1 = contentRow.createCell(cell++);
                        contentCell1.setCellValue("\n" + content);
                        contentCell1.setCellStyle(cellStyle);
                        if (i == 0 && kx == 0 && (imgBytes = BscReportSupportUtils.getByteIconBase("OBJECTIVES", objective.getTarget(), objective.getMin(), objective.getScore(), "", "", 0.0f)) != null) {
                            SimpleUtils.setCellPicture(wb, sh, imgBytes, contentCell1.getRowIndex(), contentCell1.getColumnIndex());
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < itemCols) {
                        content = this.getKpisContent(kpi, managementMap);
                        cellStyle = wb.createCellStyle();
                        cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(kpi.getBgColor()), null));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cellFont = wb.createFont();
                        cellFont.setBold(false);
                        cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(kpi.getFontColor()), null));
                        cellStyle.setFont(cellFont);
                        cellStyle.setWrapText(true);
                        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                        contentCell1 = contentRow.createCell(cell++);
                        contentCell1.setCellValue("\n" + content);
                        contentCell1.setCellStyle(cellStyle);
                        if (i == 0 && (imgBytes = BscReportSupportUtils.getByteIconBase("KPI", kpi.getTarget(), kpi.getMin(), kpi.getScore(), kpi.getCompareType(), kpi.getManagement(), kpi.getQuasiRange())) != null) {
                            SimpleUtils.setCellPicture(wb, sh, imgBytes, contentCell1.getRowIndex(), contentCell1.getColumnIndex());
                        }
                        ++i;
                    }
                    ++kx;
                }
                ++ox;
            }
            ++px;
        }
        px = 0;
        while (px < vision.getPerspectives().size()) {
            perspective = vision.getPerspectives().get(px);
            sh.addMergedRegion(new CellRangeAddress(mrRow, mrRow + perspective.getRow() - 1, 0, 3));
            ox = 0;
            while (ox < perspective.getObjectives().size()) {
                objective = perspective.getObjectives().get(ox);
                sh.addMergedRegion(new CellRangeAddress(mrRow, mrRow + objective.getRow() - 1, 4, 7));
                kx = 0;
                while (kx < objective.getKpis().size()) {
                    sh.addMergedRegion(new CellRangeAddress(mrRow + kx, mrRow + kx, 8, 11));
                    ++kx;
                }
                mrRow += objective.getKpis().size();
                ++ox;
            }
            ++px;
        }
        return row++;
    }

    private int createDateRange(XSSFWorkbook wb, XSSFSheet sh, int row, VisionVO vision, Context context) throws Exception {
        Object headCell1;
        String frequency = (String)context.get("frequency");
        String startYearDate = StringUtils.defaultString((String)context.get("startYearDate")).trim();
        String endYearDate = StringUtils.defaultString((String)context.get("endYearDate")).trim();
        String startDate = StringUtils.defaultString((String)context.get("startDate")).trim();
        String endDate = StringUtils.defaultString((String)context.get("endDate")).trim();
        String date1 = startDate;
        String date2 = endDate;
        if ("4".equals(frequency) || "5".equals(frequency) || "6".equals(frequency)) {
            date1 = String.valueOf(startYearDate) + "/01/01";
            date2 = String.valueOf(endYearDate) + "/12/" + SimpleUtils.getMaxDayOfMonth(Integer.parseInt(endYearDate), 12);
        }
        HashMap<String, Object> headContentMap = new HashMap<String, Object>();
        this.fillHeadContent(context, headContentMap);
        XSSFCellStyle cellStyleLabel = wb.createCellStyle();
        cellStyleLabel.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(BscReportPropertyUtils.getBackgroundColor()), null));
        cellStyleLabel.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont cellFontLabel = wb.createFont();
        cellFontLabel.setBold(false);
        cellFontLabel.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(BscReportPropertyUtils.getFontColor()), null));
        cellStyleLabel.setFont(cellFontLabel);
        cellStyleLabel.setWrapText(true);
        cellStyleLabel.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyleLabel.setBorderBottom(BorderStyle.THIN);
        cellStyleLabel.setBorderTop(BorderStyle.THIN);
        cellStyleLabel.setBorderRight(BorderStyle.THIN);
        cellStyleLabel.setBorderLeft(BorderStyle.THIN);
        int cols = 4 + vision.getPerspectives().get(0).getObjectives().get(0).getKpis().get(0).getDateRangeScores().size();
        int cell = 0;
        XSSFRow headRow = sh.createRow(row);
        headRow.setHeight((short)700);
        int i = 0;
        while (i < cols) {
            String content = "Frequency: " + BscMeasureDataFrequency.getFrequencyMap(false).get(frequency) + " Date range: " + date1 + " ~ " + date2 + "\n" + StringUtils.defaultString((String)headContentMap.get("headContent"));
            Cell headCell12 = headRow.createCell(cell++);
            headCell12.setCellValue(content);
            headCell12.setCellStyle(cellStyleLabel);
            ++i;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, cols - 1));
        int drCols = 4;
        int drRows = 2;
        cell = 0;
        headRow = sh.createRow(++row);
        headRow.setHeight((short)700);
        int i2 = 0;
        while (i2 < cols) {
            headCell1 = headRow.createCell(cell++);
            headCell1.setCellValue("Vision date range score");
            headCell1.setCellStyle(cellStyleLabel);
            ++i2;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, cols - 1));
        ++row;
        int r = 0;
        while (r < drRows) {
            Cell contentCell1;
            XSSFFont cellFont;
            XSSFCellStyle cellStyle;
            DateRangeScoreVO dateRangeScore;
            int d;
            XSSFRow contentRow = sh.createRow(row++);
            contentRow.setHeight((short)400);
            int c = 0;
            while (c < drCols) {
                XSSFCellStyle cellStyle2 = wb.createCellStyle();
                cellStyle2.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(vision.getBgColor()), null));
                cellStyle2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                XSSFFont cellFont2 = wb.createFont();
                cellFont2.setBold(false);
                cellFont2.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(vision.getFontColor()), null));
                cellStyle2.setFont(cellFont2);
                cellStyle2.setWrapText(true);
                cellStyle2.setVerticalAlignment(VerticalAlignment.CENTER);
                cellStyle2.setBorderBottom(BorderStyle.THIN);
                cellStyle2.setBorderTop(BorderStyle.THIN);
                cellStyle2.setBorderRight(BorderStyle.THIN);
                cellStyle2.setBorderLeft(BorderStyle.THIN);
                Cell contentCell12 = contentRow.createCell(c);
                contentCell12.setCellValue(vision.getTitle());
                contentCell12.setCellStyle(cellStyle2);
                ++c;
            }
            cell = 4;
            if (r == 0) {
                d = 0;
                while (d < vision.getDateRangeScores().size()) {
                    dateRangeScore = vision.getDateRangeScores().get(d);
                    cellStyle = wb.createCellStyle();
                    cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellFont = wb.createFont();
                    cellFont.setBold(false);
                    cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                    cellStyle.setFont(cellFont);
                    cellStyle.setWrapText(true);
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    contentCell1 = contentRow.createCell(cell++);
                    contentCell1.setCellValue(dateRangeScore.getDate());
                    contentCell1.setCellStyle(cellStyle);
                    ++d;
                }
            }
            if (r == 1) {
                d = 0;
                while (d < vision.getDateRangeScores().size()) {
                    dateRangeScore = vision.getDateRangeScores().get(d);
                    cellStyle = wb.createCellStyle();
                    cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellFont = wb.createFont();
                    cellFont.setBold(false);
                    cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                    cellStyle.setFont(cellFont);
                    cellStyle.setWrapText(true);
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    contentCell1 = contentRow.createCell(cell++);
                    contentCell1.setCellValue("      " + BscReportSupportUtils.parse2(dateRangeScore.getScore()));
                    contentCell1.setCellStyle(cellStyle);
                    ++d;
                }
            }
            ++r;
        }
        sh.addMergedRegion(new CellRangeAddress(row - 2, row - 1, 0, drCols - 1));
        cell = 0;
        headRow = sh.createRow(row);
        headRow.setHeight((short)700);
        i2 = 0;
        while (i2 < cols) {
            headCell1 = headRow.createCell(cell++);
            headCell1.setCellValue(String.valueOf(BscReportPropertyUtils.getPerspectiveTitle()) + " date range score");
            headCell1.setCellStyle(cellStyleLabel);
            ++i2;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, cols - 1));
        ++row;
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            cell = 0;
            int r2 = 0;
            while (r2 < drRows) {
                Cell contentCell1;
                XSSFFont cellFont;
                XSSFCellStyle cellStyle;
                DateRangeScoreVO dateRangeScore;
                int d;
                XSSFRow contentRow = sh.createRow(row++);
                contentRow.setHeight((short)400);
                int c = 0;
                while (c < drCols) {
                    XSSFCellStyle cellStyle3 = wb.createCellStyle();
                    cellStyle3.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(perspective.getBgColor()), null));
                    cellStyle3.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    XSSFFont cellFont3 = wb.createFont();
                    cellFont3.setBold(false);
                    cellFont3.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(perspective.getFontColor()), null));
                    cellStyle3.setFont(cellFont3);
                    cellStyle3.setWrapText(true);
                    cellStyle3.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle3.setBorderBottom(BorderStyle.THIN);
                    cellStyle3.setBorderTop(BorderStyle.THIN);
                    cellStyle3.setBorderRight(BorderStyle.THIN);
                    cellStyle3.setBorderLeft(BorderStyle.THIN);
                    Cell contentCell13 = contentRow.createCell(c);
                    contentCell13.setCellValue(perspective.getName());
                    contentCell13.setCellStyle(cellStyle3);
                    ++c;
                }
                cell = 4;
                if (r2 == 0) {
                    d = 0;
                    while (d < perspective.getDateRangeScores().size()) {
                        dateRangeScore = perspective.getDateRangeScores().get(d);
                        cellStyle = wb.createCellStyle();
                        cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cellFont = wb.createFont();
                        cellFont.setBold(false);
                        cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                        cellStyle.setFont(cellFont);
                        cellStyle.setWrapText(true);
                        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                        contentCell1 = contentRow.createCell(cell++);
                        contentCell1.setCellValue(dateRangeScore.getDate());
                        contentCell1.setCellStyle(cellStyle);
                        ++d;
                    }
                }
                if (r2 == 1) {
                    d = 0;
                    while (d < perspective.getDateRangeScores().size()) {
                        dateRangeScore = perspective.getDateRangeScores().get(d);
                        cellStyle = wb.createCellStyle();
                        cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cellFont = wb.createFont();
                        cellFont.setBold(false);
                        cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                        cellStyle.setFont(cellFont);
                        cellStyle.setWrapText(true);
                        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                        contentCell1 = contentRow.createCell(cell++);
                        contentCell1.setCellValue("      " + BscReportSupportUtils.parse2(dateRangeScore.getScore()));
                        contentCell1.setCellStyle(cellStyle);
                        ++d;
                    }
                }
                ++r2;
            }
            sh.addMergedRegion(new CellRangeAddress(row - 2, row - 1, 0, drCols - 1));
        }
        cell = 0;
        headRow = sh.createRow(row);
        headRow.setHeight((short)700);
        i = 0;
        while (i < cols) {
            headCell1 = headRow.createCell(cell++);
            headCell1.setCellValue(String.valueOf(BscReportPropertyUtils.getObjectiveTitle()) + " date range score");
            headCell1.setCellStyle(cellStyleLabel);
            ++i;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, cols - 1));
        ++row;
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            for (ObjectiveVO objective : perspective.getObjectives()) {
                cell = 0;
                int r3 = 0;
                while (r3 < drRows) {
                    Cell contentCell1;
                    XSSFFont cellFont;
                    XSSFCellStyle cellStyle;
                    DateRangeScoreVO dateRangeScore;
                    int d;
                    XSSFRow contentRow = sh.createRow(row++);
                    contentRow.setHeight((short)400);
                    int c = 0;
                    while (c < drCols) {
                        XSSFCellStyle cellStyle4 = wb.createCellStyle();
                        cellStyle4.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(objective.getBgColor()), null));
                        cellStyle4.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        XSSFFont cellFont4 = wb.createFont();
                        cellFont4.setBold(false);
                        cellFont4.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(objective.getFontColor()), null));
                        cellStyle4.setFont(cellFont4);
                        cellStyle4.setWrapText(true);
                        cellStyle4.setVerticalAlignment(VerticalAlignment.CENTER);
                        cellStyle4.setBorderBottom(BorderStyle.THIN);
                        cellStyle4.setBorderTop(BorderStyle.THIN);
                        cellStyle4.setBorderRight(BorderStyle.THIN);
                        cellStyle4.setBorderLeft(BorderStyle.THIN);
                        Cell contentCell14 = contentRow.createCell(c);
                        contentCell14.setCellValue(objective.getName());
                        contentCell14.setCellStyle(cellStyle4);
                        ++c;
                    }
                    cell = 4;
                    if (r3 == 0) {
                        d = 0;
                        while (d < objective.getDateRangeScores().size()) {
                            dateRangeScore = objective.getDateRangeScores().get(d);
                            cellStyle = wb.createCellStyle();
                            cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                            cellFont = wb.createFont();
                            cellFont.setBold(false);
                            cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                            cellStyle.setFont(cellFont);
                            cellStyle.setWrapText(true);
                            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                            cellStyle.setBorderBottom(BorderStyle.THIN);
                            cellStyle.setBorderTop(BorderStyle.THIN);
                            cellStyle.setBorderRight(BorderStyle.THIN);
                            cellStyle.setBorderLeft(BorderStyle.THIN);
                            contentCell1 = contentRow.createCell(cell++);
                            contentCell1.setCellValue(dateRangeScore.getDate());
                            contentCell1.setCellStyle(cellStyle);
                            ++d;
                        }
                    }
                    if (r3 == 1) {
                        d = 0;
                        while (d < objective.getDateRangeScores().size()) {
                            dateRangeScore = objective.getDateRangeScores().get(d);
                            cellStyle = wb.createCellStyle();
                            cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                            cellFont = wb.createFont();
                            cellFont.setBold(false);
                            cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                            cellStyle.setFont(cellFont);
                            cellStyle.setWrapText(true);
                            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                            cellStyle.setBorderBottom(BorderStyle.THIN);
                            cellStyle.setBorderTop(BorderStyle.THIN);
                            cellStyle.setBorderRight(BorderStyle.THIN);
                            cellStyle.setBorderLeft(BorderStyle.THIN);
                            contentCell1 = contentRow.createCell(cell++);
                            contentCell1.setCellValue("      " + BscReportSupportUtils.parse2(dateRangeScore.getScore()));
                            contentCell1.setCellStyle(cellStyle);
                            ++d;
                        }
                    }
                    ++r3;
                }
                sh.addMergedRegion(new CellRangeAddress(row - 2, row - 1, 0, drCols - 1));
            }
        }
        cell = 0;
        headRow = sh.createRow(row);
        headRow.setHeight((short)700);
        i = 0;
        while (i < cols) {
            headCell1 = headRow.createCell(cell);
            headCell1.setCellValue(String.valueOf(BscReportPropertyUtils.getKpiTitle()) + " date range score");
            headCell1.setCellStyle(cellStyleLabel);
            ++i;
        }
        sh.addMergedRegion(new CellRangeAddress(row, row, 0, cols - 1));
        ++row;
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            for (ObjectiveVO objective : perspective.getObjectives()) {
                for (KpiVO kpi : objective.getKpis()) {
                    cell = 0;
                    int r4 = 0;
                    while (r4 < drRows) {
                        Cell contentCell1;
                        XSSFFont cellFont;
                        XSSFCellStyle cellStyle;
                        DateRangeScoreVO dateRangeScore;
                        int d;
                        XSSFRow contentRow = sh.createRow(row++);
                        contentRow.setHeight((short)400);
                        int c = 0;
                        while (c < drCols) {
                            XSSFCellStyle cellStyle5 = wb.createCellStyle();
                            cellStyle5.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(kpi.getBgColor()), null));
                            cellStyle5.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                            XSSFFont cellFont5 = wb.createFont();
                            cellFont5.setBold(false);
                            cellFont5.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(kpi.getFontColor()), null));
                            cellStyle5.setFont(cellFont5);
                            cellStyle5.setWrapText(true);
                            cellStyle5.setVerticalAlignment(VerticalAlignment.CENTER);
                            cellStyle5.setBorderBottom(BorderStyle.THIN);
                            cellStyle5.setBorderTop(BorderStyle.THIN);
                            cellStyle5.setBorderRight(BorderStyle.THIN);
                            cellStyle5.setBorderLeft(BorderStyle.THIN);
                            Cell contentCell15 = contentRow.createCell(c);
                            contentCell15.setCellValue(kpi.getName());
                            contentCell15.setCellStyle(cellStyle5);
                            ++c;
                        }
                        cell = 4;
                        if (r4 == 0) {
                            d = 0;
                            while (d < kpi.getDateRangeScores().size()) {
                                dateRangeScore = kpi.getDateRangeScores().get(d);
                                cellStyle = wb.createCellStyle();
                                cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                cellFont = wb.createFont();
                                cellFont.setBold(false);
                                cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                                cellStyle.setFont(cellFont);
                                cellStyle.setWrapText(true);
                                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                                cellStyle.setBorderBottom(BorderStyle.THIN);
                                cellStyle.setBorderTop(BorderStyle.THIN);
                                cellStyle.setBorderRight(BorderStyle.THIN);
                                cellStyle.setBorderLeft(BorderStyle.THIN);
                                contentCell1 = contentRow.createCell(cell++);
                                contentCell1.setCellValue(dateRangeScore.getDate());
                                contentCell1.setCellStyle(cellStyle);
                                ++d;
                            }
                        }
                        if (r4 == 1) {
                            d = 0;
                            while (d < kpi.getDateRangeScores().size()) {
                                dateRangeScore = kpi.getDateRangeScores().get(d);
                                cellStyle = wb.createCellStyle();
                                cellStyle.setFillForegroundColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getBgColor()), null));
                                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                cellFont = wb.createFont();
                                cellFont.setBold(false);
                                cellFont.setColor(new XSSFColor(SimpleUtils.getColorRGB4POIColor(dateRangeScore.getFontColor()), null));
                                cellStyle.setFont(cellFont);
                                cellStyle.setWrapText(true);
                                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                                cellStyle.setBorderBottom(BorderStyle.THIN);
                                cellStyle.setBorderTop(BorderStyle.THIN);
                                cellStyle.setBorderRight(BorderStyle.THIN);
                                cellStyle.setBorderLeft(BorderStyle.THIN);
                                contentCell1 = contentRow.createCell(cell++);
                                contentCell1.setCellValue("      " + BscReportSupportUtils.parse2(dateRangeScore.getScore()));
                                contentCell1.setCellStyle(cellStyle);
                                byte[] imgBytes = BscReportSupportUtils.getByteIcon(kpi, dateRangeScore.getScore());
                                if (imgBytes != null) {
                                    SimpleUtils.setCellPicture(wb, sh, imgBytes, contentCell1.getRowIndex(), contentCell1.getColumnIndex());
                                }
                                ++d;
                            }
                        }
                        ++r4;
                    }
                    sh.addMergedRegion(new CellRangeAddress(row - 2, row - 1, 0, drCols - 1));
                }
            }
        }
        return row++;
    }

    private void fillHeadContent(Context context, Map<String, Object> parameter) throws ServiceException, Exception {
        DefaultResult<BaseValueObj> result;
        String headContent = "";
        String orgId = (String)context.get("orgId");
        String empId = (String)context.get("empId");
        String account = (String)context.get("account");
        if (!"*".equals(orgId) && !StringUtils.isBlank(orgId)) {
            OrganizationVO organization = new OrganizationVO();
            organization.setOrgId(orgId);
            result = this.organizationService.findByUK(organization);
            if (result.getValue() != null) {
                organization = result.getValue();
                headContent = String.valueOf(headContent) + "\nMeasure data for: " + organization.getOrgId() + " - " + organization.getName();
            }
        }
        if (!("*".equals(empId) || StringUtils.isBlank(empId) || StringUtils.isBlank(account))) {
            EmployeeVO employee = new EmployeeVO();
            employee.setEmpId(empId);
            employee.setAccount(account);
            result = this.employeeService.findByUK(employee);
            if (result.getValue() != null) {
                employee = (EmployeeVO)result.getValue();
                headContent = String.valueOf(headContent) + "\nMeasure data for: " + employee.getEmpId() + " - " + employee.getFullName();
                if (!StringUtils.isBlank(employee.getJobTitle())) {
                    headContent = String.valueOf(headContent) + " ( " + employee.getJobTitle() + " ) ";
                }
            }
        }
        parameter.put("headContent", headContent);
    }

    private String getItemsContent(String name, float score, BigDecimal weight, float target, float min) {
        String str = "";
        str = String.valueOf(name) + "\n" + BscReportPropertyUtils.getScoreLabel() + " " + BscReportSupportUtils.parse2(score) + "\n" + BscReportPropertyUtils.getWeightLabel() + " " + weight.toString() + "%" + "\n" + BscReportPropertyUtils.getTargetLabel() + " " + target + "\n" + BscReportPropertyUtils.getMinLabel() + " " + min;
        return str;
    }

    private String getItemsContent(String name, float score, BigDecimal weight, float max, float target, float min) {
        String str = "";
        str = String.valueOf(name) + "\n" + BscReportPropertyUtils.getScoreLabel() + " " + BscReportSupportUtils.parse2(score) + "\n" + BscReportPropertyUtils.getWeightLabel() + " " + weight.toString() + "%" + "\n" + BscReportPropertyUtils.getMaxLabel() + " " + max + "\n" + BscReportPropertyUtils.getTargetLabel() + " " + target + "\n" + BscReportPropertyUtils.getMinLabel() + " " + min;
        return str;
    }

    private String getKpisContent(KpiVO kpi, Map<String, String> managementMap) throws Exception {
        String str = this.getItemsContent(kpi.getName(), kpi.getScore(), kpi.getWeight(), kpi.getMax(), kpi.getTarget(), kpi.getMin());
        str = String.valueOf(str) + "\n" + BscReportPropertyUtils.getManagementLabel() + " " + managementMap.get(kpi.getManagement()) + "\n" + BscReportPropertyUtils.getCalculationLabel() + " " + AggregationMethodUtils.getNameByAggrId(kpi.getCal()) + "\n" + BscReportPropertyUtils.getUnitLabel() + " " + kpi.getUnit() + "\n" + BscReportPropertyUtils.getFormulaLabel() + " " + kpi.getFormula().getName() + "\n" + StringUtils.defaultString(kpi.getDescription());
        return str;
    }
}

