/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.util.BscReportSupportUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONSerializer;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public class KpiReportCoffeeChartJsonDataCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        this.setJsonData(context, treeObj);
        return false;
    }

    private void setJsonData(Context context, BscStructTreeObj treeObj) throws Exception {
        if (treeObj == null || treeObj.getVisions() == null || treeObj.getVisions().size() != 1) {
            return;
        }
        ArrayList rootList = new ArrayList();
        HashMap<String, Object> rootDataMap = new HashMap<String, Object>();
        ArrayList perspectivesDatas = new ArrayList();
        List<VisionVO> visions = treeObj.getVisions();
        VisionVO vision = visions.get(0);
        for (PerspectiveVO perspective : vision.getPerspectives()) {
            HashMap<String, Object> perspectiveDataMap = new HashMap<String, Object>();
            ArrayList perspectiveChildren = new ArrayList();
            perspectiveDataMap.put("name", this.getName(perspective.getName(), perspective.getScore()));
            perspectiveDataMap.put("children", perspectiveChildren);
            perspectiveDataMap.put("colour", perspective.getBgColor());
            perspectiveDataMap.put("fontColor", perspective.getFontColor());
            perspectiveDataMap.put("score", Float.valueOf(perspective.getScore()));
            perspectivesDatas.add(perspectiveDataMap);
            for (ObjectiveVO objective : perspective.getObjectives()) {
                HashMap<String, Object> objectiveDataMap = new HashMap<String, Object>();
                ArrayList objectiveChildren = new ArrayList();
                objectiveDataMap.put("name", this.getName(objective.getName(), objective.getScore()));
                objectiveDataMap.put("children", objectiveChildren);
                objectiveDataMap.put("colour", objective.getBgColor());
                objectiveDataMap.put("fontColor", objective.getFontColor());
                objectiveDataMap.put("score", Float.valueOf(objective.getScore()));
                perspectiveChildren.add(objectiveDataMap);
                for (KpiVO kpi : objective.getKpis()) {
                    HashMap<String, Object> indicatorsDataMap = new HashMap<String, Object>();
                    indicatorsDataMap.put("name", this.getName(kpi.getName(), kpi.getScore()));
                    indicatorsDataMap.put("colour", kpi.getBgColor());
                    indicatorsDataMap.put("fontColor", kpi.getFontColor());
                    indicatorsDataMap.put("score", Float.valueOf(kpi.getScore()));
                    objectiveChildren.add(indicatorsDataMap);
                }
            }
        }
        rootDataMap.put("name", this.getName(vision.getTitle(), vision.getScore()));
        rootDataMap.put("children", perspectivesDatas);
        rootDataMap.put("colour", vision.getBgColor());
        rootDataMap.put("fontColor", vision.getFontColor());
        rootDataMap.put("score", Float.valueOf(vision.getScore()));
        rootList.add(rootDataMap);
        String jsonDataStr = ((JSONArray)JSONSerializer.toJSON(rootList)).toString();
        this.setResult(context, jsonDataStr);
    }

    private String getName(String name, float score) {
        return String.valueOf(name) + "(" + BscReportSupportUtils.parse(score) + ")";
    }
}

