/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.bsc.command;

import com.netsteadfast.greenstep.base.BaseChainCommandSupport;
import com.netsteadfast.greenstep.bsc.model.BscStructTreeObj;
import com.netsteadfast.greenstep.bsc.support.ScoreCalculationCallable;
import com.netsteadfast.greenstep.bsc.support.ScoreCalculationCallableData;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.KpiVO;
import com.netsteadfast.greenstep.vo.ObjectiveVO;
import com.netsteadfast.greenstep.vo.PerspectiveVO;
import com.netsteadfast.greenstep.vo.VisionVO;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;

public class KpiDateRangeScoreCommand
extends BaseChainCommandSupport
implements Command {
    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getResult(context) == null || !(this.getResult(context) instanceof BscStructTreeObj)) {
            return false;
        }
        BscStructTreeObj treeObj = (BscStructTreeObj)this.getResult(context);
        String frequency = (String)context.get("frequency");
        String startYearDate = StringUtils.defaultString((String)context.get("startYearDate")).trim();
        String endYearDate = StringUtils.defaultString((String)context.get("endYearDate")).trim();
        String startDate = StringUtils.defaultString((String)context.get("startDate")).trim();
        String endDate = StringUtils.defaultString((String)context.get("endDate")).trim();
        for (VisionVO vision : treeObj.getVisions()) {
            for (PerspectiveVO perspective : vision.getPerspectives()) {
                for (ObjectiveVO objective : perspective.getObjectives()) {
                    ExecutorService kpiCalculationPool = Executors.newFixedThreadPool(SimpleUtils.getAvailableProcessors(objective.getKpis().size()));
                    for (KpiVO kpi : objective.getKpis()) {
                        ScoreCalculationCallableData data = new ScoreCalculationCallableData();
                        data.setDefaultMode(false);
                        data.setKpi(kpi);
                        data.setFrequency(frequency);
                        data.setDate1(startYearDate);
                        data.setDate2(endYearDate);
                        if ("1".equals(frequency) || "2".equals(frequency) || "3".equals(frequency)) {
                            data.setDate1(startDate);
                            data.setDate2(endDate);
                        }
                        data = kpiCalculationPool.submit(new ScoreCalculationCallable(data)).get();
                    }
                    kpiCalculationPool.shutdown();
                }
            }
        }
        return false;
    }
}

