/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.service.logic;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.bsc.service.IEmployeeService;
import com.netsteadfast.greenstep.bsc.service.IOrganizationService;
import com.netsteadfast.greenstep.po.hbm.BbEmployee;
import com.netsteadfast.greenstep.po.hbm.BbOrganization;
import com.netsteadfast.greenstep.vo.EmployeeVO;
import com.netsteadfast.greenstep.vo.OrganizationVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BscBaseLogicServiceCommonSupport {
    public static OrganizationVO findOrganizationData(IOrganizationService<OrganizationVO, BbOrganization, String> service, String oid) throws ServiceException, Exception {
        if (StringUtils.isBlank(oid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        OrganizationVO organization = new OrganizationVO();
        organization.setOid(oid);
        DefaultResult<OrganizationVO> orgResult = service.findObjectByOid(organization);
        if (orgResult.getValue() == null) {
            throw new ServiceException(orgResult.getSystemMessage().getValue());
        }
        organization = orgResult.getValue();
        return organization;
    }

    public static EmployeeVO findEmployeeData(IEmployeeService<EmployeeVO, BbEmployee, String> service, String oid) throws ServiceException, Exception {
        if (StringUtils.isBlank(oid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        EmployeeVO employee = new EmployeeVO();
        employee.setOid(oid);
        DefaultResult<EmployeeVO> empResult = service.findObjectByOid(employee);
        if (empResult.getValue() == null) {
            throw new ServiceException(empResult.getSystemMessage().getValue());
        }
        employee = empResult.getValue();
        return employee;
    }

    public static OrganizationVO findOrganizationDataByUK(IOrganizationService<OrganizationVO, BbOrganization, String> service, String orgId) throws ServiceException, Exception {
        if (StringUtils.isBlank(orgId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        OrganizationVO organization = new OrganizationVO();
        organization.setOrgId(orgId);
        DefaultResult<OrganizationVO> orgResult = service.findByUK(organization);
        if (orgResult.getValue() == null) {
            throw new ServiceException(orgResult.getSystemMessage().getValue());
        }
        organization = orgResult.getValue();
        return organization;
    }

    public static EmployeeVO findEmployeeDataByUK(IEmployeeService<EmployeeVO, BbEmployee, String> service, String accountId, String empId) throws ServiceException, Exception {
        if (StringUtils.isBlank(accountId) || StringUtils.isBlank(empId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        EmployeeVO employee = new EmployeeVO();
        employee.setAccount(accountId);
        employee.setEmpId(empId);
        DefaultResult<EmployeeVO> empResult = service.findByUK(employee);
        if (empResult.getValue() == null) {
            throw new ServiceException(empResult.getSystemMessage().getValue());
        }
        employee = empResult.getValue();
        return employee;
    }

    public static EmployeeVO findEmployeeDataByAccountId(IEmployeeService<EmployeeVO, BbEmployee, String> service, String accountId) throws ServiceException, Exception {
        if (StringUtils.isBlank(accountId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        BbEmployee poEmployee = service.findByAccountId(accountId);
        EmployeeVO employeeObj = new EmployeeVO();
        service.doMapper(poEmployee, employeeObj, "employee.po2vo");
        return employeeObj;
    }

    public static EmployeeVO findEmployeeDataByEmpId(IEmployeeService<EmployeeVO, BbEmployee, String> service, String empId) throws ServiceException, Exception {
        if (StringUtils.isBlank(empId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("empId", empId);
        List employeeList = service.findListVOByParams(paramMap);
        if (employeeList == null || employeeList.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        if (employeeList.size() != 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        return (EmployeeVO)employeeList.get(0);
    }
}

