/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeClassNameParser;
import com.datastax.driver.core.DataTypeCqlNameParser;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.core.utils.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateMetadata.class);
    private final KeyspaceMetadata keyspace;
    private final String simpleName;
    private final List<DataType> argumentTypes;
    private final String finalFuncSimpleName;
    private final String finalFuncFullName;
    private final Object initCond;
    private final DataType returnType;
    private final String stateFuncSimpleName;
    private final String stateFuncFullName;
    private final DataType stateType;
    private final TypeCodec<Object> stateTypeCodec;

    private AggregateMetadata(KeyspaceMetadata keyspace, String simpleName, List<DataType> argumentTypes, String finalFuncSimpleName, String finalFuncFullName, Object initCond, DataType returnType, String stateFuncSimpleName, String stateFuncFullName, DataType stateType, TypeCodec<Object> stateTypeCodec) {
        this.keyspace = keyspace;
        this.simpleName = simpleName;
        this.argumentTypes = argumentTypes;
        this.finalFuncSimpleName = finalFuncSimpleName;
        this.finalFuncFullName = finalFuncFullName;
        this.initCond = initCond;
        this.returnType = returnType;
        this.stateFuncSimpleName = stateFuncSimpleName;
        this.stateFuncFullName = stateFuncFullName;
        this.stateType = stateType;
        this.stateTypeCodec = stateTypeCodec;
    }

    static AggregateMetadata build(KeyspaceMetadata ksm, Row row, VersionNumber version, Cluster cluster) {
        Object initCond;
        Object rawInitCond;
        DataType stateType;
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        String simpleName = row.getString("aggregate_name");
        List<DataType> argumentTypes = AggregateMetadata.parseTypes(ksm, row.getList("argument_types", String.class), version, cluster);
        String finalFuncSimpleName = row.getString("final_func");
        DataType returnType = version.getMajor() >= 3 ? DataTypeCqlNameParser.parse(row.getString("return_type"), cluster, ksm.getName(), ksm.userTypes, null, false, false) : DataTypeClassNameParser.parseOne(row.getString("return_type"), protocolVersion, codecRegistry);
        String stateFuncSimpleName = row.getString("state_func");
        String stateTypeName = row.getString("state_type");
        if (version.getMajor() >= 3) {
            stateType = DataTypeCqlNameParser.parse(stateTypeName, cluster, ksm.getName(), ksm.userTypes, null, false, false);
            rawInitCond = row.getString("initcond");
            if (rawInitCond == null) {
                initCond = null;
            } else {
                try {
                    initCond = codecRegistry.codecFor(stateType).parse((String)rawInitCond);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Failed to parse INITCOND literal: {}; getInitCond() will return the text literal instead.", rawInitCond);
                    initCond = rawInitCond;
                }
            }
        } else {
            stateType = DataTypeClassNameParser.parseOne(stateTypeName, protocolVersion, codecRegistry);
            rawInitCond = row.getBytes("initcond");
            if (rawInitCond == null) {
                initCond = null;
            } else {
                try {
                    initCond = codecRegistry.codecFor(stateType).deserialize((ByteBuffer)rawInitCond, protocolVersion);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Failed to deserialize INITCOND value: {}; getInitCond() will return the raw bytes instead.", (Object)Bytes.toHexString((ByteBuffer)rawInitCond));
                    initCond = rawInitCond;
                }
            }
        }
        String finalFuncFullName = finalFuncSimpleName == null ? null : Metadata.fullFunctionName(finalFuncSimpleName, Collections.singletonList(stateType));
        String stateFuncFullName = AggregateMetadata.makeStateFuncFullName(stateFuncSimpleName, stateType, argumentTypes);
        return new AggregateMetadata(ksm, simpleName, argumentTypes, finalFuncSimpleName, finalFuncFullName, initCond, returnType, stateFuncSimpleName, stateFuncFullName, stateType, codecRegistry.codecFor(stateType));
    }

    private static String makeStateFuncFullName(String stateFuncSimpleName, DataType stateType, List<DataType> argumentTypes) {
        ArrayList args = Lists.newArrayList((Object[])new DataType[]{stateType});
        args.addAll(argumentTypes);
        return Metadata.fullFunctionName(stateFuncSimpleName, args);
    }

    private static List<DataType> parseTypes(KeyspaceMetadata ksm, List<String> types, VersionNumber version, Cluster cluster) {
        if (types.isEmpty()) {
            return Collections.emptyList();
        }
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : types) {
            DataType type = version.getMajor() >= 3 ? DataTypeCqlNameParser.parse(name, cluster, ksm.getName(), ksm.userTypes, null, false, false) : DataTypeClassNameParser.parseOne(name, protocolVersion, codecRegistry);
            builder.add((Object)type);
        }
        return builder.build();
    }

    public String exportAsString() {
        return this.asCQLQuery(true);
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    public String toString() {
        return this.asCQLQuery(false);
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder("CREATE AGGREGATE ").append(Metadata.quoteIfNecessary(this.keyspace.getName())).append('.');
        this.appendSignature(sb);
        TableMetadata.spaceOrNewLine(sb, formatted).append("SFUNC ").append(Metadata.quoteIfNecessary(this.stateFuncSimpleName)).append(" STYPE ").append(this.stateType.asFunctionParameterString());
        if (this.finalFuncSimpleName != null) {
            TableMetadata.spaceOrNewLine(sb, formatted).append("FINALFUNC ").append(Metadata.quoteIfNecessary(this.finalFuncSimpleName));
        }
        if (this.initCond != null) {
            TableMetadata.spaceOrNewLine(sb, formatted).append("INITCOND ").append(this.formatInitCond());
        }
        sb.append(';');
        return sb.toString();
    }

    private String formatInitCond() {
        if (this.stateTypeCodec.accepts(this.initCond)) {
            try {
                return this.stateTypeCodec.format(this.initCond);
            }
            catch (RuntimeException e) {
                LOGGER.info("Failed to format INITCOND literal: {}", this.initCond);
            }
        }
        return this.initCond.toString();
    }

    private void appendSignature(StringBuilder sb) {
        sb.append(Metadata.quoteIfNecessary(this.simpleName)).append('(');
        boolean first = true;
        for (DataType type : this.argumentTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(type.asFunctionParameterString());
        }
        sb.append(')');
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        this.appendSignature(sb);
        return sb.toString();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<DataType> getArgumentTypes() {
        return this.argumentTypes;
    }

    public FunctionMetadata getFinalFunc() {
        return this.finalFuncFullName == null ? null : this.keyspace.functions.get(this.finalFuncFullName);
    }

    public Object getInitCond() {
        return this.initCond;
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    public FunctionMetadata getStateFunc() {
        return this.keyspace.functions.get(this.stateFuncFullName);
    }

    public DataType getStateType() {
        return this.stateType;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AggregateMetadata) {
            AggregateMetadata that = (AggregateMetadata)other;
            return this.keyspace.getName().equals(that.keyspace.getName()) && this.argumentTypes.equals(that.argumentTypes) && MoreObjects.equal(this.finalFuncFullName, that.finalFuncFullName) && MoreObjects.equal(this.initCond, that.initCond) && this.returnType.equals(that.returnType) && this.stateFuncFullName.equals(that.stateFuncFullName) && this.stateType.equals(that.stateType);
        }
        return false;
    }

    public int hashCode() {
        return MoreObjects.hashCode(this.keyspace.getName(), this.argumentTypes, this.finalFuncFullName, this.initCond, this.returnType, this.stateFuncFullName, this.stateType);
    }
}

