/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Color;
import java.io.FileOutputStream;
import org.apache.commons.lang3.StringUtils;

public class PdfWatermarkUtils {
    public static void main(String[] args) throws Exception {
        FontFactory.register("fonts/fireflysung.ttf");
        Font font = FontFactory.getFont("fonts/fireflysung.ttf", "Identity-H", true);
        PdfReader pdfReader = new PdfReader("/tmp/ex/test.pdf");
        PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream("/tmp/ex/test-out.pdf"));
        PdfWatermarkUtils.addWatermark(pdfStamper, font.getBaseFont(), Color.RED, "\u6e2c\u8a66");
        pdfStamper.close();
    }

    public static void addWatermark(PdfStamper pdfStamper, BaseFont baseFont, Color fontColor, String waterMarkString) throws Exception {
        if (pdfStamper == null || baseFont == null) {
            throw new Exception("PdfStamper or BaseFont is null.");
        }
        if (StringUtils.isBlank(waterMarkString)) {
            return;
        }
        PdfContentByte pdfContentByte = null;
        Rectangle pageRect = null;
        PdfGState pdfGState = new PdfGState();
        pdfGState.setFillOpacity(0.4f);
        pdfGState.setStrokeOpacity(0.4f);
        int pageNum = pdfStamper.getReader().getNumberOfPages();
        try {
            try {
                int i = 1;
                while (i <= pageNum) {
                    pageRect = pdfStamper.getReader().getPageSizeWithRotation(i);
                    float x = pageRect.getWidth() / 2.0f;
                    float y = pageRect.getHeight() / 2.0f;
                    pdfContentByte = pdfStamper.getOverContent(i);
                    pdfContentByte.saveState();
                    pdfContentByte.setGState(pdfGState);
                    pdfContentByte.beginText();
                    pdfContentByte.setColorFill(fontColor);
                    pdfContentByte.setFontAndSize(baseFont, 60.0f);
                    pdfContentByte.showTextAligned(1, waterMarkString, x, y, 45.0f);
                    pdfContentByte.endText();
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                pdfContentByte = null;
                pageRect = null;
            }
        }
        finally {
            pdfContentByte = null;
            pageRect = null;
        }
    }
}

