/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.netsteadfast.greenstep.util.PdfWatermarkUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class PdfOwnerUserBuilder {
    private String pdfFileFullPath = "";
    private String destEncryptionPdfPath = "";
    private String owner = "PdfOwnerUserBuilder";
    private String user = "PdfOwnerUserBuilder";
    private String watermarkText = "";

    public static PdfOwnerUserBuilder build() {
        PdfOwnerUserBuilder pdfOwnerUserBuilder = new PdfOwnerUserBuilder();
        return pdfOwnerUserBuilder;
    }

    public PdfOwnerUserBuilder watermarkText(String watermarkText) {
        if (!StringUtils.isBlank(watermarkText)) {
            this.watermarkText = watermarkText;
        }
        return this;
    }

    public PdfOwnerUserBuilder owner(String owner) {
        if (!StringUtils.isBlank(owner)) {
            this.owner = owner;
        }
        return this;
    }

    public PdfOwnerUserBuilder user(String user) {
        if (!StringUtils.isBlank(user)) {
            this.user = user;
        }
        return this;
    }

    public PdfOwnerUserBuilder destFile(String fullPath) {
        this.destEncryptionPdfPath = fullPath;
        return this;
    }

    public PdfOwnerUserBuilder destFileToTmpdir() {
        String fullPath = String.valueOf(System.getProperty("java.io.tmpdir")) + "/" + PdfOwnerUserBuilder.class.getSimpleName() + "/" + System.currentTimeMillis() + "/" + System.currentTimeMillis() + ".pdf";
        this.destFile(fullPath);
        return this;
    }

    public PdfOwnerUserBuilder sourceFile(String fullPath) throws Exception {
        File f = new File(fullPath);
        if (!f.exists()) {
            f = null;
            throw new Exception("no exists file : " + fullPath);
        }
        f = null;
        this.pdfFileFullPath = fullPath;
        return this;
    }

    public PdfOwnerUserBuilder process() throws Exception {
        if (StringUtils.isBlank(this.destEncryptionPdfPath) || StringUtils.isBlank(this.pdfFileFullPath)) {
            throw new Exception("no exists dest file : " + this.destEncryptionPdfPath + " or source file : " + this.pdfFileFullPath);
        }
        File destEncryptionPdfFile = new File(this.destEncryptionPdfPath);
        if (!destEncryptionPdfFile.getParentFile().exists()) {
            FileUtils.forceMkdir(destEncryptionPdfFile.getParentFile());
        }
        destEncryptionPdfFile = null;
        FileOutputStream destEncryptionPdfFileOs = new FileOutputStream(this.destEncryptionPdfPath);
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            reader = new PdfReader(this.pdfFileFullPath);
            stamper = new PdfStamper(reader, destEncryptionPdfFileOs);
            stamper.setEncryption(this.user.getBytes(), this.owner.getBytes(), 2052, 2);
            if (!StringUtils.isBlank(this.watermarkText)) {
                Font font = FontFactory.getFont("fonts/fireflysung.ttf", "Identity-H", true);
                PdfWatermarkUtils.addWatermark(stamper, font.getBaseFont(), Color.RED, this.watermarkText);
            }
            stamper.close();
            reader.close();
        }
        finally {
            if (stamper != null) {
                stamper = null;
            }
            if (reader != null) {
                reader = null;
            }
            if (destEncryptionPdfFileOs != null) {
                destEncryptionPdfFileOs.close();
                destEncryptionPdfFileOs = null;
            }
        }
        return this;
    }

    public String destFileFullPath() {
        return this.destEncryptionPdfPath;
    }
}

