/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbSysIcon;
import com.netsteadfast.greenstep.service.ISysIconService;
import com.netsteadfast.greenstep.vo.SysIconVO;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IconUtils {
    public static final String ICON_FOLDER = "./icons/";
    private static ISysIconService<SysIconVO, TbSysIcon, String> sysIconService = (ISysIconService)AppContext.getBean("core.service.SysIconService");

    public static ISysIconService<SysIconVO, TbSysIcon, String> getSysIconService() {
        return sysIconService;
    }

    public static void setSysIconService(ISysIconService<SysIconVO, TbSysIcon, String> sysIconService) {
        IconUtils.sysIconService = sysIconService;
    }

    public static String getUrl(String basePath, String iconId) throws ServiceException, Exception {
        String url = "";
        if (StringUtils.isBlank(iconId)) {
            return url;
        }
        TbSysIcon sysIcon = new TbSysIcon();
        sysIcon.setIconId(iconId);
        sysIcon = sysIconService.findByEntityUK(sysIcon);
        if (sysIcon != null && StringUtils.defaultString(sysIcon.getFileName()).trim().length() > 0) {
            url = String.valueOf(basePath) + "/" + ICON_FOLDER + StringUtils.defaultString(sysIcon.getFileName());
        }
        return url;
    }

    public static String getMenuIcon(String basePath, String iconId) throws ServiceException, Exception {
        String img = IconUtils.getHtmlImg(basePath, iconId);
        if (!"".equals(img)) {
            img = String.valueOf(img) + "&nbsp;";
        }
        return img;
    }

    public static String getHtmlImg(String basePath, String iconId) throws ServiceException, Exception {
        String img = "";
        String url = "";
        url = IconUtils.getUrl(basePath, iconId);
        if (!"".equals(url)) {
            img = "<img src='" + url + "' border='0' />";
        }
        return img;
    }

    public static Map<String, String> getIconsSelectData() throws ServiceException, Exception {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        List iconList = sysIconService.findListByParams(null);
        if (iconList == null || iconList.size() < 1) {
            return dataMap;
        }
        for (TbSysIcon entity : iconList) {
            String label = "<img src='./icons/" + entity.getFileName() + "' border='0'/>&nbsp;" + entity.getIconId();
            dataMap.put(entity.getOid(), label);
        }
        return dataMap;
    }
}

