/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http11.Http11Protocol;

public class HostUtils {
    public static int getHttpPort() {
        int port = 8080;
        MBeanServer mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
        try {
            ObjectName name = new ObjectName("Catalina", "type", "Server");
            try {
                Service[] services;
                Server server = (Server)mBeanServer.getAttribute(name, "managedResource");
                Service[] serviceArray = services = server.findServices();
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    Service service = serviceArray[n2];
                    Connector[] connectorArray = service.findConnectors();
                    int n3 = connectorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Connector connector = connectorArray[n4];
                        ProtocolHandler protocolHandler = connector.getProtocolHandler();
                        if (protocolHandler instanceof Http11Protocol || protocolHandler instanceof Http11AprProtocol || protocolHandler instanceof Http11NioProtocol) {
                            port = connector.getPort();
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return port;
    }

    public static String getHostAddress() {
        String hostAddress = "";
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements() && "".equals(hostAddress)) {
                NetworkInterface interfece = nics.nextElement();
                if (interfece.getName().toLowerCase().startsWith("lo")) continue;
                Enumeration<InetAddress> addrs = interfece.getInetAddresses();
                while (addrs.hasMoreElements() && "".equals(hostAddress)) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.getHostAddress().indexOf(":") > -1) continue;
                    hostAddress = addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (StringUtils.isBlank(hostAddress)) {
            hostAddress = "127.0.0.1";
        }
        return hostAddress;
    }

    public static void main(String[] args) throws Exception {
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            System.out.println("--------------------------------------------------------------------------");
            NetworkInterface interfece = nics.nextElement();
            System.out.println(interfece.getName());
            Enumeration<InetAddress> addrs = interfece.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                System.out.println(addr.getHostAddress());
            }
        }
    }
}

