/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.tools;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.util.MailClientUtils;
import com.netsteadfast.greenstep.vo.AccountVO;
import org.apache.commons.lang3.StringUtils;

public class LostPasswordTools {
    private static IAccountService<AccountVO, TbAccount, String> accountService = (IAccountService)AppContext.getBean("core.service.AccountService");

    private static void printDetails() {
        System.out.println("LostPasswordTools [OP] [ACCOUNT] [MAIL]");
        System.out.println("OP:");
        System.out.println("\t1: show new password.");
        System.out.println("\t2: send new password to recive mail.");
        System.out.println(" ");
        System.out.println("ACCOUNT:");
        System.out.println("\tinput user's account id.");
        System.out.println(" ");
        System.out.println("Example:");
        System.out.println("\tLostPasswordTools 1 admin");
        System.out.println("\tLostPasswordTools 2 admin chen.xin.nien@gmail.com");
    }

    private static void generateNewPassword(String operation, String account, String mail) throws ServiceException, Exception {
        String newPassword = accountService.generateNewPassword(account);
        if ("1".equals(operation)) {
            System.out.println("===================================");
            System.out.println("new password: " + newPassword);
        } else {
            LostPasswordTools.sendToMail(mail, account, newPassword);
        }
    }

    private static void sendToMail(String mail, String account, String password) throws Exception {
        System.out.println("send new password mail...");
        String subject = "Hi " + account + " new password for bambooBSC!";
        String text = "This is bambooBSC generate new password tools<BR/>";
        text = String.valueOf(text) + "Account: " + account + "<BR/>";
        text = String.valueOf(text) + "Password: " + password + "<BR/>";
        MailClientUtils.send(MailClientUtils.getDefaultFrom(), mail, subject, text);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            LostPasswordTools.printDetails();
            System.exit(1);
        }
        String op = StringUtils.defaultString(args[0]).trim();
        String account = StringUtils.defaultString(args[1]).trim();
        String mail = "";
        if ("".equals(op) || "".equals(account)) {
            LostPasswordTools.printDetails();
            System.exit(1);
        }
        if ("2".equals(op) && args.length != 3) {
            LostPasswordTools.printDetails();
            System.exit(1);
        }
        if ("2".equals(op)) {
            mail = StringUtils.defaultString(args[2]).trim();
        }
        System.out.println("account: " + account);
        System.out.println("operation: " + op);
        System.out.println("mail: " + mail);
        try {
            LostPasswordTools.generateNewPassword(op, account, mail);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

