/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.sys.IUSessLogHelper;
import com.netsteadfast.greenstep.base.sys.USessLogHelperImpl;
import com.netsteadfast.greenstep.sys.ShiroLoginSupport;
import com.netsteadfast.greenstep.util.EncryptorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.subject.Subject;

public class WsAuthenticateUtils {
    private static IUSessLogHelper usessLogHelper = new USessLogHelperImpl();

    public static String getAuthKey(String currentId, String account) throws Exception {
        if (StringUtils.isBlank(currentId) || StringUtils.isBlank(account)) {
            throw new Exception("null key.");
        }
        return EncryptorUtils.encrypt(Constants.getEncryptorKey1(), Constants.getEncryptorKey2(), String.valueOf(currentId) + ";" + account + ";" + System.currentTimeMillis());
    }

    public static boolean valid(String authenticate) throws Exception {
        if (StringUtils.isBlank(authenticate)) {
            throw new Exception("null key.");
        }
        String idStr = EncryptorUtils.decrypt(Constants.getEncryptorKey1(), Constants.getEncryptorKey2(), authenticate);
        if (StringUtils.isBlank(idStr)) {
            throw new Exception("null key.");
        }
        String[] id = idStr.split(";");
        if (id.length != 3) {
            return false;
        }
        if (StringUtils.isBlank(id[0]) || StringUtils.isBlank(id[1])) {
            return false;
        }
        return usessLogHelper.countByCurrent(id[1], id[0]) > 0L;
    }

    public static String getDefaultUser() {
        return "admin";
    }

    public static Subject login() throws Exception {
        ShiroLoginSupport loginSupport = new ShiroLoginSupport();
        Subject subject = loginSupport.forceCreateLoginSubject(WsAuthenticateUtils.getDefaultUser());
        return subject;
    }

    public static void logout(Subject subject) throws Exception {
        if (subject != null) {
            subject.logout();
        }
    }
}

