/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.po.hbm.TbSysQfieldLog;
import com.netsteadfast.greenstep.service.ISysQfieldLogService;
import com.netsteadfast.greenstep.vo.SysQfieldLogVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;

public class SysQueryParamInspectUtils {
    protected static Logger logger = Logger.getLogger(SysQueryParamInspectUtils.class);
    private static final String CONFIG_BEAN_ID = "app.config.queryParamInspectSettings";
    private static final String KEY_SP_STR = "#";
    private static final String VALUE_SP_STR = ",";
    private static final int MAX_VALUE_LENGTH = 500;
    private static ISysQfieldLogService<SysQfieldLogVO, TbSysQfieldLog, String> sysQfieldLogService = (ISysQfieldLogService)AppContext.getBean("core.service.SysQfieldLogService");

    public static Map<String, String> getConfigParamMap() throws Exception {
        return (Map)AppContext.getBean(CONFIG_BEAN_ID);
    }

    public static List<String> getFields(String systemId, String progId, String actionMethodName) throws Exception {
        if (StringUtils.isBlank(systemId) || StringUtils.isBlank(progId) || StringUtils.isBlank(actionMethodName)) {
            throw new IllegalArgumentException("Query parameter inspact config id error.");
        }
        ArrayList<String> fields = null;
        String key = String.valueOf(systemId) + KEY_SP_STR + progId + KEY_SP_STR + actionMethodName;
        String configValue = null;
        configValue = SysQueryParamInspectUtils.getConfigParamMap().get(key);
        if (StringUtils.isBlank(configValue)) {
            return fields;
        }
        String[] tmp = configValue.split(VALUE_SP_STR);
        if (tmp == null || tmp.length < 1) {
            return fields;
        }
        fields = new ArrayList<String>();
        String[] stringArray = tmp;
        int n = tmp.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            if (fieldName.trim().length() >= 1) {
                fields.add(fieldName.trim());
            }
            ++n2;
        }
        return fields;
    }

    private static String getFieldValue(String fieldName, HttpServletRequest request) throws Exception {
        String value = null;
        value = request.getParameter(fieldName);
        if (StringUtils.defaultString(value).length() > 500) {
            value = value.substring(0, 500);
        }
        return value;
    }

    public static void log(String systemId, String progId, String actionMethodName, HttpServletRequest request) throws ServiceException, Exception {
        List<String> fields = SysQueryParamInspectUtils.getFields(systemId, progId, actionMethodName);
        if (fields == null || fields.size() < 1) {
            return;
        }
        if (SecurityUtils.getSubject() == null || StringUtils.isBlank((String)SecurityUtils.getSubject().getPrincipal())) {
            logger.warn("No login userId.");
            return;
        }
        logger.info("log query parameter systemId: " + systemId + "  programId: " + progId);
        for (String fieldName : fields) {
            String value = SysQueryParamInspectUtils.getFieldValue(fieldName, request);
            if (StringUtils.isBlank(value)) continue;
            SysQfieldLogVO fieldLog = new SysQfieldLogVO();
            fieldLog.setSystem(systemId);
            fieldLog.setProgId(progId);
            fieldLog.setMethodName(actionMethodName);
            fieldLog.setFieldName(fieldName);
            fieldLog.setFieldValue(value);
            fieldLog.setQueryUserId((String)SecurityUtils.getSubject().getPrincipal());
            sysQfieldLogService.saveObject(fieldLog);
        }
    }
}

