/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.model.AccountObj;
import com.netsteadfast.greenstep.base.sys.UserAccountHttpSessionSupport;
import com.netsteadfast.greenstep.base.sys.UserCurrentCookie;
import com.netsteadfast.greenstep.sys.GreenStepBaseFormAuthenticationFilter;
import com.netsteadfast.greenstep.sys.GreenStepBaseUsernamePasswordToken;
import com.netsteadfast.greenstep.sys.IncorrectCaptchaException;
import com.netsteadfast.greenstep.sys.ShiroLoginSupport;
import com.netsteadfast.greenstep.vo.AccountVO;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

public class GreenStepMobileFormAuthenticationFilter
extends FormAuthenticationFilter {
    protected static Logger logger = Logger.getLogger(GreenStepBaseFormAuthenticationFilter.class);
    public static final String DEFAULT_CAPTCHA_PARAM = "captcha";
    private String captchaParam = "captcha";

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam(request, this.getCaptchaParam());
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    public void setCaptchaParam(String captchaParam) {
        this.captchaParam = captchaParam;
    }

    @Override
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = StringUtils.defaultString(this.getUsername(request));
        String password = StringUtils.defaultString(this.getPassword(request));
        String captcha = StringUtils.defaultString(this.getCaptcha(request));
        boolean rememberMe = false;
        String host = StringUtils.defaultString(this.getHost(request));
        char[] pwd = null;
        try {
            ShiroLoginSupport loginSupport = new ShiroLoginSupport();
            pwd = loginSupport.getAccountService().tranPassword(password).toCharArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new GreenStepBaseUsernamePasswordToken(username, pwd, rememberMe, host, captcha);
    }

    protected void doCaptchaValidate(HttpServletRequest request, GreenStepBaseUsernamePasswordToken token) {
        if (!"Y".equals(Constants.getLoginCaptchaCodeEnable())) {
            return;
        }
        Object sessCaptcha = SecurityUtils.getSubject().getSession().getAttribute("KAPTCHA_SESSION_KEY");
        String inputCaptcha = token.getCaptcha();
        if (!(sessCaptcha instanceof String) || StringUtils.isBlank(inputCaptcha)) {
            throw new IncorrectCaptchaException("captcha error!");
        }
        if (!inputCaptcha.equals(sessCaptcha)) {
            throw new IncorrectCaptchaException("captcha error!");
        }
    }

    @Override
    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        GreenStepBaseUsernamePasswordToken token = (GreenStepBaseUsernamePasswordToken)this.createToken(request, response);
        try {
            this.doCaptchaValidate((HttpServletRequest)request, token);
            ShiroLoginSupport loginSupport = new ShiroLoginSupport();
            AccountVO account = loginSupport.queryUserValidate(token.getUsername());
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            this.setUserSession((HttpServletRequest)request, (HttpServletResponse)response, account);
            return this.onLoginSuccess(token, subject, request, response);
        }
        catch (AuthenticationException e) {
            UserAccountHttpSessionSupport.remove((HttpServletRequest)request);
            this.getSubject(request, response).logout();
            return this.onLoginFailure(token, e, request, response);
        }
    }

    @Override
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (!this.isAjaxRequest(httpServletRequest)) {
            httpServletResponse.sendRedirect(String.valueOf(httpServletRequest.getContextPath()) + this.getSuccessUrl());
        } else {
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            response.getWriter().write("{ \"success\":\"N\",\"message\":\"no authorize!\",\"login\":\"Y\",\"isAuthorize\":\"N\" }");
        }
        return false;
    }

    private void setUserSession(HttpServletRequest request, HttpServletResponse response, AccountVO account) throws Exception {
        Map<String, String> dataMap;
        String sysCurrentId;
        UserAccountHttpSessionSupport.create(request, (AccountObj)account, this.getLanguage(request));
        String httpSessionId = request.getSession().getId();
        if (StringUtils.isBlank(httpSessionId)) {
            httpSessionId = "NULL";
        }
        if (!StringUtils.isBlank(sysCurrentId = (dataMap = UserCurrentCookie.getCurrentData(request)).get("currentId"))) {
            UserAccountHttpSessionSupport.createSysCurrentId(request, sysCurrentId);
        }
    }

    protected boolean isAjaxRequest(HttpServletRequest request) {
        if (this.isDojoxContentPane(request)) {
            return false;
        }
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    @Override
    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        if (this.isAjaxRequest((HttpServletRequest)request)) {
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            response.getWriter().write("{ \"success\":\"N\",\"message\":\"Please login!\",\"login\":\"N\",\"isAuthorize\":\"N\" }");
            return;
        }
        if (this.isIframeMode((HttpServletRequest)request)) {
            WebUtils.issueRedirect(request, response, "/pages/system/error_static.jsp");
            return;
        }
        if (this.isDojoxContentPane((HttpServletRequest)request)) {
            WebUtils.issueRedirect(request, response, "/pages/system/login_again.jsp");
            return;
        }
        WebUtils.issueRedirect(request, response, this.getLoginUrl());
    }

    private boolean isDojoxContentPane(HttpServletRequest request) {
        String isDojoxContentPane = request.getParameter("isDojoxContentPane");
        return "Y".equals(isDojoxContentPane);
    }

    private boolean isIframeMode(HttpServletRequest request) {
        String isIframeMode = request.getParameter("isIframeMode");
        return "Y".equals(isIframeMode);
    }

    private String getLanguage(HttpServletRequest request) {
        String lang = request.getParameter("lang");
        if (StringUtils.isBlank(lang)) {
            lang = "en";
        }
        return lang;
    }
}

