/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.model.AccountObj;
import com.netsteadfast.greenstep.base.sys.IUSessLogHelper;
import com.netsteadfast.greenstep.base.sys.USessLogHelperImpl;
import com.netsteadfast.greenstep.base.sys.UserAccountHttpSessionSupport;
import com.netsteadfast.greenstep.base.sys.UserCurrentCookie;
import com.netsteadfast.greenstep.sys.GreenStepBaseUsernamePasswordToken;
import com.netsteadfast.greenstep.sys.IncorrectCaptchaException;
import com.netsteadfast.greenstep.sys.ShiroLoginSupport;
import com.netsteadfast.greenstep.sys.SysLoginLogSupport;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.AccountVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class GreenStepBaseFormAuthenticationFilter
extends FormAuthenticationFilter {
    protected static Logger logger = Logger.getLogger(GreenStepBaseFormAuthenticationFilter.class);
    public static final String CREATE_USER_DATA_LDAP_MODE_SCRIPT = "META-INF/create-user-data-ldap-mode.groovy";
    public static final String DEFAULT_CAPTCHA_PARAM = "captcha";
    private static String createUserDataLdapModeScript = "";
    private String captchaParam = "captcha";
    private IUSessLogHelper uSessLogHelper = new USessLogHelperImpl();

    public static String getCreateUserDataLdapModeScript() throws Exception {
        if (!StringUtils.isBlank(createUserDataLdapModeScript)) {
            return createUserDataLdapModeScript;
        }
        InputStream is = null;
        try {
            try {
                is = GreenStepBaseFormAuthenticationFilter.class.getClassLoader().getResource(CREATE_USER_DATA_LDAP_MODE_SCRIPT).openStream();
                createUserDataLdapModeScript = IOUtils.toString(is, "utf-8");
            }
            catch (IOException e) {
                e.printStackTrace();
                if (is != null) {
                    is.close();
                }
                is = null;
            }
            catch (Exception e) {
                block11: {
                    e.printStackTrace();
                    if (is == null) break block11;
                    is.close();
                }
                is = null;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            is = null;
        }
        return createUserDataLdapModeScript;
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam(request, this.getCaptchaParam());
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    public void setCaptchaParam(String captchaParam) {
        this.captchaParam = captchaParam;
    }

    @Override
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = StringUtils.defaultString(this.getUsername(request));
        String password = StringUtils.defaultString(this.getPassword(request));
        String captcha = StringUtils.defaultString(this.getCaptcha(request));
        boolean rememberMe = false;
        String host = StringUtils.defaultString(this.getHost(request));
        char[] pwd = null;
        try {
            if (this.isLoginLdapMode()) {
                pwd = password.toCharArray();
            } else {
                ShiroLoginSupport loginSupport = new ShiroLoginSupport();
                pwd = loginSupport.getAccountService().tranPassword(password).toCharArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new GreenStepBaseUsernamePasswordToken(username, pwd, rememberMe, host, captcha);
    }

    protected void doCaptchaValidate(HttpServletRequest request, GreenStepBaseUsernamePasswordToken token) {
        if (!"Y".equals(Constants.getLoginCaptchaCodeEnable())) {
            return;
        }
        Object sessCaptcha = SecurityUtils.getSubject().getSession().getAttribute("KAPTCHA_SESSION_KEY");
        String inputCaptcha = token.getCaptcha();
        if (!(sessCaptcha instanceof String) || StringUtils.isBlank(inputCaptcha)) {
            throw new IncorrectCaptchaException("captcha error!");
        }
        if (!inputCaptcha.equals(sessCaptcha)) {
            throw new IncorrectCaptchaException("captcha error!");
        }
    }

    @Override
    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        GreenStepBaseUsernamePasswordToken token = (GreenStepBaseUsernamePasswordToken)this.createToken(request, response);
        try {
            this.doCaptchaValidate((HttpServletRequest)request, token);
            ShiroLoginSupport loginSupport = new ShiroLoginSupport();
            AccountVO account = loginSupport.queryUserValidate(token.getUsername());
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            if (this.isLoginLdapMode() && account == null) {
                account = this.createUserDataLdapLoginMode(token.getUsername(), new String(token.getPassword()));
            }
            this.setUserSession((HttpServletRequest)request, (HttpServletResponse)response, account);
            return this.onLoginSuccess(token, subject, request, response);
        }
        catch (AuthenticationException e) {
            logger.warn(e.getMessage().toString());
            UserAccountHttpSessionSupport.remove((HttpServletRequest)request);
            this.getSubject(request, response).logout();
            return this.onLoginFailure(token, e, request, response);
        }
    }

    @Override
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (!this.isAjaxRequest(httpServletRequest)) {
            httpServletResponse.sendRedirect(String.valueOf(httpServletRequest.getContextPath()) + this.getSuccessUrl());
        } else {
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            response.getWriter().write("{ \"success\":\"N\",\"message\":\"no authorize!\",\"login\":\"Y\",\"isAuthorize\":\"N\" }");
        }
        return false;
    }

    private void setUserSession(HttpServletRequest request, HttpServletResponse response, AccountVO account) throws Exception {
        UserAccountHttpSessionSupport.create(request, (AccountObj)account, this.getLanguage(request));
        String httpSessionId = request.getSession().getId();
        if (StringUtils.isBlank(httpSessionId)) {
            httpSessionId = "NULL";
        }
        if (Constants.getSystem().equals(Constants.getMainSystem())) {
            List<String> currs = this.uSessLogHelper.findCurrenrIdByAccount(account.getAccount(), httpSessionId);
            if (currs != null && currs.size() > 0) {
                UserCurrentCookie.setCurrentId(response, currs.get(0), request.getSession().getId(), account.getAccount(), this.getLanguage(request));
                UserAccountHttpSessionSupport.createSysCurrentId(request, currs.get(0));
            }
            SysLoginLogSupport.log(account.getAccount());
        } else {
            Map<String, String> dataMap = UserCurrentCookie.getCurrentData(request);
            String sysCurrentId = dataMap.get("currentId");
            if (!StringUtils.isBlank(sysCurrentId)) {
                UserAccountHttpSessionSupport.createSysCurrentId(request, sysCurrentId);
            }
        }
    }

    protected boolean isAjaxRequest(HttpServletRequest request) {
        if (this.isDojoxContentPane(request)) {
            return false;
        }
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    private boolean isLoginLdapMode() {
        try {
            if (AppContext.getBean("ldapContextFactory") != null && AppContext.getBean("ldapContextFactory") instanceof JndiLdapContextFactory) {
                return true;
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        if (!Constants.getSystem().equals(Constants.getMainSystem()) && !this.isAjaxRequest((HttpServletRequest)request)) {
            try {
                if (this.loginUseCurrentCookieForGeneralPackage(request, response)) {
                    String url = SimpleUtils.getHttpRequestUrl((HttpServletRequest)request);
                    logger.warn("URL = " + url);
                    WebUtils.issueRedirect(request, response, url);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.isAjaxRequest((HttpServletRequest)request)) {
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            response.getWriter().write("{ \"success\":\"N\",\"message\":\"Please login!\",\"login\":\"N\",\"isAuthorize\":\"N\" }");
            return;
        }
        if (this.isIframeMode((HttpServletRequest)request)) {
            WebUtils.issueRedirect(request, response, "/pages/system/error_static.jsp");
            return;
        }
        if (this.isDojoxContentPane((HttpServletRequest)request)) {
            WebUtils.issueRedirect(request, response, "/pages/system/login_again.jsp");
            return;
        }
        WebUtils.issueRedirect(request, response, this.getLoginUrl());
    }

    private boolean isDojoxContentPane(HttpServletRequest request) {
        String isDojoxContentPane = request.getParameter("isDojoxContentPane");
        return "Y".equals(isDojoxContentPane);
    }

    private boolean isIframeMode(HttpServletRequest request) {
        String isIframeMode = request.getParameter("isIframeMode");
        return "Y".equals(isIframeMode);
    }

    private boolean loginUseCurrentCookieForGeneralPackage(ServletRequest request, ServletResponse response) throws Exception {
        Map<String, String> dataMap = UserCurrentCookie.getCurrentData((HttpServletRequest)request);
        if (dataMap == null) {
            return false;
        }
        String currentId = dataMap.get("currentId");
        String accountId = dataMap.get("account");
        if (StringUtils.isBlank(currentId) || StringUtils.isBlank(accountId)) {
            return false;
        }
        if (this.uSessLogHelper.countByCurrent(accountId, currentId) < 1L) {
            return false;
        }
        String captchaStr = "0123";
        request.setAttribute(this.captchaParam, (Object)captchaStr);
        ((HttpServletRequest)request).getSession().setAttribute("KAPTCHA_SESSION_KEY", (Object)captchaStr);
        ShiroLoginSupport loginSupport = new ShiroLoginSupport();
        AccountVO account = loginSupport.queryUserValidate(accountId);
        loginSupport.forceCreateLoginSubject((HttpServletRequest)request, (HttpServletResponse)response, accountId, captchaStr);
        this.setUserSession((HttpServletRequest)request, (HttpServletResponse)response, account);
        return true;
    }

    private String getLanguage(HttpServletRequest request) {
        Map<String, String> dataMap;
        String lang = request.getParameter("lang");
        if (!Constants.getSystem().equals(Constants.getMainSystem()) && (dataMap = UserCurrentCookie.getCurrentData(request)) != null) {
            lang = dataMap.get("lang");
        }
        if (StringUtils.isBlank(lang)) {
            lang = "en";
        }
        return lang;
    }

    private AccountVO createUserDataLdapLoginMode(String account, String password) throws Exception {
        if (account.length() > 24) {
            throw new Exception("Create user data fail! account ID length more then 24.");
        }
        if (password.length() > 35) {
            throw new Exception("Create user data fail! password length more then 35.");
        }
        ShiroLoginSupport loginSupport = new ShiroLoginSupport();
        logger.info("create user data, login by LDAP mode, account: " + account);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("account", account);
        paramMap.put("transPassword", loginSupport.getAccountService().tranPassword(password));
        ScriptExpressionUtils.execute("GROOVY", GreenStepBaseFormAuthenticationFilter.getCreateUserDataLdapModeScript(), null, paramMap);
        return loginSupport.queryUser(account);
    }
}

