/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbSys;
import com.netsteadfast.greenstep.po.hbm.TbSysIcon;
import com.netsteadfast.greenstep.po.hbm.TbSysMenu;
import com.netsteadfast.greenstep.po.hbm.TbSysMenuRole;
import com.netsteadfast.greenstep.po.hbm.TbSysProg;
import com.netsteadfast.greenstep.po.hbm.TbSysProgMultiName;
import com.netsteadfast.greenstep.service.ISysIconService;
import com.netsteadfast.greenstep.service.ISysMenuRoleService;
import com.netsteadfast.greenstep.service.ISysMenuService;
import com.netsteadfast.greenstep.service.ISysProgMultiNameService;
import com.netsteadfast.greenstep.service.ISysProgService;
import com.netsteadfast.greenstep.service.ISysService;
import com.netsteadfast.greenstep.service.logic.ISystemProgramLogicService;
import com.netsteadfast.greenstep.util.LocaleLanguageUtils;
import com.netsteadfast.greenstep.vo.SysIconVO;
import com.netsteadfast.greenstep.vo.SysMenuRoleVO;
import com.netsteadfast.greenstep.vo.SysMenuVO;
import com.netsteadfast.greenstep.vo.SysProgMultiNameVO;
import com.netsteadfast.greenstep.vo.SysProgVO;
import com.netsteadfast.greenstep.vo.SysVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemProgramLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemProgramLogicServiceImpl
extends BaseLogicService
implements ISystemProgramLogicService {
    protected Logger logger = Logger.getLogger(SystemProgramLogicServiceImpl.class);
    private ISysIconService<SysIconVO, TbSysIcon, String> sysIconService;
    private ISysService<SysVO, TbSys, String> sysService;
    private ISysProgService<SysProgVO, TbSysProg, String> sysProgService;
    private ISysMenuService<SysMenuVO, TbSysMenu, String> sysMenuService;
    private ISysMenuRoleService<SysMenuRoleVO, TbSysMenuRole, String> sysMenuRoleService;
    private ISysProgMultiNameService<SysProgMultiNameVO, TbSysProgMultiName, String> sysProgMultiNameService;

    public ISysIconService<SysIconVO, TbSysIcon, String> getSysIconService() {
        return this.sysIconService;
    }

    @Autowired
    @Resource(name="core.service.SysIconService")
    @Required
    public void setSysIconService(ISysIconService<SysIconVO, TbSysIcon, String> sysIconService) {
        this.sysIconService = sysIconService;
    }

    public ISysService<SysVO, TbSys, String> getSysService() {
        return this.sysService;
    }

    @Autowired
    @Resource(name="core.service.SysService")
    @Required
    public void setSysService(ISysService<SysVO, TbSys, String> sysService) {
        this.sysService = sysService;
    }

    public ISysProgService<SysProgVO, TbSysProg, String> getSysProgService() {
        return this.sysProgService;
    }

    @Autowired
    @Resource(name="core.service.SysProgService")
    @Required
    public void setSysProgService(ISysProgService<SysProgVO, TbSysProg, String> sysProgService) {
        this.sysProgService = sysProgService;
    }

    public ISysMenuService<SysMenuVO, TbSysMenu, String> getSysMenuService() {
        return this.sysMenuService;
    }

    @Autowired
    @Resource(name="core.service.SysMenuService")
    @Required
    public void setSysMenuService(ISysMenuService<SysMenuVO, TbSysMenu, String> sysMenuService) {
        this.sysMenuService = sysMenuService;
    }

    public ISysMenuRoleService<SysMenuRoleVO, TbSysMenuRole, String> getSysMenuRoleService() {
        return this.sysMenuRoleService;
    }

    @Autowired
    @Resource(name="core.service.SysMenuRoleService")
    @Required
    public void setSysMenuRoleService(ISysMenuRoleService<SysMenuRoleVO, TbSysMenuRole, String> sysMenuRoleService) {
        this.sysMenuRoleService = sysMenuRoleService;
    }

    public ISysProgMultiNameService<SysProgMultiNameVO, TbSysProgMultiName, String> getSysProgMultiNameService() {
        return this.sysProgMultiNameService;
    }

    @Autowired
    @Resource(name="core.service.SysProgMultiNameService")
    @Required
    public void setSysProgMultiNameService(ISysProgMultiNameService<SysProgMultiNameVO, TbSysProgMultiName, String> sysProgMultiNameService) {
        this.sysProgMultiNameService = sysProgMultiNameService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysProgVO> create(SysProgVO sysProg, String sysOid, String iconOid) throws ServiceException, Exception {
        SysVO sys = new SysVO();
        sys.setOid(sysOid);
        DefaultResult<SysVO> sysResult = this.sysService.findObjectByOid(sys);
        if (sysResult.getValue() == null) {
            throw new ServiceException(sysResult.getSystemMessage().getValue());
        }
        sys = sysResult.getValue();
        SysIconVO sysIcon = new SysIconVO();
        sysIcon.setOid(iconOid);
        DefaultResult<SysIconVO> iconResult = this.sysIconService.findObjectByOid(sysIcon);
        if (iconResult.getValue() == null) {
            throw new ServiceException(iconResult.getSystemMessage().getValue());
        }
        sysIcon = iconResult.getValue();
        sysProg.setProgSystem(sys.getSysId());
        sysProg.setIcon(sysIcon.getIconId());
        return this.sysProgService.saveObject(sysProg);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysProgVO> update(SysProgVO sysProg, String sysOid, String iconOid) throws ServiceException, Exception {
        if (sysProg == null || StringUtils.isBlank(sysProg.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(sysOid);
        DefaultResult<SysVO> sysResult = this.sysService.findObjectByOid(sys);
        if (sysResult.getValue() == null) {
            throw new ServiceException(sysResult.getSystemMessage().getValue());
        }
        sys = sysResult.getValue();
        SysIconVO sysIcon = new SysIconVO();
        sysIcon.setOid(iconOid);
        DefaultResult<SysIconVO> iconResult = this.sysIconService.findObjectByOid(sysIcon);
        if (iconResult.getValue() == null) {
            throw new ServiceException(iconResult.getSystemMessage().getValue());
        }
        sysIcon = iconResult.getValue();
        sysProg.setProgSystem(sys.getSysId());
        sysProg.setIcon(sysIcon.getIconId());
        return this.sysProgService.updateObject(sysProg);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(SysProgVO sysProg) throws ServiceException, Exception {
        if (sysProg == null || StringUtils.isBlank(sysProg.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysProgVO> sysProgResult = this.sysProgService.findObjectByOid(sysProg);
        if (sysProgResult.getValue() == null) {
            throw new ServiceException(sysProgResult.getSystemMessage().getValue());
        }
        sysProg = sysProgResult.getValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("progId", sysProg.getProgId());
        if (this.sysMenuService.countByParams(params) > 0L) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0010"));
        }
        List sysMenuRoleList = this.sysMenuRoleService.findListByParams(params);
        int i = 0;
        while (sysMenuRoleList != null && i < sysMenuRoleList.size()) {
            TbSysMenuRole sysMenuRole = (TbSysMenuRole)sysMenuRoleList.get(i);
            this.sysMenuRoleService.delete(sysMenuRole);
            ++i;
        }
        List progMultiNames = this.sysProgMultiNameService.findListByParams(params);
        int i2 = 0;
        while (progMultiNames != null && i2 < progMultiNames.size()) {
            this.sysProgMultiNameService.delete((TbSysProgMultiName)progMultiNames.get(i2));
            ++i2;
        }
        return this.sysProgService.deleteObject(sysProg);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysProgMultiNameVO> createMultiName(SysProgMultiNameVO multiName) throws ServiceException, Exception {
        if (multiName == null || super.isBlank(multiName.getProgId()) || super.isBlank(multiName.getName()) || super.isBlank(multiName.getLocaleCode())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        if (LocaleLanguageUtils.getMap().get(multiName.getLocaleCode()) == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        SysProgVO sysProg = new SysProgVO();
        sysProg.setProgId(multiName.getProgId());
        DefaultResult<SysProgVO> progResult = this.sysProgService.findByUK(sysProg);
        if (progResult.getValue() == null) {
            throw new ServiceException(progResult.getSystemMessage().getValue());
        }
        super.setStringValueMaxLength(multiName, "name", 100);
        return this.sysProgMultiNameService.saveObject(multiName);
    }
}

