/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbSysMenu;
import com.netsteadfast.greenstep.po.hbm.TbSysProg;
import com.netsteadfast.greenstep.service.ISysMenuService;
import com.netsteadfast.greenstep.service.ISysProgService;
import com.netsteadfast.greenstep.service.logic.ISystemMenuLogicService;
import com.netsteadfast.greenstep.vo.SysMenuVO;
import com.netsteadfast.greenstep.vo.SysProgVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemMenuLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemMenuLogicServiceImpl
extends BaseLogicService
implements ISystemMenuLogicService {
    protected Logger logger = Logger.getLogger(SystemMenuLogicServiceImpl.class);
    private ISysProgService<SysProgVO, TbSysProg, String> sysProgService;
    private ISysMenuService<SysMenuVO, TbSysMenu, String> sysMenuService;

    public ISysProgService<SysProgVO, TbSysProg, String> getSysProgService() {
        return this.sysProgService;
    }

    @Autowired
    @Resource(name="core.service.SysProgService")
    @Required
    public void setSysProgService(ISysProgService<SysProgVO, TbSysProg, String> sysProgService) {
        this.sysProgService = sysProgService;
    }

    public ISysMenuService<SysMenuVO, TbSysMenu, String> getSysMenuService() {
        return this.sysMenuService;
    }

    @Autowired
    @Resource(name="core.service.SysMenuService")
    @Required
    public void setSysMenuService(ISysMenuService<SysMenuVO, TbSysMenu, String> sysMenuService) {
        this.sysMenuService = sysMenuService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public Map<String, List<SysProgVO>> findForMenuSettingsEnableAndAll(String folderProgramOid) throws ServiceException, Exception {
        if (StringUtils.isBlank(folderProgramOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysProgVO sysProg = new SysProgVO();
        sysProg.setOid(folderProgramOid);
        DefaultResult<SysProgVO> spResult = this.sysProgService.findObjectByOid(sysProg);
        if (spResult.getValue() == null) {
            throw new ServiceException(spResult.getSystemMessage().getValue());
        }
        sysProg = spResult.getValue();
        HashMap<String, List<SysProgVO>> dataMap = new HashMap<String, List<SysProgVO>>();
        SysMenuVO sysMenu = new SysMenuVO();
        List<Object> enableList = null;
        List<SysProgVO> allList = null;
        sysMenu.setProgId(sysProg.getProgId());
        sysMenu.setParentOid("00000000-0000-0000-0000-000000000000");
        DefaultResult<SysMenuVO> smResult = this.sysMenuService.findByUK(sysMenu);
        if (smResult.getValue() != null) {
            sysMenu = smResult.getValue();
            enableList = this.sysProgService.findForInTheFolderMenuItems(sysProg.getProgSystem(), sysMenu.getOid(), "ITEM");
        }
        allList = this.sysProgService.findForSystemItems(sysProg.getProgSystem());
        if (enableList == null) {
            enableList = new ArrayList();
        }
        if (allList == null) {
            allList = new ArrayList<SysProgVO>();
        }
        dataMap.put("enable", enableList);
        dataMap.put("all", allList);
        return dataMap;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> createOrUpdate(String folderProgramOid, List<String> childProgramOidList) throws ServiceException, Exception {
        if (StringUtils.isBlank(folderProgramOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(false);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0004")));
        SysProgVO sysProg = new SysProgVO();
        sysProg.setOid(folderProgramOid);
        DefaultResult<SysProgVO> spResult = this.sysProgService.findObjectByOid(sysProg);
        if (spResult.getValue() == null) {
            throw new ServiceException(spResult.getSystemMessage().getValue());
        }
        sysProg = spResult.getValue();
        SysMenuVO sysMenu = new SysMenuVO();
        sysMenu.setProgId(sysProg.getProgId());
        sysMenu.setParentOid("00000000-0000-0000-0000-000000000000");
        if (this.sysMenuService.countByUK(sysMenu) > 0) {
            DefaultResult<SysMenuVO> smResult = this.sysMenuService.findByUK(sysMenu);
            if (smResult.getValue() == null) {
                throw new ServiceException(smResult.getSystemMessage().getValue());
            }
            sysMenu = smResult.getValue();
        } else {
            sysMenu.setProgId(sysProg.getProgId());
            sysMenu.setParentOid("00000000-0000-0000-0000-000000000000");
            sysMenu.setEnableFlag("Y");
            DefaultResult<SysMenuVO> smResult = this.sysMenuService.saveObject(sysMenu);
            if (smResult.getValue() == null) {
                throw new ServiceException(smResult.getSystemMessage().getValue());
            }
            sysMenu = smResult.getValue();
        }
        this.removeMenuChildData(sysMenu);
        this.createOrUpdate(sysMenu, childProgramOidList);
        result.setValue(true);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    private void removeMenuChildData(SysMenuVO parentSysMenu) throws ServiceException, Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentOid", parentSysMenu.getOid());
        List sysMenuList = this.sysMenuService.findListByParams(params);
        if (sysMenuList == null || sysMenuList.size() < 1) {
            return;
        }
        for (TbSysMenu childSysMenu : sysMenuList) {
            this.sysMenuService.delete(childSysMenu);
        }
    }

    private void createOrUpdate(SysMenuVO parentSysMenu, List<String> childProgramOidList) throws ServiceException, Exception {
        for (String progOid : childProgramOidList) {
            SysProgVO sysProg = new SysProgVO();
            sysProg.setOid(progOid);
            DefaultResult<SysProgVO> spResult = this.sysProgService.findObjectByOid(sysProg);
            if (spResult.getValue() == null) {
                throw new ServiceException(spResult.getSystemMessage().getValue());
            }
            sysProg = spResult.getValue();
            SysMenuVO childSysMenu = new SysMenuVO();
            childSysMenu.setProgId(sysProg.getProgId());
            childSysMenu.setParentOid(parentSysMenu.getOid());
            childSysMenu.setEnableFlag("Y");
            DefaultResult<SysMenuVO> result = this.sysMenuService.saveObject(childSysMenu);
            if (result.getValue() != null) continue;
            throw new ServiceException(result.getSystemMessage().getValue());
        }
    }
}

