/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbSys;
import com.netsteadfast.greenstep.po.hbm.TbSysBeanHelp;
import com.netsteadfast.greenstep.po.hbm.TbSysBeanHelpExpr;
import com.netsteadfast.greenstep.po.hbm.TbSysBeanHelpExprMap;
import com.netsteadfast.greenstep.po.hbm.TbSysExpression;
import com.netsteadfast.greenstep.service.ISysBeanHelpExprMapService;
import com.netsteadfast.greenstep.service.ISysBeanHelpExprService;
import com.netsteadfast.greenstep.service.ISysBeanHelpService;
import com.netsteadfast.greenstep.service.ISysExpressionService;
import com.netsteadfast.greenstep.service.ISysService;
import com.netsteadfast.greenstep.service.logic.ISystemBeanHelpLogicService;
import com.netsteadfast.greenstep.vo.SysBeanHelpExprMapVO;
import com.netsteadfast.greenstep.vo.SysBeanHelpExprVO;
import com.netsteadfast.greenstep.vo.SysBeanHelpVO;
import com.netsteadfast.greenstep.vo.SysExpressionVO;
import com.netsteadfast.greenstep.vo.SysVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.SystemBeanHelpLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SystemBeanHelpLogicServiceImpl
extends BaseLogicService
implements ISystemBeanHelpLogicService {
    protected Logger logger = Logger.getLogger(SystemBeanHelpLogicServiceImpl.class);
    private ISysService<SysVO, TbSys, String> sysService;
    private ISysBeanHelpService<SysBeanHelpVO, TbSysBeanHelp, String> sysBeanHelpService;
    private ISysBeanHelpExprService<SysBeanHelpExprVO, TbSysBeanHelpExpr, String> sysBeanHelpExprService;
    private ISysBeanHelpExprMapService<SysBeanHelpExprMapVO, TbSysBeanHelpExprMap, String> sysBeanHelpExprMapService;
    private ISysExpressionService<SysExpressionVO, TbSysExpression, String> sysExpressionService;

    public ISysService<SysVO, TbSys, String> getSysService() {
        return this.sysService;
    }

    @Autowired
    @Resource(name="core.service.SysService")
    @Required
    public void setSysService(ISysService<SysVO, TbSys, String> sysService) {
        this.sysService = sysService;
    }

    public ISysBeanHelpService<SysBeanHelpVO, TbSysBeanHelp, String> getSysBeanHelpService() {
        return this.sysBeanHelpService;
    }

    @Autowired
    @Resource(name="core.service.SysBeanHelpService")
    @Required
    public void setSysBeanHelpService(ISysBeanHelpService<SysBeanHelpVO, TbSysBeanHelp, String> sysBeanHelpService) {
        this.sysBeanHelpService = sysBeanHelpService;
    }

    public ISysBeanHelpExprService<SysBeanHelpExprVO, TbSysBeanHelpExpr, String> getSysBeanHelpExprService() {
        return this.sysBeanHelpExprService;
    }

    @Autowired
    @Resource(name="core.service.SysBeanHelpExprService")
    @Required
    public void setSysBeanHelpExprService(ISysBeanHelpExprService<SysBeanHelpExprVO, TbSysBeanHelpExpr, String> sysBeanHelpExprService) {
        this.sysBeanHelpExprService = sysBeanHelpExprService;
    }

    public ISysBeanHelpExprMapService<SysBeanHelpExprMapVO, TbSysBeanHelpExprMap, String> getSysBeanHelpExprMapService() {
        return this.sysBeanHelpExprMapService;
    }

    @Autowired
    @Resource(name="core.service.SysBeanHelpExprMapService")
    @Required
    public void setSysBeanHelpExprMapService(ISysBeanHelpExprMapService<SysBeanHelpExprMapVO, TbSysBeanHelpExprMap, String> sysBeanHelpExprMapService) {
        this.sysBeanHelpExprMapService = sysBeanHelpExprMapService;
    }

    public ISysExpressionService<SysExpressionVO, TbSysExpression, String> getSysExpressionService() {
        return this.sysExpressionService;
    }

    @Autowired
    @Resource(name="core.service.SysExpressionService")
    @Required
    public void setSysExpressionService(ISysExpressionService<SysExpressionVO, TbSysExpression, String> sysExpressionService) {
        this.sysExpressionService = sysExpressionService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysBeanHelpVO> create(SysBeanHelpVO beanHelp, String systemOid) throws ServiceException, Exception {
        if (beanHelp == null || super.isBlank(systemOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sResult = this.sysService.findObjectByOid(sys);
        if (sResult.getValue() == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        sys = sResult.getValue();
        beanHelp.setSystem(sys.getSysId());
        return this.sysBeanHelpService.saveObject(beanHelp);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysBeanHelpVO> update(SysBeanHelpVO beanHelp, String systemOid) throws ServiceException, Exception {
        if (beanHelp == null || super.isBlank(beanHelp.getOid()) || super.isBlank(systemOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysVO sys = new SysVO();
        sys.setOid(systemOid);
        DefaultResult<SysVO> sResult = this.sysService.findObjectByOid(sys);
        if (sResult.getValue() == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        sys = sResult.getValue();
        beanHelp.setSystem(sys.getSysId());
        return this.sysBeanHelpService.updateObject(beanHelp);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(SysBeanHelpVO beanHelp) throws ServiceException, Exception {
        if (beanHelp == null || super.isBlank(beanHelp.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("helpOid", beanHelp.getOid());
        List exprList = this.sysBeanHelpExprService.findListByParams(params);
        int i = 0;
        while (exprList != null && i < exprList.size()) {
            TbSysBeanHelpExpr helpExpr = (TbSysBeanHelpExpr)exprList.get(i);
            params.clear();
            params.put("helpExprOid", helpExpr.getOid());
            List exprMapList = this.sysBeanHelpExprMapService.findListByParams(params);
            int j = 0;
            while (exprMapList != null && j < exprMapList.size()) {
                TbSysBeanHelpExprMap helpExprMap = (TbSysBeanHelpExprMap)exprMapList.get(j);
                this.sysBeanHelpExprMapService.delete(helpExprMap);
                ++j;
            }
            this.sysBeanHelpExprService.delete(helpExpr);
            ++i;
        }
        return this.sysBeanHelpService.deleteObject(beanHelp);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysBeanHelpExprVO> createExpr(SysBeanHelpExprVO beanHelpExpr, String helpOid, String expressionOid) throws ServiceException, Exception {
        if (beanHelpExpr == null || super.isBlank(helpOid) || super.isBlank(expressionOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysBeanHelpVO sysBeanHelp = new SysBeanHelpVO();
        sysBeanHelp.setOid(helpOid);
        DefaultResult<SysBeanHelpVO> mResult = this.sysBeanHelpService.findObjectByOid(sysBeanHelp);
        if (mResult.getValue() == null) {
            throw new ServiceException(mResult.getSystemMessage().getValue());
        }
        sysBeanHelp = mResult.getValue();
        SysExpressionVO sysExpression = new SysExpressionVO();
        sysExpression.setOid(expressionOid);
        DefaultResult<SysExpressionVO> exprResult = this.sysExpressionService.findObjectByOid(sysExpression);
        if (exprResult.getValue() == null) {
            throw new ServiceException(exprResult.getSystemMessage().getValue());
        }
        sysExpression = exprResult.getValue();
        beanHelpExpr.setHelpOid(sysBeanHelp.getOid());
        beanHelpExpr.setExprId(sysExpression.getExprId());
        return this.sysBeanHelpExprService.saveObject(beanHelpExpr);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteExpr(SysBeanHelpExprVO beanHelpExpr) throws ServiceException, Exception {
        if (beanHelpExpr == null || super.isBlank(beanHelpExpr.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<SysBeanHelpExprVO> oldResult = this.sysBeanHelpExprService.findObjectByOid(beanHelpExpr);
        if (oldResult.getValue() == null) {
            throw new ServiceException(oldResult.getSystemMessage().getValue());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("helpExprOid", oldResult.getValue().getOid());
        List mapList = this.sysBeanHelpExprMapService.findListByParams(params);
        int i = 0;
        while (mapList != null && i < mapList.size()) {
            this.sysBeanHelpExprMapService.delete((TbSysBeanHelpExprMap)mapList.get(i));
            ++i;
        }
        return this.sysBeanHelpExprService.deleteObject(beanHelpExpr);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<SysBeanHelpExprMapVO> createExprMap(SysBeanHelpExprMapVO beanHelpExprMap, String helpExprOid) throws ServiceException, Exception {
        if (beanHelpExprMap == null || super.isBlank(helpExprOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysBeanHelpExprVO sysBeanHelpExpr = new SysBeanHelpExprVO();
        sysBeanHelpExpr.setOid(helpExprOid);
        DefaultResult<SysBeanHelpExprVO> mResult = this.sysBeanHelpExprService.findObjectByOid(sysBeanHelpExpr);
        if (mResult.getValue() == null) {
            throw new ServiceException(mResult.getSystemMessage().getValue());
        }
        sysBeanHelpExpr = mResult.getValue();
        beanHelpExprMap.setHelpExprOid(sysBeanHelpExpr.getOid());
        return this.sysBeanHelpExprMapService.saveObject(beanHelpExprMap);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteExprMap(SysBeanHelpExprMapVO beanHelpExprMap) throws ServiceException, Exception {
        if (beanHelpExprMap == null || super.isBlank(beanHelpExprMap.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.sysBeanHelpExprMapService.deleteObject(beanHelpExprMap);
    }
}

